/*
 * Decompiled with CFR 0.152.
 */
package jfig.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import jfig.canvas.FigTrafo2D;
import jfig.java2d.FigArrow2D;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FillPatterns;
import jfig.objects.Point;
import jfig.utils.SetupManager;

public class FigTools2D {
    static boolean thinLinesHack = true;
    static BasicStroke defaultStroke = new BasicStroke();
    static int MAX_ARROW_STRIP_INDEX = 20;
    static int PIXEL_SIZE = 32;

    public static Point2D.Float[] convertToFloatPoints(Point[] pointArray) {
        int n = pointArray.length;
        Point2D.Float[] floatArray = new Point2D.Float[n];
        int n2 = 0;
        while (n2 < n) {
            floatArray[n2] = new Point2D.Float((float)pointArray[n2].x, (float)pointArray[n2].y);
            ++n2;
        }
        return floatArray;
    }

    public static Point[] convertToIntegerPoints(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray2[n2] = new Point((int)(pointArray[n2].x + 0.5), (int)(pointArray[n2].y + 0.5));
            ++n2;
        }
        return pointArray2;
    }

    public static GeneralPath createPath(Point[] pointArray, boolean bl) {
        return FigTools2D.createPath(pointArray, 0, pointArray.length - 1, bl);
    }

    public static GeneralPath createPath(Point[] pointArray, int n, int n2, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        if (pointArray != null && pointArray.length >= 1) {
            if (n < 0) {
                n = 0;
            }
            if (n >= pointArray.length - 1) {
                n = pointArray.length - 1;
            }
            if (n2 >= pointArray.length - 1) {
                n2 = pointArray.length - 1;
            }
            if (n >= n2) {
                n = n2;
            }
            generalPath.moveTo((float)pointArray[n].x, (float)pointArray[n].y);
            int n3 = n + 1;
            while (n3 <= n2) {
                generalPath.lineTo((float)pointArray[n3].x, (float)pointArray[n3].y);
                ++n3;
            }
            if (bl) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    private static final double _dist(Point point, Point point2) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    private static final Point getArrowCorrectedPoint(Point point, Point point2, double d) {
        double d2 = point2.x - point.x;
        double d3 = point2.y - point.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d4 == 0.0) {
            return new Point(point);
        }
        if (d4 < d) {
            return new Point(point);
        }
        double d5 = point2.x - d2 * d / d4;
        double d6 = point2.y - d3 * d / d4;
        return new Point(d5, d6);
    }

    public static GeneralPath createArrowCorrectedLine(Point[] pointArray, FigAttribs figAttribs) {
        double d;
        if (pointArray == null || pointArray.length < 2) {
            return new GeneralPath(0);
        }
        if (!SetupManager.getBoolean("jfig.java2d.FigTools2D.clipLinesUnderArrows", true)) {
            return FigTools2D.createPath(pointArray, false);
        }
        Point point = pointArray[0];
        if ((figAttribs.arrowMode & 2) != 0) {
            if (figAttribs.arrow_b_Style == 2) {
                point = pointArray[0];
            } else {
                double d2 = FigArrow2D.getLengthFactor(figAttribs.arrow_b_Style);
                d = figAttribs.arrow_b_Length;
                point = FigTools2D.getArrowCorrectedPoint(pointArray[1], pointArray[0], d2 * d);
            }
        }
        int n = pointArray.length - 1;
        Point point2 = pointArray[n];
        if ((figAttribs.arrowMode & 1) != 0) {
            if (figAttribs.arrow_f_Style == 2) {
                point2 = pointArray[n];
            } else {
                d = FigArrow2D.getLengthFactor(figAttribs.arrow_f_Style);
                double d3 = figAttribs.arrow_f_Length;
                point2 = FigTools2D.getArrowCorrectedPoint(pointArray[n - 1], pointArray[n], d * d3);
            }
        }
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo((float)point.x, (float)point.y);
        int n2 = 1;
        while (n2 < n) {
            generalPath.lineTo((float)pointArray[n2].x, (float)pointArray[n2].y);
            ++n2;
        }
        generalPath.lineTo((float)point2.x, (float)point2.y);
        return generalPath;
    }

    public static GeneralPath createArrowCorrectedPath(Point[] pointArray, FigAttribs figAttribs) {
        int n;
        int n2;
        if (pointArray == null || pointArray.length < 2) {
            return new GeneralPath(0);
        }
        if (!SetupManager.getBoolean("jfig.java2d.FigTools2D.clipLinesUnderArrows", true)) {
            return FigTools2D.createPath(pointArray, false);
        }
        if (pointArray.length <= 3) {
            return FigTools2D.createArrowCorrectedLine(pointArray, figAttribs);
        }
        int n3 = 0;
        if ((figAttribs.arrowMode & 2) != 0) {
            if (figAttribs.arrow_b_Style == 2) {
                n3 = 0;
            } else {
                double d = FigArrow2D.getLengthFactor(figAttribs.arrow_b_Style) * figAttribs.arrow_b_Length;
                n2 = Math.min(MAX_ARROW_STRIP_INDEX, pointArray.length);
                n = 1;
                while (n < n2) {
                    n3 = n;
                    double d2 = FigTools2D._dist(pointArray[0], pointArray[n]);
                    if (d2 > d) {
                        n3 = n - 1;
                        break;
                    }
                    ++n;
                }
            }
        }
        int n4 = pointArray.length - 1;
        if ((figAttribs.arrowMode & 1) != 0) {
            if (figAttribs.arrow_f_Style == 2) {
                n4 = pointArray.length - 1;
            } else {
                double d = FigArrow2D.getLengthFactor(figAttribs.arrow_f_Style) * figAttribs.arrow_f_Length;
                n = Math.max(pointArray.length - MAX_ARROW_STRIP_INDEX, 0);
                int n5 = pointArray.length - 1;
                while (n5 >= n) {
                    n4 = n5;
                    double d3 = FigTools2D._dist(pointArray[pointArray.length - 1], pointArray[n5]);
                    if (d3 > d) {
                        n4 = n5 + 1;
                        break;
                    }
                    --n5;
                }
            }
        }
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo((float)pointArray[n3].x, (float)pointArray[n3].y);
        n2 = n3 + 1;
        while (n2 < n4) {
            generalPath.lineTo((float)pointArray[n2].x, (float)pointArray[n2].y);
            ++n2;
        }
        generalPath.lineTo((float)pointArray[n4].x, (float)pointArray[n4].y);
        return generalPath;
    }

    public static void checkRestoreDashLength(FigAttribs figAttribs) {
        if (figAttribs.lineStyle != 0 && figAttribs.dashLength <= 0.0) {
            FigTools2D.msg("-W- found zero dash/dot length, restoring default 4");
            figAttribs.dashLength = 120.0;
        }
    }

    public static int getStrokeJoinStyle(FigAttribs figAttribs) {
        int n = 1;
        switch (figAttribs.fig_join_style) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public static int getStrokeCapStyle(FigAttribs figAttribs) {
        int n = 0;
        switch (figAttribs.fig_cap_style) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static BasicStroke createStroke(FigAttribs figAttribs) {
        int n = FigTools2D.getStrokeJoinStyle(figAttribs);
        int n2 = FigTools2D.getStrokeCapStyle(figAttribs);
        return FigTools2D.createStroke(figAttribs, n, n2);
    }

    public static BasicStroke createStroke(FigAttribs figAttribs, int n, int n2) {
        float f;
        BasicStroke basicStroke = null;
        float f2 = f = FigTools2D.getLineWidth(figAttribs.lineWidth);
        float f3 = 1.0f;
        float[] fArray = null;
        float f4 = 0.0f;
        FigTools2D.checkRestoreDashLength(figAttribs);
        switch (figAttribs.lineStyle) {
            case 0: {
                fArray = null;
                break;
            }
            case 1: {
                fArray = new float[]{(float)figAttribs.dashLength, (float)figAttribs.dashLength};
                break;
            }
            case 2: {
                fArray = new float[]{f, (float)figAttribs.dashLength};
                break;
            }
            case 3: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2};
                break;
            }
            case 4: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2, f2, f2};
                break;
            }
            case 5: {
                fArray = new float[]{(float)figAttribs.dashLength, f2, f2, f2, f2, f2, f2, f2};
                break;
            }
            default: {
                FigTools2D.msg("-W- unsupported line style: " + figAttribs.lineStyle);
                fArray = null;
            }
        }
        if (fArray != null) {
            try {
                basicStroke = new BasicStroke(f, n2, n, f3, fArray, f4);
            }
            catch (Throwable throwable) {
                FigTools2D.msg("-E- could not create dash/dot pattern stroke: " + throwable);
                FigTools2D.msg("-E- using solid line instead...");
                basicStroke = new BasicStroke(f, n2, n);
            }
        } else {
            basicStroke = new BasicStroke(f, n2, n);
        }
        return basicStroke;
    }

    public static Paint createPaint(FigAttribs figAttribs) {
        Paint paint = null;
        paint = figAttribs.fig_area_fill > 40 ? FillPatterns.getTexturePaint(figAttribs.fig_area_fill - 40 + 20, PIXEL_SIZE, figAttribs.lineColor, figAttribs.fillColor) : (figAttribs.fillStyle == 2 ? figAttribs.fillColor : null);
        return paint;
    }

    public static float getLineWidth(double d) {
        if (thinLinesHack) {
            if (d > 30.0) {
                return (float)(d - 30.0);
            }
            if (d > 0.0) {
                return 15.0f;
            }
            return 0.0f;
        }
        return (float)d;
    }

    public static AffineTransform createCompoundTransform(AffineTransform affineTransform, FigTrafo2D figTrafo2D) {
        AffineTransform affineTransform2 = FigTools2D.createTransform(figTrafo2D);
        affineTransform2.preConcatenate(affineTransform);
        return affineTransform2;
    }

    public static AffineTransform createTransform(FigTrafo2D figTrafo2D) {
        double d;
        double d2 = d = figTrafo2D.getZoomFactor() / 33.333333333333336;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d;
        double d6 = -1.0 * d * figTrafo2D.getAnchor().x;
        double d7 = -1.0 * d * figTrafo2D.getAnchor().y;
        return new AffineTransform(d2, d3, d4, d5, d6, d7);
    }

    public static Paint getTexture(FigAttribs figAttribs) {
        return FillPatterns.getTexturePaint(figAttribs.fig_area_fill - 40 + 20, PIXEL_SIZE, figAttribs.lineColor, figAttribs.fillColor);
    }

    public static FigArrow2D createFrontArrow(FigObject figObject, Point[] pointArray) {
        return FigTools2D.createFrontArrow(figObject, pointArray, 1);
    }

    public static FigArrow2D createFrontArrow(FigObject figObject, Point[] pointArray, int n) {
        if (figObject == null) {
            return null;
        }
        if (figObject.isClosed()) {
            return null;
        }
        FigAttribs figAttribs = figObject.getAttributes();
        if ((figAttribs.arrowMode & 1) == 0) {
            return null;
        }
        if (pointArray == null) {
            return null;
        }
        if (pointArray.length < 2) {
            return null;
        }
        int n2 = pointArray.length - 1;
        int n3 = Math.max(n2 - n, 0);
        return new FigArrow2D(figAttribs, pointArray[n3], pointArray[n2], true);
    }

    public static FigArrow2D createBackArrow(FigObject figObject, Point[] pointArray) {
        return FigTools2D.createBackArrow(figObject, pointArray, 1);
    }

    public static FigArrow2D createBackArrow(FigObject figObject, Point[] pointArray, int n) {
        if (figObject == null) {
            return null;
        }
        if (figObject.isClosed()) {
            return null;
        }
        FigAttribs figAttribs = figObject.getAttributes();
        if ((figAttribs.arrowMode & 2) == 0) {
            return null;
        }
        if (pointArray == null) {
            return null;
        }
        if (pointArray.length < 2) {
            return null;
        }
        int n2 = Math.min(n, pointArray.length - 1);
        return new FigArrow2D(figAttribs, pointArray[n2], pointArray[0], false);
    }

    public static void showPoints(Graphics graphics, FigTrafo2D figTrafo2D, Point[] pointArray) {
        if (pointArray == null) {
            return;
        }
        int n = 0;
        while (n < pointArray.length) {
            int n2 = figTrafo2D.wc_to_screen_x(pointArray[n].x);
            int n3 = figTrafo2D.wc_to_screen_y(pointArray[n].y);
            graphics.setColor(Color.black);
            graphics.fillRect(n2 - 2, n3 - 2, 5, 5);
            graphics.setColor(Color.white);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            ++n;
        }
    }

    public static void showPoints(Graphics graphics, FigTrafo2D figTrafo2D, FigBbox figBbox) {
        FigTools2D.showPoints(graphics, figTrafo2D, FigTools2D.convertToPoints(figBbox));
    }

    public static void showSelected(Graphics graphics, FigTrafo2D figTrafo2D, Point[] pointArray) {
        if (pointArray == null) {
            return;
        }
        int n = 0;
        while (n < pointArray.length) {
            int n2 = figTrafo2D.wc_to_screen_x(pointArray[n].x);
            int n3 = figTrafo2D.wc_to_screen_y(pointArray[n].y);
            graphics.setColor(Color.white);
            graphics.fillRect(n2 - 2, n3 - 2, 5, 5);
            graphics.setColor(Color.black);
            graphics.fillRect(n2 - 1, n3 - 1, 3, 3);
            ++n;
        }
    }

    public static void showSelected(Graphics graphics, FigTrafo2D figTrafo2D, FigBbox figBbox) {
        FigTools2D.showSelected(graphics, figTrafo2D, FigTools2D.convertToPoints(figBbox));
    }

    public static Point[] convertToPoints(FigBbox figBbox) {
        if (figBbox == null) {
            return null;
        }
        double d = figBbox.getXl();
        double d2 = figBbox.getYt();
        double d3 = figBbox.getXr();
        double d4 = figBbox.getYb();
        return new Point[]{new Point(d, d2), new Point(d3, d2), new Point(d3, d4), new Point(d, d4)};
    }

    public static void msg(String string) {
        System.err.println(string);
    }
}

