/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigSwingCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.ZoomListener;
import jfig.gui.FontCache;
import jfig.gui.JConsole;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.objects.Point;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.Format;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JFigViewerBean
extends JPanel
implements FigDrawableEnumerator {
    protected JConsole console;
    protected FigCanvas objectCanvas;
    protected FigAttribs attribs;
    protected FigParser parser;
    protected FigObjectList objectList;
    protected URL figURL;
    protected boolean debug;
    protected boolean antiAlias;
    protected boolean renderQuality;
    protected boolean showRulers;
    protected double zoomFactor;
    protected int gridMode;
    protected boolean enableRulerDragging;
    protected String iconpath;

    public void setURL(URL uRL) {
        try {
            this.figURL = uRL;
            if (this.debug) {
                JFigViewerBean.msg("-#- parsing: " + uRL.toExternalForm());
            }
            FigObjectList figObjectList = new FigObjectList();
            InputStream inputStream = uRL.openStream();
            this.parser.setFilenameAndType(uRL.toExternalForm(), "URL");
            this.parser.parse_fig_file_not_threaded(inputStream, true, false, false, this.attribs, this.objectCanvas.getTrafo(), figObjectList);
            if (this.debug) {
                JFigViewerBean.msg("-#- parser ok, repainting...");
            }
            this.objectList = figObjectList;
            this.objectCanvas.doFullRedraw();
        }
        catch (Exception exception) {
            JFigViewerBean.msg("-E- Could not parse FIG data from the following URL: " + uRL);
            exception.printStackTrace();
        }
    }

    public URL getURL() {
        return this.figURL;
    }

    public FigCanvas getFigCanvas() {
        return this.objectCanvas;
    }

    public void setFigCanvas(FigCanvas figCanvas) {
        this.objectCanvas = figCanvas;
        this.objectCanvas.setConsole(this.console);
        this.objectCanvas.showRulers(this.showRulers);
        this.objectCanvas.setEnableRulerDragging(this.enableRulerDragging);
        this.objectCanvas.getTrafo().setGridMode(0);
        this.objectCanvas.getTrafo().setSnapRelative(1);
        this.objectCanvas.getTrafo().set_zoom(this.zoomFactor);
        this.objectCanvas.setObjectEnumerator(this);
        this.objectCanvas.doFullRedraw();
        this.parser.setObjectPainter(this.objectCanvas);
    }

    public FigObjectList getObjectList() {
        return this.objectList;
    }

    public void setObjectList(FigObjectList figObjectList) {
        this.objectList = figObjectList;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public double getZoomFactor() {
        return this.objectCanvas.getTrafo().getZoomFactor();
    }

    public int getGridMode() {
        return this.objectCanvas.getTrafo().getGridMode();
    }

    public void setGridMode(int n) {
        this.objectCanvas.getTrafo().setGridMode(n);
    }

    public void setShowRulers(boolean bl) {
        this.showRulers = bl;
        this.objectCanvas.showRulers(bl);
    }

    public boolean getShowRulers() {
        return this.showRulers;
    }

    public void setEnableRulerDragging(boolean bl) {
        this.enableRulerDragging = bl;
        this.objectCanvas.setEnableRulerDragging(bl);
    }

    public boolean getEnableRulerDragging() {
        return this.enableRulerDragging;
    }

    public void setUnits(int n) {
        this.objectCanvas.getTrafo().setUnits(n);
        this.repaint();
    }

    public int getUnits() {
        return this.objectCanvas.getTrafo().getUnits();
    }

    public void setAnchor(Point point) {
        this.objectCanvas.getTrafo().setAnchor(point);
        this.repaint();
    }

    public Point getAnchor() {
        return this.objectCanvas.getTrafo().getAnchor();
    }

    public void setZoomFactor(double d) {
        double d2 = this.getZoomFactor();
        double d3 = d / d2;
        this.doZoomFactor(d3);
    }

    public void doZoomFit() {
        this.objectCanvas.doZoomFit();
    }

    public void setZoomFit() {
        this.doZoomFit();
    }

    public void doZoomFitAssumingDimension(Dimension dimension) {
        FigBbox figBbox = BoundingBoxCalculator.getBoundingBox(this.objectCanvas.getObjectEnumerator().getDrawableObjects());
        int n = 15;
        int n2 = 0;
        int n3 = this.showRulers ? 26 : 0;
        int n4 = this.showRulers ? 26 : 0;
        int n5 = 0;
        int n6 = n2 + n;
        int n7 = dimension.width - n3 - n;
        int n8 = n4 + n;
        int n9 = dimension.height - n5 - n;
        int n10 = Math.abs(n7 - n6);
        int n11 = Math.abs(n9 - n8);
        double d = figBbox.getXr() - figBbox.getXl();
        double d2 = figBbox.getYb() - figBbox.getYt();
        double d3 = 33.333333333333336 * (double)n10 / d;
        double d4 = 33.333333333333336 * (double)n11 / d2;
        double d5 = Math.min(d3, d4);
        int n12 = (n7 + n6) / 2;
        int n13 = (n8 + n9) / 2;
        double d6 = (figBbox.getXl() + figBbox.getXr()) / (double)2;
        double d7 = (figBbox.getYt() + figBbox.getYb()) / (double)2;
        int n14 = (int)(d6 - (double)n12 * 33.333333333333336 / d5);
        int n15 = (int)(d7 - (double)n13 * 33.333333333333336 / d5);
        this.objectCanvas.getTrafo().setAnchor(new Point(n14, n15));
        this.objectCanvas.getTrafo().set_zoom(d5);
        this.objectCanvas.doFullRedraw();
    }

    public void setRenderQuality(boolean bl) {
        this.renderQuality = bl;
        if (FigAttribs.enableJava2D) {
            this.objectCanvas.requestRenderQuality(bl);
            this.objectCanvas.doFullRedraw();
        }
    }

    public boolean getRenderQuality() {
        boolean bl = false;
        if (this.renderQuality && FigAttribs.enableJava2D) {
            bl = true;
        }
        return bl;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        if (FigAttribs.enableJava2D) {
            this.objectCanvas.requestAntiAliasing(bl);
            this.objectCanvas.doFullRedraw();
        }
    }

    public boolean getAntiAlias() {
        boolean bl = false;
        if (this.antiAlias && FigAttribs.enableJava2D) {
            bl = true;
        }
        return bl;
    }

    public void createDefaultKeyHandler() {
        DefaultKeyHandler defaultKeyHandler = new DefaultKeyHandler();
        this.objectCanvas.getComponent().addKeyListener(defaultKeyHandler);
    }

    public void createDefaultPopupMenu() {
        DefaultPopupMenu defaultPopupMenu = new DefaultPopupMenu(false);
        this.objectCanvas.getComponent().addMouseListener(defaultPopupMenu);
    }

    public void createDefaultPopupMenu(boolean bl) {
        DefaultPopupMenu defaultPopupMenu = new DefaultPopupMenu(bl);
        this.objectCanvas.getComponent().addMouseListener(defaultPopupMenu);
    }

    public void createDefaultDragHandler() {
        MouseDragHandler mouseDragHandler = new MouseDragHandler();
        this.objectCanvas.getComponent().addMouseListener(mouseDragHandler);
        this.objectCanvas.getComponent().addMouseMotionListener(mouseDragHandler);
    }

    public void createPositionAndZoomPanel() {
        PositionAndZoomPanel positionAndZoomPanel = new PositionAndZoomPanel();
        this.objectCanvas.getComponent().addMouseMotionListener(positionAndZoomPanel);
        this.objectCanvas.addZoomListener(positionAndZoomPanel);
        this.add("South", positionAndZoomPanel);
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public void NOT_YET() {
        JFigViewerBean.msg("-E- NOT YET IMPLEMENTED: ");
        Thread.dumpStack();
    }

    public Icon getIcon() {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(this.iconpath);
        }
        catch (Throwable throwable) {
            JFigViewerBean.msg("-W- doShowAbout: icon not found: " + this.iconpath);
        }
        return imageIcon;
    }

    public void doShowAbout() {
        JOptionPane.showMessageDialog(this, "JFigViewerBean: a Java bean component\nto display FIG drawings and graphics.\n(C) 1997-2008 F.N.Hendrich\n", "About JFigViewerBean", 1, this.getIcon());
    }

    public void doShowMessages() {
        this.console.show();
    }

    public void doShowHelpTopics() {
        JOptionPane.showMessageDialog(this, "For help about JFigViewerBean please visit:\nhttp://tams-www.informatik.uni-hamburg.de/applets/jfig/\n", "JFigViewerBean help", 1, this.getIcon());
    }

    public void doSelectURL() {
        String string;
        if (this.debug) {
            JFigViewerBean.msg("-#- doSelectURL...");
        }
        String string2 = "http://134.100.13.180/applets/jfig/examples/welcome.fig";
        if (this.figURL != null) {
            string2 = this.figURL.toExternalForm();
        }
        if ((string = JOptionPane.showInputDialog(this, "Enter the URL to parse:\n(e.g. 'file:/c:/temp/data.fig')", string2)) == null) {
            return;
        }
        try {
            URL uRL = new URL(string);
            this.setURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            JFigViewerBean.msg("-W- Malformed URL: ");
        }
    }

    public void doExit() {
        try {
            System.exit(0);
        }
        catch (Throwable throwable) {
            JFigViewerBean.msg("-E- internal error: couldn't exit: " + throwable);
        }
    }

    public void doZoomFactor(double d) {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        Dimension dimension = this.objectCanvas.getSize();
        int n = figTrafo2D.screen_to_wc(dimension.width);
        int n2 = figTrafo2D.screen_to_wc(dimension.height);
        double d2 = figTrafo2D.getZoom();
        Point point = figTrafo2D.getAnchor();
        figTrafo2D.set_zoom(d * d2);
        figTrafo2D.setAnchor(new Point(point.x + (double)((int)(0.5 * (1.0 - 1.0 / d) * (double)n)), point.y + (double)((int)(0.5 * (1.0 - 1.0 / d) * (double)n2))));
        this.objectCanvas.doFullRedraw();
        this.objectCanvas.notifyZoomListeners();
    }

    public void doZoom11() {
        this.objectCanvas.doZoomFull();
        this.objectCanvas.doPanning(0, false);
    }

    public void doZoomFitWidth() {
        this.NOT_YET();
    }

    public void doSpecifyZoomFactor() {
        double d;
        String string;
        if (this.debug) {
            JFigViewerBean.msg("-#- doSpecifyZoomFactor...");
        }
        if ((string = JOptionPane.showInputDialog(this, "Enter new zoom factor: (percent of original size)", "" + (d = (double)Math.round(100.0 * this.getZoomFactor())))) == null) {
            return;
        }
        try {
            double d2 = Double.valueOf(string.trim());
            this.setZoomFactor(0.01 * d2);
        }
        catch (Throwable throwable) {
            JFigViewerBean.msg("-W- in doSpecifyZoomFactor: " + throwable);
        }
    }

    public void doPanHome(Object object) {
        this.objectCanvas.doPanning(0, false);
    }

    public void doPanLeft(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(1, bl);
    }

    public void doPanRight(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(2, bl);
    }

    public void doPanUp(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(3, bl);
    }

    public void doPanDown(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(4, bl);
    }

    public void doSpecifyAnchor() {
        if (this.debug) {
            JFigViewerBean.msg("-#- doSpecifyAnchor...");
        }
        Point point = this.objectCanvas.getTrafo().getAnchor();
        String string = JOptionPane.showInputDialog(this, "Enter new anchor: (x,y coordinates at 2400dpi\nof the top-left viewport corner)", point.x + "  " + point.y);
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            this.objectCanvas.getTrafo().setAnchor(new Point(n, n2));
            this.objectCanvas.doFullRedraw();
        }
        catch (Throwable throwable) {
            JFigViewerBean.msg("-W- in doSpecifyAnchor: " + throwable);
        }
    }

    public void doToggleAntiAlias() {
        this.setAntiAlias(this.getAntiAlias() ^ true);
    }

    public void doToggleRenderQuality() {
        this.setRenderQuality(this.getRenderQuality() ^ true);
    }

    public void doToggleShowRulers() {
        this.setShowRulers(this.getShowRulers() ^ true);
        this.objectCanvas.doFullRedraw();
    }

    public void doToggleUnits() {
        int n = this.getUnits();
        if (n == 1) {
            this.setUnits(3);
        } else if (n == 3) {
            this.setUnits(2);
        } else {
            this.setUnits(1);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void doToggleGridMode() {
        int n = this.objectCanvas.getTrafo().getGridMode();
        switch (n) {
            case 0: {
                n = 960;
                break;
            }
            case 960: {
                n = 480;
                break;
            }
            case 480: {
                n = 240;
                break;
            }
            case 240: {
                n = 961;
                break;
            }
            case 961: {
                n = 0;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.objectCanvas.getTrafo().setGridMode(n);
        this.objectCanvas.doFullRedraw();
    }

    public void doFullRedraw() {
        this.objectCanvas.doFullRedraw();
    }

    public Enumeration getDrawableObjects() {
        return this.objectList.elements();
    }

    public FigDrawable getTmpObject() {
        return null;
    }

    public static JFigViewerBean createViewer(String string) {
        JFigViewerBean jFigViewerBean = new JFigViewerBean();
        try {
            jFigViewerBean.setURL(new URL(string));
        }
        catch (Exception exception) {
            JFigViewerBean.msg("-E- " + exception);
            exception.printStackTrace();
        }
        jFigViewerBean.setPreferredSize(new Dimension(600, 500));
        jFigViewerBean.createDefaultPopupMenu(false);
        jFigViewerBean.createDefaultKeyHandler();
        jFigViewerBean.createDefaultDragHandler();
        jFigViewerBean.createPositionAndZoomPanel();
        jFigViewerBean.setDebug(false);
        jFigViewerBean.setAntiAlias(false);
        jFigViewerBean.setRenderQuality(true);
        jFigViewerBean.setShowRulers(false);
        jFigViewerBean.setGridMode(0);
        jFigViewerBean.setUnits(1);
        jFigViewerBean.getFigCanvas().getTrafo().setSnapRelative(3);
        return jFigViewerBean;
    }

    public static JFrame createFrame(JFigViewerBean jFigViewerBean) {
        JFrame jFrame = new JFrame("jfig viewer");
        jFrame.getContentPane().add("Center", jFigViewerBean);
        jFrame.setDefaultCloseOperation(1);
        jFrame.pack();
        jFigViewerBean.doZoomFit();
        jFigViewerBean.doFullRedraw();
        return jFrame;
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        JFigViewerBean jFigViewerBean = new JFigViewerBean();
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            if (string == null) {
                serializable = jFigViewerBean.getClass().getResource("/jfig/examples/house.fig");
                jFigViewerBean.setURL((URL)serializable);
            } else {
                jFigViewerBean.setURL(new URL(string));
            }
        }
        catch (Exception exception) {
            JFigViewerBean.msg("-E- " + exception);
            exception.printStackTrace();
        }
        jFigViewerBean.setPreferredSize(new Dimension(600, 500));
        jFigViewerBean.createDefaultPopupMenu(true);
        jFigViewerBean.createDefaultKeyHandler();
        jFigViewerBean.createDefaultDragHandler();
        jFigViewerBean.createPositionAndZoomPanel();
        serializable = new JFrame("FigViewerBean Demo");
        ((JFrame)serializable).getContentPane().add("Center", jFigViewerBean);
        ((JFrame)serializable).setDefaultCloseOperation(3);
        ((Window)serializable).pack();
        ((Window)serializable).show();
        jFigViewerBean.setDebug(false);
        jFigViewerBean.setAntiAlias(false);
        jFigViewerBean.setRenderQuality(true);
        jFigViewerBean.setShowRulers(true);
        jFigViewerBean.setGridMode(480);
        jFigViewerBean.setUnits(1);
        jFigViewerBean.getFigCanvas().getTrafo().setSnapRelative(3);
        jFigViewerBean.doZoomFit();
        jFigViewerBean.doFullRedraw();
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.antiAlias = false;
        this.renderQuality = true;
        this.showRulers = false;
        this.enableRulerDragging = false;
        this.iconpath = "jfig/images/icon.gif";
    }

    public JFigViewerBean() {
        this.this();
        this.console = JConsole.getConsole();
        this.console.setPopupJConsoleOnWEF(false);
        this.attribs = new FigAttribs();
        this.objectList = new FigObjectList();
        this.parser = new FigParser();
        this.parser.setConsole(this.console);
        FigSwingCanvas figSwingCanvas = new FigSwingCanvas();
        figSwingCanvas.changeRubberbandMode(0);
        this.setFigCanvas(figSwingCanvas);
        this.setLayout(new BorderLayout());
        this.add("Center", this.objectCanvas.getComponent());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultKeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-#- keyPressed: " + keyEvent);
            }
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            if (keyEvent.isActionKey()) {
                if (JFigViewerBean.this.debug) {
                    JFigViewerBean.msg("-#- keyPressed.isActionKey: " + keyEvent);
                }
                switch (n) {
                    case 37: {
                        JFigViewerBean.this.doPanLeft(keyEvent);
                        break;
                    }
                    case 39: {
                        JFigViewerBean.this.doPanRight(keyEvent);
                        break;
                    }
                    case 40: {
                        JFigViewerBean.this.doPanDown(keyEvent);
                        break;
                    }
                    case 38: {
                        JFigViewerBean.this.doPanUp(keyEvent);
                        break;
                    }
                    case 36: {
                        JFigViewerBean.this.doPanHome(keyEvent);
                        break;
                    }
                    case 112: {
                        JFigViewerBean.this.doShowHelpTopics();
                        break;
                    }
                    case 116: {
                        JFigViewerBean.this.doFullRedraw();
                        break;
                    }
                    default: {
                        if (!JFigViewerBean.this.debug) break;
                        JFigViewerBean.msg("-#- Unhandled action key: " + keyEvent);
                    }
                }
                return;
            }
            switch (c) {
                case 'a': {
                    JFigViewerBean.this.doToggleAntiAlias();
                    break;
                }
                case 'b': {
                    JFigViewerBean.this.doToggleRenderQuality();
                    break;
                }
                case 'f': {
                    JFigViewerBean.this.doZoomFit();
                    break;
                }
                case 'F': {
                    JFigViewerBean.this.doZoom11();
                    break;
                }
                case 'g': {
                    JFigViewerBean.this.doToggleGridMode();
                    break;
                }
                case 'h': {
                    JFigViewerBean.this.doShowHelpTopics();
                    break;
                }
                case 'm': {
                    JFigViewerBean.this.doShowMessages();
                    break;
                }
                case 'r': {
                    JFigViewerBean.this.doToggleShowRulers();
                    break;
                }
                case 'u': {
                    JFigViewerBean.this.doToggleUnits();
                    break;
                }
                case 'z': {
                    JFigViewerBean.this.doZoomFactor(0.9090909090909091);
                    break;
                }
                case 'Z': {
                    JFigViewerBean.this.doZoomFactor(1.1);
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultPopupMenu
    implements ActionListener,
    MouseListener {
        JPopupMenu popup;
        String s_zoom;
        String s_zoom11;
        String s_zoomFit;
        String s_zoomWidth;
        String s_zoomOut;
        String s_zoomOut10;
        String s_zoomIn;
        String s_zoomIn10;
        String s_zoomFactor;
        String s_options;
        String s_antialias;
        String s_renderQ;
        String s_rulers;
        String s_units;
        String s_grid;
        String s_redraw;
        String s_help;
        String s_about;
        String s_topics;
        String s_messages;
        String s_select;
        String s_exit;
        String s_pan;
        String s_anchor;
        String s_home;
        String s_left;
        String s_right;
        String s_up;
        String s_down;

        void cpmi(JComponent jComponent, String string) {
            this.cpmi(jComponent, string, null);
        }

        void cpmi(JComponent jComponent, String string, String string2) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(this);
            if (string2 != null) {
                try {
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2));
                }
                catch (Throwable throwable) {}
            }
            jComponent.add(jMenuItem);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-#- DPM.actionPerformed: " + actionEvent);
            }
            if (this.s_about.equals(string = actionEvent.getActionCommand())) {
                JFigViewerBean.this.doShowAbout();
            } else if (this.s_messages.equals(string)) {
                JFigViewerBean.this.doShowMessages();
            } else if (this.s_topics.equals(string)) {
                JFigViewerBean.this.doShowHelpTopics();
            } else if (this.s_select.equals(string)) {
                JFigViewerBean.this.doSelectURL();
            } else if (this.s_exit.equals(string)) {
                JFigViewerBean.this.doExit();
            } else if (this.s_zoomIn.equals(string)) {
                JFigViewerBean.this.doZoomFactor(1.41);
            } else if (this.s_zoomIn10.equals(string)) {
                JFigViewerBean.this.doZoomFactor(1.1);
            } else if (this.s_zoomOut10.equals(string)) {
                JFigViewerBean.this.doZoomFactor(0.9090909090909091);
            } else if (this.s_zoomOut.equals(string)) {
                JFigViewerBean.this.doZoomFactor(0.7092198581560284);
            } else if (this.s_zoomFit.equals(string)) {
                JFigViewerBean.this.doZoomFit();
            } else if (this.s_zoomWidth.equals(string)) {
                JFigViewerBean.this.doZoomFitWidth();
            } else if (this.s_zoomFactor.equals(string)) {
                JFigViewerBean.this.doSpecifyZoomFactor();
            } else if (this.s_zoom11.equals(string)) {
                JFigViewerBean.this.doZoom11();
            } else if (this.s_home.equals(string)) {
                JFigViewerBean.this.doPanHome(null);
            } else if (this.s_right.equals(string)) {
                JFigViewerBean.this.doPanRight(null);
            } else if (this.s_left.equals(string)) {
                JFigViewerBean.this.doPanLeft(null);
            } else if (this.s_up.equals(string)) {
                JFigViewerBean.this.doPanUp(null);
            } else if (this.s_down.equals(string)) {
                JFigViewerBean.this.doPanDown(null);
            } else if (this.s_anchor.equals(string)) {
                JFigViewerBean.this.doSpecifyAnchor();
            } else if (this.s_antialias.equals(string)) {
                JFigViewerBean.this.doToggleAntiAlias();
            } else if (this.s_renderQ.equals(string)) {
                JFigViewerBean.this.doToggleRenderQuality();
            } else if (this.s_grid.equals(string)) {
                JFigViewerBean.this.doToggleGridMode();
            } else if (this.s_units.equals(string)) {
                JFigViewerBean.this.doToggleUnits();
            } else if (this.s_rulers.equals(string)) {
                JFigViewerBean.this.doToggleShowRulers();
            } else if (this.s_redraw.equals(string)) {
                JFigViewerBean.this.doFullRedraw();
            } else {
                JFigViewerBean.msg("-E- Unknown action command: " + string);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-#- DPM.mousePressed: " + mouseEvent);
            }
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(JFigViewerBean.this.objectCanvas.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                JFigViewerBean.this.objectCanvas.getComponent().requestFocus();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-#- DPM.mouseReleased: " + mouseEvent);
            }
            if (mouseEvent.isPopupTrigger()) {
                this.popup.show(JFigViewerBean.this.objectCanvas.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private final /* synthetic */ void this() {
            this.s_zoom = "zoom...";
            this.s_zoom11 = "zoom 1:1 (100%)";
            this.s_zoomFit = "zoom fit";
            this.s_zoomWidth = "zoom fit to width";
            this.s_zoomOut = "zoom out (0.7)";
            this.s_zoomOut10 = "zoom out (0.9)";
            this.s_zoomIn = "zoom in  (1.4)";
            this.s_zoomIn10 = "zoom in  (1.1)";
            this.s_zoomFactor = "set zoom factor...";
            this.s_options = "options";
            this.s_antialias = "toggle anti-aliasing";
            this.s_renderQ = "toggle render-quality";
            this.s_rulers = "toggle show rulers";
            this.s_units = "toggle units";
            this.s_grid = "toggle grid";
            this.s_redraw = "redraw";
            this.s_help = "help";
            this.s_about = "about...";
            this.s_topics = "topics...";
            this.s_messages = "messages...";
            this.s_select = "select URL...";
            this.s_exit = "exit";
            this.s_pan = "panning";
            this.s_anchor = "set anchor...";
            this.s_home = "home";
            this.s_left = "left";
            this.s_right = "right";
            this.s_up = "up";
            this.s_down = "down";
        }

        public DefaultPopupMenu() {
            this(false);
        }

        public DefaultPopupMenu(boolean bl) {
            this.this();
            this.popup = new JPopupMenu();
            this.cpmi(this.popup, this.s_select, "control O");
            this.popup.addSeparator();
            JMenu jMenu = new JMenu(this.s_zoom);
            this.cpmi(jMenu, this.s_zoom11, "shift F");
            this.cpmi(jMenu, this.s_zoomFit, "F");
            jMenu.addSeparator();
            this.cpmi(jMenu, this.s_zoomIn, null);
            this.cpmi(jMenu, this.s_zoomIn10, "shift Z");
            this.cpmi(jMenu, this.s_zoomOut10, "Z");
            this.cpmi(jMenu, this.s_zoomOut);
            jMenu.addSeparator();
            this.cpmi(jMenu, this.s_zoomFactor);
            JMenu jMenu2 = new JMenu(this.s_pan);
            this.cpmi(jMenu2, this.s_home);
            jMenu2.addSeparator();
            this.cpmi(jMenu2, this.s_left);
            this.cpmi(jMenu2, this.s_right);
            this.cpmi(jMenu2, this.s_up);
            this.cpmi(jMenu2, this.s_down);
            jMenu2.addSeparator();
            this.cpmi(jMenu2, this.s_anchor);
            JMenu jMenu3 = new JMenu(this.s_options);
            this.cpmi(jMenu3, this.s_antialias, "A");
            this.cpmi(jMenu3, this.s_renderQ, "B");
            jMenu3.addSeparator();
            this.cpmi(jMenu3, this.s_rulers, "R");
            this.cpmi(jMenu3, this.s_units, "U");
            this.cpmi(jMenu3, this.s_grid, "G");
            this.cpmi(jMenu3, this.s_redraw, "F5");
            JMenu jMenu4 = new JMenu(this.s_help);
            this.cpmi(jMenu4, this.s_about, "control H");
            this.cpmi(jMenu4, this.s_topics, "F1");
            this.cpmi(jMenu4, this.s_messages, "M");
            this.popup.add(jMenu);
            this.popup.add(jMenu2);
            this.popup.addSeparator();
            this.popup.add(jMenu3);
            this.popup.addSeparator();
            this.popup.add(jMenu4);
            if (bl) {
                this.popup.addSeparator();
                this.cpmi(this.popup, this.s_exit, null);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseDragHandler
    implements MouseListener,
    MouseMotionListener {
        int drag_base_x;
        int drag_base_y;
        Point drag_base_anchor;

        public void mousePressed(MouseEvent mouseEvent) {
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-W- MDH.mousePressed " + mouseEvent);
            }
            this.drag_base_x = mouseEvent.getX();
            this.drag_base_y = mouseEvent.getY();
            this.drag_base_anchor = new Point(JFigViewerBean.this.objectCanvas.getTrafo().getAnchor());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("MDH.mouseDragged from (" + this.drag_base_x + ',' + this.drag_base_y + ") to (" + n + ',' + n2 + ')');
            }
            FigTrafo2D figTrafo2D = JFigViewerBean.this.objectCanvas.getTrafo();
            int n3 = figTrafo2D.screen_to_wc(n - this.drag_base_x);
            int n4 = figTrafo2D.screen_to_wc(n2 - this.drag_base_y);
            if (this.drag_base_anchor == null) {
                return;
            }
            Point point = new Point(this.drag_base_anchor);
            point.x -= (double)n3;
            point.y -= (double)n4;
            figTrafo2D.setAnchor(point);
            JFigViewerBean.this.objectCanvas.doFullRedraw(20L);
        }

        private final /* synthetic */ void this() {
            this.drag_base_x = -1;
            this.drag_base_y = -1;
            this.drag_base_anchor = null;
        }

        public MouseDragHandler() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PositionAndZoomPanel
    extends JComponent
    implements MouseMotionListener,
    ZoomListener {
        private Font textFont;
        private FontMetrics fm;
        private Dimension dimension;
        private Format XF;
        private Format ZF;
        private int x;
        private int y;
        private int xoffset;
        private int baseline;
        private int font_height;

        public int measure() {
            this.fm = FontCache.getFontCache().getFontMetrics(this.textFont);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
            this.font_height = this.fm.getMaxAscent() + this.fm.getDescent();
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-I- JCanvasScroller.measure: height=" + this.dimension.height + " baseline= " + this.baseline + " fmMaxAscent= " + this.fm.getMaxAscent() + " fmAscent= " + this.fm.getAscent());
            }
            return this.xoffset + this.fm.stringWidth(this.getInfoLabel()) + this.xoffset;
        }

        public void setWidth(int n) {
            this.dimension.width = n;
        }

        public void setHeight(int n) {
            this.dimension.height = Math.max(n, this.font_height);
            this.baseline = this.fm.getMaxAscent() + (this.dimension.height - this.fm.getHeight()) / 2 + 1;
        }

        public String getInfoLabel() {
            return "(" + this.XF.form(this.x) + ',' + this.XF.form(this.y) + ") " + this.ZF.form(100.0 * JFigViewerBean.this.getZoomFactor()) + "% ";
        }

        public Dimension getPreferredSize() {
            return this.dimension;
        }

        public Dimension getMinimumSize() {
            return this.dimension;
        }

        public void paintComponent(Graphics graphics) {
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.getInfoLabel(), this.xoffset, this.baseline);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            FigTrafo2D figTrafo2D = JFigViewerBean.this.objectCanvas.getTrafo();
            Point point = figTrafo2D.getWorldCoordsSnapped(mouseEvent.getX(), mouseEvent.getY());
            this.x = (int)point.x;
            this.y = (int)point.y;
            this.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            FigTrafo2D figTrafo2D = JFigViewerBean.this.objectCanvas.getTrafo();
            Point point = figTrafo2D.getWorldCoordsSnapped(mouseEvent.getX(), mouseEvent.getY());
            this.x = (int)point.x;
            this.y = (int)point.y;
            this.repaint();
        }

        public void zoomChanged(Object object) {
            if (JFigViewerBean.this.debug) {
                JFigViewerBean.msg("-#- zoomChanged: " + object);
            }
            this.repaint();
        }

        private final /* synthetic */ void this() {
            this.textFont = new Font("MonoSpaced", 0, 12);
            this.XF = new Format("%05d");
            this.ZF = new Format("%7.2f");
            this.xoffset = 10;
            this.font_height = 40;
        }

        public PositionAndZoomPanel() {
            this.this();
            this.dimension = new Dimension(200, 25);
            this.setFont(this.textFont);
            this.measure();
        }
    }
}

