/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.net.URL;
import jfig.gui.ConsoleMessage;
import jfig.gui.InvertGrayFilter;
import jfig.utils.ExceptionTracer;
import jfig.utils.Pathname;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ImageHelper {
    static Component visibleParent = null;
    static ConsoleMessage printer = null;
    static String appletServerName = null;
    static String appletBaseDirName = null;
    static URL appletCodeBase = null;
    static boolean debug = false;
    static /* synthetic */ Class class$jfig$gui$ImageHelper;

    public static void setConsole(ConsoleMessage consoleMessage) {
        printer = consoleMessage;
    }

    public static void message(String string) {
        if (printer != null) {
            printer.consoleMessage(string);
        } else {
            System.out.println(string);
        }
    }

    public static void dbg(String string) {
        if (debug) {
            ImageHelper.message(string);
        }
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void trace(Throwable throwable) {
        ExceptionTracer.trace(throwable);
    }

    public static void setVisibleParent(Component component) {
        if (component == null) {
            return;
        }
        if (component.isShowing()) {
            visibleParent = component;
        } else if (System.getProperty("java.version").startsWith("1.1")) {
            ImageHelper.message("-W- Don't call setVisibleParent() without a visible AWT component! (ignored)");
        }
    }

    public static void checkParentIsVisible() {
        if (visibleParent == null) {
            Frame frame = new Frame("AWT dummy frame for image creation");
            frame.pack();
            visibleParent = frame;
        }
    }

    public static void setAppletServerName(String string) {
        appletServerName = string;
    }

    public static void setAppletBaseDir(String string) {
        appletBaseDirName = string;
    }

    public static Image loadResourceImage(String string) {
        ImageHelper.dbg("-I- loadResourceImage from: " + string);
        ImageHelper.checkParentIsVisible();
        URL uRL = null;
        Image image = null;
        MediaTracker mediaTracker = new MediaTracker(visibleParent);
        try {
            if (appletServerName == null) {
                Class clazz = class$jfig$gui$ImageHelper;
                if (clazz == null) {
                    clazz = class$jfig$gui$ImageHelper = ImageHelper.class("[Ljfig.gui.ImageHelper;", false);
                }
                uRL = clazz.getResource(Pathname.removeDoubleDots((String)string));
            } else {
                string = Pathname.removeDoubleDots((String)(appletServerName + appletBaseDirName + string));
                ImageHelper.dbg("-#- ImageHelper.loadResourceImage.applet: " + string);
                uRL = new URL(string);
            }
            if (uRL == null) {
                throw new Exception();
            }
            image = visibleParent.getToolkit().getImage(uRL);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForAll();
        }
        catch (Throwable throwable) {
            ImageHelper.message("-E- loadResourceImage failed: " + throwable);
            ImageHelper.message("-E- Could not find/access the resource: " + string);
            ImageHelper.trace(throwable);
        }
        if (mediaTracker.isErrorAny()) {
            boolean bl = false;
            ImageHelper.message("-E- loadResourceImage failed: MediaTracker error" + mediaTracker.statusAll(bl));
            ImageHelper.message("-E- Could not find/access the resource: " + string);
            return null;
        }
        ImageHelper.dbg("-I- got resource image: " + image);
        return image;
    }

    public static boolean loadViaMediaTracker(Image image) {
        ImageHelper.checkParentIsVisible();
        MediaTracker mediaTracker = new MediaTracker(visibleParent);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForAll();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static Image createImage(int n, int n2) {
        ImageHelper.checkParentIsVisible();
        Image image = visibleParent.createImage(n, n2);
        if (image == null) {
            ImageHelper.message("-E- failed to create image, due to AWT problems.");
        }
        return image;
    }

    public static Image createImage(ImageProducer imageProducer) {
        ImageHelper.checkParentIsVisible();
        Image image = visibleParent.createImage(imageProducer);
        return image;
    }

    public static Image findImage(String string, String string2, String string3) {
        ImageHelper.dbg("-#- findImage started: " + string + ' ' + string2 + ' ' + string3);
        Image image = null;
        if (string.equals("FILE")) {
            image = ImageHelper.findImageFromFile(string2, string3);
        } else if (string.equals("URL")) {
            image = ImageHelper.findImageFromURL(string2, string3);
        } else if (string.equals("RESOURCE")) {
            image = ImageHelper.findImageFromResource(string2, string3);
        } else {
            image = ImageHelper.findImageFromFile(string2, string3);
            if (image == null) {
                image = ImageHelper.findImageFromResource(string2, string3);
            }
            if (image == null) {
                image = ImageHelper.findImageFromURL(string2, string3);
            }
            if (image == null) {
                ImageHelper.message("-E- Couldn't find image: " + string2 + ' ' + string3);
            }
        }
        return image;
    }

    public static Image findImageFromURL(String string, String string2) {
        String string3 = new String(string);
        URL uRL = null;
        Image image = null;
        try {
            if (string2.indexOf("://") > 0) {
                image = ImageHelper.findImageFromURL(string2);
            } else if (string2.startsWith("file:")) {
                image = ImageHelper.findImageFromURL(string2);
            } else {
                if (string3.lastIndexOf("/") > 0) {
                    string3 = string3.substring(0, string3.lastIndexOf("/"));
                }
                uRL = new URL(string3 + '/' + string2);
                image = Toolkit.getDefaultToolkit().getImage(uRL);
                if (image != null) {
                    boolean bl = ImageHelper.loadViaMediaTracker(image);
                }
            }
        }
        catch (Throwable throwable) {
            ImageHelper.message("-E- findImageFromURL: " + throwable);
            ImageHelper.message("-I- basename=" + string3 + " imgname=" + string2);
            ImageHelper.message("-I- imageURL=" + uRL);
            ImageHelper.trace(throwable);
        }
        return image;
    }

    public static Image findImageFromURL(String string) {
        URL uRL = null;
        Image image = null;
        try {
            uRL = new URL(string);
            image = Toolkit.getDefaultToolkit().getImage(uRL);
            if (image != null) {
                boolean bl = ImageHelper.loadViaMediaTracker(image);
            }
        }
        catch (Throwable throwable) {
            ImageHelper.message("-W- invalid image URL: " + string);
            ImageHelper.message("-I- imageURL=" + uRL);
            ImageHelper.trace(throwable);
        }
        return image;
    }

    public static Image findImageFromFile(String string, String string2) {
        ImageHelper.dbg("-#- findImageFromFile: '" + string + "', '" + string2 + '\'');
        String string3 = new String(string);
        String string4 = null;
        Image image = null;
        try {
            if (string2.startsWith("/")) {
                string4 = string2;
            } else if (string2.indexOf(":\\") == 1) {
                string4 = string2;
            } else if (string3.lastIndexOf("/") > 0) {
                string3 = string3.substring(0, string3.lastIndexOf("/"));
                string4 = string3 + '/' + string2;
            } else if (string3.lastIndexOf("\\") > 0) {
                string3 = string3.substring(0, string3.lastIndexOf("\\"));
                string4 = string3 + '\\' + string2;
            } else {
                string4 = string2;
            }
            image = Toolkit.getDefaultToolkit().getImage(string4);
            if (image != null) {
                boolean bl = ImageHelper.loadViaMediaTracker(image);
            }
            if (image == null) {
                ImageHelper.message("-W- ImageHelper: could not find image file: " + string4);
            }
        }
        catch (Throwable throwable) {
            ImageHelper.message("-E- findImageFromFile: " + throwable);
            ImageHelper.message("-I- basename=" + string3 + " imgname=" + string2);
            ImageHelper.message("-I- image pathname=" + string4);
            ImageHelper.trace(throwable);
        }
        return image;
    }

    public static Image findImageFromResource(String string, String string2) {
        String string3 = new String(string);
        Image image = null;
        URL uRL = null;
        try {
            Class clazz;
            string3 = string3.lastIndexOf("/") > 0 ? string3.substring(0, string3.lastIndexOf("/")) : "";
            String string4 = Pathname.removeDoubleDots((String)(string3 + '/' + string2));
            if (!string4.startsWith("/")) {
                string4 = "/" + string4;
            }
            if (debug) {
                ImageHelper.message("-#- findImageFromResource: '" + string4 + '\'');
            }
            if ((clazz = class$jfig$gui$ImageHelper) == null) {
                clazz = class$jfig$gui$ImageHelper = ImageHelper.class("[Ljfig.gui.ImageHelper;", false);
            }
            uRL = clazz.getResource(string4);
            image = visibleParent.getToolkit().getImage(uRL);
            if (image != null) {
                boolean bl = ImageHelper.loadViaMediaTracker(image);
            }
        }
        catch (Throwable throwable) {
            ImageHelper.message("-E- findImageFromResource: " + throwable);
            ImageHelper.message("-I- basename=" + string3 + " imgname=" + string2);
            ImageHelper.message("-I- imageURL=" + uRL);
            ImageHelper.message("-#- visibleParent: " + visibleParent);
            ImageHelper.message("-#- Toolkit: " + visibleParent.getToolkit());
            ImageHelper.trace(throwable);
        }
        return image;
    }

    public static Image getFilteredImage(Image image, ImageFilter imageFilter) {
        ImageHelper.dbg("-I- getFilteredImage...");
        Image image2 = visibleParent.createImage(new FilteredImageSource(image.getSource(), imageFilter));
        return image2;
    }

    public static Image getInvertedImage(Image image) {
        ImageHelper.dbg("-I- getInvertedImage...");
        Image image2 = visibleParent.createImage(new FilteredImageSource(image.getSource(), new InvertGrayFilter()));
        return image2;
    }

    public static void main(String[] stringArray) {
        ImageHelper.message("-I- ImageHelper selftest...");
        Image image = ImageHelper.loadResourceImage("/jfig/images/icon.gif");
        Image image2 = ImageHelper.createImage(200, 300);
        ImageHelper.message("-I- selftest ok (Use CNTL-C to kill the dummy frame)");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

