/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.Hashtable;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigAttribs;
import jfig.utils.SetupManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FontCache {
    private static FontCache _fontCache = null;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    public static final String[] postscriptFontNames = new String[]{"Times Roman", "Times Italic", "Times Bold", "Times Bold Italic", "AvantGarde Book", "AvantGarde Book Oblique", "AvantGarde Demi", "AvantGarde Demi Oblique", "Bookman Light", "Bookman Light Italic", "Bookman Demi", "Bookman Demi Italic", "Courier", "Courier Oblique", "Courier Bold", "Courier Bold Oblique", "Helvetica", "Helvetica Oblique", "Helvetica Bold", "Helvetica Bold Oblique", "Helvetica Narrow", "Helvetica Narrow Oblique", "Helvetica Narrow Bold", "Helvetica Narrow Bold Oblique", "New Century Schoolbook Roman", "New Century Schoolbook Italic", "New Century Schoolbook Bold", "New Century Schoolbook Bold Italic", "Palatino Roman", "Palatino Italic", "Palatino Bold", "Palatino Bold Italic", "Symbol", "Zapf Chancery Medium Italic", "Zapf Dingbats"};
    public static final String[] cmFontNames = new String[]{"cmr", "cmti", "cmbx", "cmsl", "cmss", "cmssi", "cmtt", "cmitt", "cmsy", "cmbsy", "cmmi", "cmmib", "cmex", "msam", "msbm"};
    public static final float[] postscriptFontMetrics = new float[]{7.4f, 7.25f, 7.8f, 7.45f, 8.68f, 8.68f, 8.72f, 8.72f, 8.8f, 8.6f, 9.45f, 9.6f, 10.5f, 10.5f, 10.5f, 10.5f, 8.0f, 8.0f, 8.6f, 8.6f, 6.52f, 6.52f, 7.05f, 7.05f, 8.3f, 8.17f, 9.4f, 9.1f, 8.1f, 7.25f, 8.37f, 8.0f, 8.6f, 6.4f, 9.3f};
    public static final String[] texFontNames = new String[]{"Default font", "Roman", "Bold", "Italic", "Sans Serif", "Typewriter"};
    public static String[][] defaultFontMapping = new String[][]{{"jfig.gui.FontCache.Times-Roman", "TimesRoman,plain"}, {"jfig.gui.FontCache.Times-Italic", "TimesRoman,italic"}, {"jfig.gui.FontCache.Times-Bold", "TimesRoman,bold"}, {"jfig.gui.FontCache.Times-BoldItalic", "TimesRoman,bolditalic"}, {"jfig.gui.FontCache.AvantGarde-Book", "Helvetica,plain"}, {"jfig.gui.FontCache.AvantGarde-BookOblique", "Helvetica,italic"}, {"jfig.gui.FontCache.AvantGarde-Demi", "Helvetica,bold"}, {"jfig.gui.FontCache.AvantGarde-DemiOblique", "Helvetica,bolditalic"}, {"jfig.gui.FontCache.Bookman-Light", "TimesRoman,plain"}, {"jfig.gui.FontCache.Bookman-LightItalic", "TimesRoman,italic"}, {"jfig.gui.FontCache.Bookman-Demi", "TimesRoman,bold"}, {"jfig.gui.FontCache.Bookman-DemiItalic", "TimesRoman,bolditalic"}, {"jfig.gui.FontCache.Courier", "Courier,plain"}, {"jfig.gui.FontCache.Courier-Oblique", "Courier,italic"}, {"jfig.gui.FontCache.Courier-Bold", "Courier,bold"}, {"jfig.gui.FontCache.Courier-BoldOblique", "Courier,bolditalic"}, {"jfig.gui.FontCache.Helvetica", "Helvetica,plain"}, {"jfig.gui.FontCache.Helvetica-Oblique", "Helvetica,italic"}, {"jfig.gui.FontCache.Helvetica-Bold", "Helvetica,bold"}, {"jfig.gui.FontCache.Helvetica-BoldOblique", "Helvetica,bolditalic"}, {"jfig.gui.FontCache.Helvetica-Narrow", "Helvetica,plain"}, {"jfig.gui.FontCache.Helvetica-Narrow-Oblique", "Helvetica,italic"}, {"jfig.gui.FontCache.Helvetica-Narrow-Bold", "Helvetica,bold"}, {"jfig.gui.FontCache.Helvetica-Narrow-BoldOblique", "Helvetica,bolditalic"}, {"jfig.gui.FontCache.NewCenturySchlbk-Roman", "TimesRoman,plain"}, {"jfig.gui.FontCache.NewCenturySchlbk-Italic", "TimesRoman,italic"}, {"jfig.gui.FontCache.NewCenturySchlbk-Bold", "TimesRoman,bold"}, {"jfig.gui.FontCache.NewCenturySchlbk-BoldItalic", "TimesRoman,bolditalic"}, {"jfig.gui.FontCache.Palatino-Roman", "TimesRoman,plain"}, {"jfig.gui.FontCache.Palatino-Italic", "TimesRoman,italic"}, {"jfig.gui.FontCache.Palatino-Bold", "TimesRoman,bold"}, {"jfig.gui.FontCache.Palatino-BoldItalic", "TimesRoman,bolditalic"}, {"jfig.gui.FontCache.Symbol", "SansSerif,plain"}, {"jfig.gui.FontCache.ZapfChancery-MediumItalic", "TimesRoman,italic"}, {"jfig.gui.FontCache.ZapfDingbats", "Courier,plain"}, {"jfig.gui.FontCache.cmr10", "cmr10"}, {"jfig.gui.FontCache.cmti10", "cmti10"}, {"jfig.gui.FontCache.cmbx10", "cmbx10"}, {"jfig.gui.FontCache.cmss10", "cmss10"}, {"jfig.gui.FontCache.cmsl10", "cmsl10"}, {"jfig.gui.FontCache.cmtt10", "cmtt10"}, {"jfig.gui.FontCache.cmitt10", "cmtt10"}, {"jfig.gui.FontCache.cmmi10", "cmmi10"}, {"jfig.gui.FontCache.cmmib10", "cmmib10"}, {"jfig.gui.FontCache.cmsy10", "cmsy10"}, {"jfig.gui.FontCache.cmbsy10", "cmbsy10"}, {"jfig.gui.FontCache.cmex10", "cmex10"}, {"jfig.gui.FontCache.msam10", "msam10"}, {"jfig.gui.FontCache.msbm10", "msbm10"}};
    private Hashtable fontTable;
    private Hashtable fontMetricsTable;
    private Hashtable cmFontsTable;
    private ComputerModernFontsManager cmfManager;
    private boolean debug;
    private String[] fontDescriptions;
    private String[] fontNames;
    private int[] fontStyles;
    static /* synthetic */ Class class$jfig$gui$FontCache;

    public static FontCache getFontCache() {
        if (_fontCache == null) {
            _fontCache = new FontCache();
        }
        return _fontCache;
    }

    public void flushFontCache() {
        this.fontTable = new Hashtable();
        this.fontMetricsTable = new Hashtable();
    }

    public void set_debug(boolean bl) {
        this.debug = bl;
    }

    public void initializeFontDescriptions() {
        int n = 0;
        while (n < defaultFontMapping.length) {
            String string = defaultFontMapping[n][0];
            String string2 = defaultFontMapping[n][1];
            this.fontDescriptions[n] = SetupManager.getProperty(string, string2);
            ++n;
        }
    }

    public void dumpFontDescriptions() {
        System.out.println("-#- jfig.gui.FontCache.dumpFontAliasNames: ");
        int n = 0;
        while (n < this.fontDescriptions.length) {
            System.out.println("" + n + ' ' + this.fontDescriptions[n] + ' ' + this.fontNames[n] + ' ' + this.fontStyles[n]);
            ++n;
        }
    }

    public void parseFontDescriptions() {
        int n = 0;
        while (n < this.fontDescriptions.length) {
            try {
                String string = this.fontDescriptions[n].trim();
                this.fontNames[n] = string.indexOf(44) > 0 ? string.substring(0, string.indexOf(44)) : string;
                this.fontStyles[n] = string.indexOf(",bolditalic") > 0 ? 3 : (string.indexOf(",italic") > 0 ? 2 : (string.indexOf(",bold") > 0 ? 1 : 0));
            }
            catch (Exception exception) {
                System.err.println("-E- could not parse font description: '" + this.fontDescriptions[n] + "', substituting Courier");
                this.fontNames[n] = "Courier";
                this.fontStyles[n] = 0;
            }
            ++n;
        }
    }

    public int getFontIndex(String string) {
        int n = 0;
        int n2 = this.fontNames.length;
        while (n < n2) {
            if (this.fontNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 12;
    }

    public void put(Object object, int n, int n2) {
        Font font = null;
        String string = null;
        try {
            string = this.fontNames[n];
            Object v = this.cmFontsTable.get(string);
            font = v != null ? this.cmfManager.getDerivedFont((Font)v, n2) : new Font(this.fontNames[n], this.fontStyles[n], n2);
            if (this.debug) {
                System.out.println("-#- FontCache.put: " + n + ' ' + this.fontNames[n] + ' ' + this.fontStyles[n] + ' ' + n2 + ' ' + font.toString());
            }
        }
        catch (Exception exception) {
            font = new Font("Courier", 0, n2);
            System.err.println("-E- FontCache.put: " + this.fontNames[n] + " not found, using Courier instead.");
        }
        this.fontTable.put(object, font);
        this.fontMetricsTable.put(object, this.getFontMetrics(font));
    }

    public FontMetrics getFontMetrics(int n, int n2) {
        Integer n3 = new Integer((n << 16) + n2);
        FontMetrics fontMetrics = (FontMetrics)this.fontMetricsTable.get(n3);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        this.put(n3, n, n2);
        return (FontMetrics)this.fontMetricsTable.get(n3);
    }

    public FontMetrics getZoomedFontMetrics(FigAttribs figAttribs, FigTrafo2D figTrafo2D) {
        return this.getFontMetrics(figAttribs.fig_font, (int)((double)figAttribs.fontSize * figTrafo2D.getZoom() + 0.1));
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Font getFont(int n, int n2) {
        Integer n3 = new Integer((n << 16) + n2);
        Font font = (Font)this.fontTable.get(n3);
        if (font != null) {
            return font;
        }
        this.put(n3, n, n2);
        return (Font)this.fontTable.get(n3);
    }

    public void loadComputerModernFonts() {
        this.cmfManager = new ComputerModernFontsManager();
        this.cmfManager.loadComputerModernFonts();
    }

    public static void main(String[] stringArray) {
        System.out.println("FontCache test started...");
        SetupManager.loadGlobalProperties("jfig/jfig.cnf");
        FontCache fontCache = FontCache.getFontCache();
        Font font = fontCache.getFont(2, 12);
        Font font2 = fontCache.getFont(12, 24);
        Font font3 = fontCache.getFont(17, 17);
        System.out.println("Font examples: " + font + ',' + font2 + ',' + font3);
        fontCache.dumpFontDescriptions();
        System.out.println("cmmi10 font index: " + fontCache.getFontIndex("cmmi10"));
        System.out.println("cmsy10 font index: " + fontCache.getFontIndex("cmsy10"));
        System.exit(0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.cmfManager = null;
        this.debug = false;
    }

    private FontCache() {
        this.this();
        if (this.debug) {
            System.out.println("-#- FontCache<init>...");
        }
        this.fontTable = new Hashtable();
        this.fontMetricsTable = new Hashtable();
        this.cmFontsTable = new Hashtable();
        this.fontDescriptions = new String[defaultFontMapping.length];
        this.fontNames = new String[defaultFontMapping.length];
        this.fontStyles = new int[defaultFontMapping.length];
        this.initializeFontDescriptions();
        this.parseFontDescriptions();
        String string = System.getProperty("java.version");
        if (string.compareTo("1.3") >= 0) {
            this.loadComputerModernFonts();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ComputerModernFontsManager {
        public void loadComputerModernFonts() {
            int n = 0;
            while (n < cmFontNames.length) {
                try {
                    InputStream inputStream;
                    String string = "/jfig/fonts/" + cmFontNames[n] + "10.ttf";
                    Class clazz = class$jfig$gui$FontCache;
                    if (clazz == null) {
                        clazz = FontCache.class("[Ljfig.gui.FontCache;", false);
                    }
                    if ((inputStream = clazz.getResourceAsStream(string)) != null) {
                        Font font = Font.createFont(0, inputStream);
                        FontCache.this.cmFontsTable.put(cmFontNames[n] + "10", font);
                        if (FontCache.this.debug) {
                            System.out.println("-#- got CM font: " + font);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
        }

        public Font getDerivedFont(Font font, int n) {
            return font.deriveFont((float)n);
        }
    }
}

