/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.merge;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.merge.RepositoryMerger;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/geneticrepositorymerger"})
public class GeneticRepositoryMergerController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(GeneticRepositoryMergerController.class);
    public static final String ID = "geneticrepositorymerger";
    public static final String URI = "/plugin/geneticrepositorymerger";
    public static final DefaultAttributeMetaData CHROM = new DefaultAttributeMetaData("#CHROM", MolgenisFieldTypes.FieldTypeEnum.STRING);
    public static final DefaultAttributeMetaData POS = new DefaultAttributeMetaData("POS", MolgenisFieldTypes.FieldTypeEnum.LONG);
    public static final DefaultAttributeMetaData REF = new DefaultAttributeMetaData("REF", MolgenisFieldTypes.FieldTypeEnum.TEXT);
    public static final DefaultAttributeMetaData ALT = new DefaultAttributeMetaData("ALT", MolgenisFieldTypes.FieldTypeEnum.TEXT);
    private final ArrayList<AttributeMetaData> commonAttributes;
    private final RepositoryMerger repositoryMerger;
    private final DataService dataService;

    @Autowired
    public GeneticRepositoryMergerController(RepositoryMerger repositoryMerger, DataService dataService) {
        super(URI);
        this.repositoryMerger = repositoryMerger;
        this.dataService = dataService;
        this.commonAttributes = new ArrayList();
        this.commonAttributes.add(CHROM);
        this.commonAttributes.add(POS);
        this.commonAttributes.add(REF);
        this.commonAttributes.add(ALT);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) throws Exception {
        this.dataService.getEntityNames();
        ArrayList geneticRepositories = new ArrayList();
        this.dataService.getEntityNames().forEach(name -> {
            if (this.dataService.getEntityMetaData(name).getAttribute(CHROM.getName()) != null && this.dataService.getEntityMetaData(name).getAttribute(POS.getName()) != null && this.dataService.getEntityMetaData(name).getAttribute(REF.getName()) != null && this.dataService.getEntityMetaData(name).getAttribute(ALT.getName()) != null) {
                geneticRepositories.add(name);
            }
        });
        Iterable entitiesMeta = Iterables.transform(geneticRepositories, (Function)new /* Unavailable Anonymous Inner Class!! */);
        model.addAttribute("entitiesMeta", (Object)entitiesMeta);
        return "view-geneticrepositorymerger";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"mergeRepositories"})
    @ResponseBody
    public String merge(@RequestParam(value="resultDataset") String resultSet, @RequestParam(value="datasets") String[] inputSets) throws IOException {
        if (this.dataService.hasRepository(resultSet)) {
            throw new RuntimeException("An entity with this name already exists. Please try again with a different name");
        }
        ArrayList<Repository> geneticRepositories = new ArrayList<Repository>();
        for (String name : inputSets) {
            if (!name.equals(resultSet)) {
                if (!this.dataService.hasRepository(name)) {
                    throw new RuntimeException("Cannot merge Repository: " + name + " it does not exist");
                }
            } else {
                throw new RuntimeException("Cannot merge Repository with itself");
            }
            geneticRepositories.add(this.dataService.getRepository(name));
        }
        EntityMetaData mergedEntityMetaData = this.repositoryMerger.mergeMetaData(geneticRepositories, (List)this.commonAttributes, null, resultSet);
        Repository mergedRepository = this.dataService.getMeta().addEntityMeta(mergedEntityMetaData);
        this.repositoryMerger.merge(geneticRepositories, (List)this.commonAttributes, mergedRepository);
        return resultSet;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }

    static /* synthetic */ DataService access$000(GeneticRepositoryMergerController x0) {
        return x0.dataService;
    }
}

