/* File:        molgenis/model/JDBCDatabase
 * Copyright:   Inventory 2000-2015, GBIC 2002-2015, all rights reserved
 * Date:        June 8, 2015
 * 
 * generator:   org.molgenis.generators.db.JDBCMetaDatabaseGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Vector;

import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Field;
import org.molgenis.model.MolgenisModelException;

/**
 * This class is an in memory representation of the contents of your *_db.xml file
 * Utility of this class is to allow for dynamic querying and/or user interfacing
 * for example within a query tool or a security module.
 */
public class JDBCMetaDatabase extends Model
{
	private static final long serialVersionUID = 1L;
	
	public JDBCMetaDatabase()
	{
		super("molgenis");
		try
		{
			//MolgenisUser
			Entity molgenisUser_entity = new Entity("MolgenisUser",this.getDatabase());
			molgenisUser_entity.setSystem(true);
			molgenisUser_entity.setAbstract(false);
			molgenisUser_entity.setDescription("Anyone who can login");
			molgenisUser_entity.setXrefLabels(Arrays.asList(new String[]{"username"}));
			Field molgenisUser_id_field = new Field(molgenisUser_entity, "id", MolgenisFieldTypes.getType("string"));
			molgenisUser_id_field.setAuto(true);
			molgenisUser_id_field.setDescription("automatically generated internal id, only for internal use.");
			molgenisUser_id_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_id_field);
			Field molgenisUser_username_field = new Field(molgenisUser_entity, "username", MolgenisFieldTypes.getType("string"));
			molgenisUser_username_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_username_field);
			Field molgenisUser_password__field = new Field(molgenisUser_entity, "password_", MolgenisFieldTypes.getType("string"));
			molgenisUser_password__field.setDescription("big fixme: password type");
			molgenisUser_password__field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_password__field);
			Field molgenisUser_activationCode_field = new Field(molgenisUser_entity, "activationCode", MolgenisFieldTypes.getType("string"));
			molgenisUser_activationCode_field.setDescription("Used as alternative authentication mechanism to verify user email and/or if user has lost password.");
			molgenisUser_activationCode_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_activationCode_field);
			Field molgenisUser_active_field = new Field(molgenisUser_entity, "active", MolgenisFieldTypes.getType("bool"));
			molgenisUser_active_field.setDevaultValue("false");
			molgenisUser_active_field.setDescription("Boolean to indicate if this account can be used to login");
			molgenisUser_active_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_active_field);
			Field molgenisUser_superuser_field = new Field(molgenisUser_entity, "superuser", MolgenisFieldTypes.getType("bool"));
			molgenisUser_superuser_field.setDevaultValue("false");
			molgenisUser_superuser_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_superuser_field);
			Field molgenisUser_firstName_field = new Field(molgenisUser_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			molgenisUser_firstName_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_firstName_field);
			Field molgenisUser_middleNames_field = new Field(molgenisUser_entity, "MiddleNames", MolgenisFieldTypes.getType("string"));
			molgenisUser_middleNames_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_middleNames_field);
			Field molgenisUser_lastName_field = new Field(molgenisUser_entity, "LastName", MolgenisFieldTypes.getType("string"));
			molgenisUser_lastName_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_lastName_field);
			Field molgenisUser_title_field = new Field(molgenisUser_entity, "Title", MolgenisFieldTypes.getType("string"));
			molgenisUser_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			molgenisUser_title_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_title_field);
			Field molgenisUser_affiliation_field = new Field(molgenisUser_entity, "Affiliation", MolgenisFieldTypes.getType("string"));
			molgenisUser_affiliation_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_affiliation_field);
			Field molgenisUser_department_field = new Field(molgenisUser_entity, "Department", MolgenisFieldTypes.getType("string"));
			molgenisUser_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			molgenisUser_department_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_department_field);
			Field molgenisUser_role_field = new Field(molgenisUser_entity, "Role", MolgenisFieldTypes.getType("string"));
			molgenisUser_role_field.setDescription("Indicate role of the contact, e.g. lab worker or PI.");
			molgenisUser_role_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_role_field);
			Field molgenisUser_address_field = new Field(molgenisUser_entity, "Address", MolgenisFieldTypes.getType("text"));
			molgenisUser_address_field.setDescription("The address of the Contact.");
			molgenisUser_address_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_address_field);
			Field molgenisUser_phone_field = new Field(molgenisUser_entity, "Phone", MolgenisFieldTypes.getType("string"));
			molgenisUser_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			molgenisUser_phone_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_phone_field);
			Field molgenisUser_email_field = new Field(molgenisUser_entity, "Email", MolgenisFieldTypes.getType("email"));
			molgenisUser_email_field.setDescription("The email address of the Contact.");
			molgenisUser_email_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_email_field);
			Field molgenisUser_fax_field = new Field(molgenisUser_entity, "Fax", MolgenisFieldTypes.getType("string"));
			molgenisUser_fax_field.setDescription("The fax number of the Contact.");
			molgenisUser_fax_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_fax_field);
			Field molgenisUser_tollFreePhone_field = new Field(molgenisUser_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			molgenisUser_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			molgenisUser_tollFreePhone_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_tollFreePhone_field);
			Field molgenisUser_city_field = new Field(molgenisUser_entity, "City", MolgenisFieldTypes.getType("string"));
			molgenisUser_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			molgenisUser_city_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_city_field);
			Field molgenisUser_country_field = new Field(molgenisUser_entity, "Country", MolgenisFieldTypes.getType("string"));
			molgenisUser_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			molgenisUser_country_field.setNillable(true);
			molgenisUser_entity.addField(molgenisUser_country_field);
			Field molgenisUser_changePassword_field = new Field(molgenisUser_entity, "changePassword", MolgenisFieldTypes.getType("bool"));
			molgenisUser_changePassword_field.setDevaultValue("false");
			molgenisUser_changePassword_field.setDescription("If true the user must first change his password before he can proceed");
			molgenisUser_changePassword_field.setNillable(false);
			molgenisUser_entity.addField(molgenisUser_changePassword_field);
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"username"}),false,"");
			molgenisUser_entity.addKey(Arrays.asList(new String[]{"Email"}),false,"");
			
			//MolgenisGroup
			Entity molgenisGroup_entity = new Entity("MolgenisGroup",this.getDatabase());
			molgenisGroup_entity.setSystem(true);
			molgenisGroup_entity.setAbstract(false);
			molgenisGroup_entity.setDescription("");
			molgenisGroup_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field molgenisGroup_id_field = new Field(molgenisGroup_entity, "id", MolgenisFieldTypes.getType("string"));
			molgenisGroup_id_field.setAuto(true);
			molgenisGroup_id_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_id_field);
			Field molgenisGroup_name_field = new Field(molgenisGroup_entity, "name", MolgenisFieldTypes.getType("string"));
			molgenisGroup_name_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_name_field);
			Field molgenisGroup_active_field = new Field(molgenisGroup_entity, "active", MolgenisFieldTypes.getType("bool"));
			molgenisGroup_active_field.setDevaultValue("true");
			molgenisGroup_active_field.setDescription("Boolean to indicate whether this group is in use.");
			molgenisGroup_active_field.setNillable(false);
			molgenisGroup_entity.addField(molgenisGroup_active_field);
			molgenisGroup_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//MolgenisGroupMember
			Entity molgenisGroupMember_entity = new Entity("MolgenisGroupMember",this.getDatabase());
			molgenisGroupMember_entity.setSystem(true);
			molgenisGroupMember_entity.setAbstract(false);
			molgenisGroupMember_entity.setDescription("");
			molgenisGroupMember_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field molgenisGroupMember_id_field = new Field(molgenisGroupMember_entity, "id", MolgenisFieldTypes.getType("string"));
			molgenisGroupMember_id_field.setAuto(true);
			molgenisGroupMember_id_field.setNillable(false);
			molgenisGroupMember_entity.addField(molgenisGroupMember_id_field);
			Field molgenisGroupMember_molgenisUser_field = new Field(molgenisGroupMember_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			molgenisGroupMember_molgenisUser_field.setNillable(false);
			molgenisGroupMember_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			molgenisGroupMember_entity.addField(molgenisGroupMember_molgenisUser_field);
			Field molgenisGroupMember_molgenisGroup_field = new Field(molgenisGroupMember_entity, "molgenisGroup", MolgenisFieldTypes.getType("xref"));
			molgenisGroupMember_molgenisGroup_field.setNillable(false);
			molgenisGroupMember_molgenisGroup_field.setXRefVariables("MolgenisGroup", "id",Arrays.asList(new String[]{"id"}));
			molgenisGroupMember_entity.addField(molgenisGroupMember_molgenisGroup_field);
			molgenisGroupMember_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Authority
			Entity authority_entity = new Entity("Authority",this.getDatabase());
			authority_entity.setSystem(true);
			authority_entity.setAbstract(true);
			authority_entity.setDescription("");
			Field authority_role_field = new Field(authority_entity, "role", MolgenisFieldTypes.getType("string"));
			authority_role_field.setNillable(false);
			authority_entity.addField(authority_role_field);
			
			//UserAuthority
			Entity userAuthority_entity = new Entity("UserAuthority",this.getDatabase());
			userAuthority_entity.setSystem(true);
			userAuthority_entity.setAbstract(false);
			userAuthority_entity.setImplements(new String[]{"Authority"});
			userAuthority_entity.setDescription("");
			userAuthority_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field userAuthority_id_field = new Field(userAuthority_entity, "id", MolgenisFieldTypes.getType("string"));
			userAuthority_id_field.setAuto(true);
			userAuthority_id_field.setNillable(false);
			userAuthority_entity.addField(userAuthority_id_field);
			Field userAuthority_molgenisUser_field = new Field(userAuthority_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			userAuthority_molgenisUser_field.setNillable(false);
			userAuthority_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			userAuthority_entity.addField(userAuthority_molgenisUser_field);
			Field userAuthority_role_field = new Field(userAuthority_entity, "role", MolgenisFieldTypes.getType("string"));
			userAuthority_role_field.setNillable(false);
			userAuthority_entity.addField(userAuthority_role_field);
			userAuthority_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//GroupAuthority
			Entity groupAuthority_entity = new Entity("GroupAuthority",this.getDatabase());
			groupAuthority_entity.setSystem(true);
			groupAuthority_entity.setAbstract(false);
			groupAuthority_entity.setImplements(new String[]{"Authority"});
			groupAuthority_entity.setDescription("");
			groupAuthority_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field groupAuthority_id_field = new Field(groupAuthority_entity, "id", MolgenisFieldTypes.getType("string"));
			groupAuthority_id_field.setAuto(true);
			groupAuthority_id_field.setNillable(false);
			groupAuthority_entity.addField(groupAuthority_id_field);
			Field groupAuthority_molgenisGroup_field = new Field(groupAuthority_entity, "molgenisGroup", MolgenisFieldTypes.getType("xref"));
			groupAuthority_molgenisGroup_field.setNillable(false);
			groupAuthority_molgenisGroup_field.setXRefVariables("MolgenisGroup", "id",Arrays.asList(new String[]{"id"}));
			groupAuthority_entity.addField(groupAuthority_molgenisGroup_field);
			Field groupAuthority_role_field = new Field(groupAuthority_entity, "role", MolgenisFieldTypes.getType("string"));
			groupAuthority_role_field.setNillable(false);
			groupAuthority_entity.addField(groupAuthority_role_field);
			groupAuthority_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//RuntimeProperty
			Entity runtimeProperty_entity = new Entity("RuntimeProperty",this.getDatabase());
			runtimeProperty_entity.setSystem(false);
			runtimeProperty_entity.setAbstract(false);
			runtimeProperty_entity.setDescription("");
			runtimeProperty_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field runtimeProperty_id_field = new Field(runtimeProperty_entity, "id", MolgenisFieldTypes.getType("string"));
			runtimeProperty_id_field.setAuto(true);
			runtimeProperty_id_field.setDescription("automatically generated internal id, only for internal use.");
			runtimeProperty_id_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_id_field);
			Field runtimeProperty_name_field = new Field(runtimeProperty_entity, "Name", MolgenisFieldTypes.getType("string"));
			runtimeProperty_name_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_name_field);
			Field runtimeProperty_value_field = new Field(runtimeProperty_entity, "Value", MolgenisFieldTypes.getType("text"));
			runtimeProperty_value_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_value_field);
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//FreemarkerTemplate
			Entity freemarkerTemplate_entity = new Entity("FreemarkerTemplate",this.getDatabase());
			freemarkerTemplate_entity.setSystem(false);
			freemarkerTemplate_entity.setAbstract(false);
			freemarkerTemplate_entity.setDescription("");
			freemarkerTemplate_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field freemarkerTemplate_id_field = new Field(freemarkerTemplate_entity, "id", MolgenisFieldTypes.getType("string"));
			freemarkerTemplate_id_field.setAuto(true);
			freemarkerTemplate_id_field.setDescription("automatically generated internal id, only for internal use.");
			freemarkerTemplate_id_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_id_field);
			Field freemarkerTemplate_name_field = new Field(freemarkerTemplate_entity, "Name", MolgenisFieldTypes.getType("string"));
			freemarkerTemplate_name_field.setDescription("Name of the entity");
			freemarkerTemplate_name_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_name_field);
			Field freemarkerTemplate_value_field = new Field(freemarkerTemplate_entity, "Value", MolgenisFieldTypes.getType("script"));
			freemarkerTemplate_value_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_value_field);
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//MolgenisToken
			Entity molgenisToken_entity = new Entity("MolgenisToken",this.getDatabase());
			molgenisToken_entity.setSystem(false);
			molgenisToken_entity.setAbstract(false);
			molgenisToken_entity.setDescription("");
			molgenisToken_entity.setXrefLabels(Arrays.asList(new String[]{"token"}));
			Field molgenisToken_id_field = new Field(molgenisToken_entity, "id", MolgenisFieldTypes.getType("string"));
			molgenisToken_id_field.setAuto(true);
			molgenisToken_id_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_id_field);
			Field molgenisToken_molgenisUser_field = new Field(molgenisToken_entity, "molgenisUser", MolgenisFieldTypes.getType("xref"));
			molgenisToken_molgenisUser_field.setNillable(false);
			molgenisToken_molgenisUser_field.setXRefVariables("MolgenisUser", "id",Arrays.asList(new String[]{"username"}));
			molgenisToken_entity.addField(molgenisToken_molgenisUser_field);
			Field molgenisToken_token_field = new Field(molgenisToken_entity, "token", MolgenisFieldTypes.getType("string"));
			molgenisToken_token_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_token_field);
			Field molgenisToken_expirationDate_field = new Field(molgenisToken_entity, "expirationDate", MolgenisFieldTypes.getType("datetime"));
			molgenisToken_expirationDate_field.setDescription("When expiration date is null it will never expire");
			molgenisToken_expirationDate_field.setNillable(true);
			molgenisToken_entity.addField(molgenisToken_expirationDate_field);
			Field molgenisToken_creationDate_field = new Field(molgenisToken_entity, "creationDate", MolgenisFieldTypes.getType("datetime"));
			molgenisToken_creationDate_field.setAuto(true);
			molgenisToken_creationDate_field.setNillable(false);
			molgenisToken_entity.addField(molgenisToken_creationDate_field);
			Field molgenisToken_description_field = new Field(molgenisToken_entity, "description", MolgenisFieldTypes.getType("text"));
			molgenisToken_description_field.setNillable(true);
			molgenisToken_entity.addField(molgenisToken_description_field);
			molgenisToken_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisToken_entity.addKey(Arrays.asList(new String[]{"token"}),false,"");
			
			//DiseaseMapping
			Entity diseaseMapping_entity = new Entity("DiseaseMapping",this.getDatabase());
			diseaseMapping_entity.setSystem(false);
			diseaseMapping_entity.setAbstract(false);
			diseaseMapping_entity.setDescription("Mapping of OMIM/ORPHANET diseases to HGNC genes to HPO terms.");
			diseaseMapping_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field diseaseMapping_id_field = new Field(diseaseMapping_entity, "id", MolgenisFieldTypes.getType("string"));
			diseaseMapping_id_field.setAuto(true);
			diseaseMapping_id_field.setDescription("automatically generated internal id, only for internal use");
			diseaseMapping_id_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_id_field);
			Field diseaseMapping_identifier_field = new Field(diseaseMapping_entity, "identifier", MolgenisFieldTypes.getType("string"));
			diseaseMapping_identifier_field.setDescription("Combination of diseaseId, geneSymbol and HPOId to get unique identifer");
			diseaseMapping_identifier_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_identifier_field);
			Field diseaseMapping_diseaseId_field = new Field(diseaseMapping_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			diseaseMapping_diseaseId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_diseaseId_field);
			Field diseaseMapping_geneSymbol_field = new Field(diseaseMapping_entity, "geneSymbol", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneSymbol_field.setDescription("Gene symbol");
			diseaseMapping_geneSymbol_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneSymbol_field);
			Field diseaseMapping_geneId_field = new Field(diseaseMapping_entity, "geneId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneId_field.setDescription("Entrez gene identifier");
			diseaseMapping_geneId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneId_field);
			Field diseaseMapping_hPOId_field = new Field(diseaseMapping_entity, "HPOId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPOId_field.setDescription("HPO term identifier");
			diseaseMapping_hPOId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPOId_field);
			Field diseaseMapping_hPODescription_field = new Field(diseaseMapping_entity, "HPODescription", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPODescription_field.setDescription("Description of the HPO term");
			diseaseMapping_hPODescription_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPODescription_field);
			Field diseaseMapping_isTypical_field = new Field(diseaseMapping_entity, "isTypical", MolgenisFieldTypes.getType("bool"));
			diseaseMapping_isTypical_field.setDescription("Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set");
			diseaseMapping_isTypical_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_isTypical_field);
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
			//Disease
			Entity disease_entity = new Entity("Disease",this.getDatabase());
			disease_entity.setSystem(false);
			disease_entity.setAbstract(false);
			disease_entity.setDescription("Mapping of OMIM/ORPHANET disease id's to disease names.");
			disease_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field disease_id_field = new Field(disease_entity, "id", MolgenisFieldTypes.getType("string"));
			disease_id_field.setAuto(true);
			disease_id_field.setDescription("automatically generated internal id, only for internal use");
			disease_id_field.setNillable(false);
			disease_entity.addField(disease_id_field);
			Field disease_identifier_field = new Field(disease_entity, "identifier", MolgenisFieldTypes.getType("string"));
			disease_identifier_field.setDescription("Combination of diseaseName, diseaseId and mappingMethod");
			disease_identifier_field.setNillable(false);
			disease_entity.addField(disease_identifier_field);
			Field disease_diseaseId_field = new Field(disease_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			disease_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			disease_diseaseId_field.setNillable(false);
			disease_entity.addField(disease_diseaseId_field);
			Field disease_diseaseName_field = new Field(disease_entity, "diseaseName", MolgenisFieldTypes.getType("string"));
			disease_diseaseName_field.setDescription("OMIM or ORPHANET disease name");
			disease_diseaseName_field.setNillable(false);
			disease_entity.addField(disease_diseaseName_field);
			Field disease_mappingMethod_field = new Field(disease_entity, "mappingMethod", MolgenisFieldTypes.getType("string"));
			disease_mappingMethod_field.setDescription("The phenotype mapping method");
			disease_mappingMethod_field.setNillable(false);
			disease_entity.addField(disease_mappingMethod_field);
			disease_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			disease_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
			//ImportRun
			Entity importRun_entity = new Entity("ImportRun",this.getDatabase());
			importRun_entity.setSystem(false);
			importRun_entity.setAbstract(false);
			importRun_entity.setDescription("All running and finished imports");
			importRun_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field importRun_id_field = new Field(importRun_entity, "id", MolgenisFieldTypes.getType("string"));
			importRun_id_field.setAuto(true);
			importRun_id_field.setDescription("automatically generated internal id, only for internal use.");
			importRun_id_field.setNillable(false);
			importRun_entity.addField(importRun_id_field);
			Field importRun_startDate_field = new Field(importRun_entity, "startDate", MolgenisFieldTypes.getType("datetime"));
			importRun_startDate_field.setNillable(false);
			importRun_entity.addField(importRun_startDate_field);
			Field importRun_endDate_field = new Field(importRun_entity, "endDate", MolgenisFieldTypes.getType("datetime"));
			importRun_endDate_field.setNillable(true);
			importRun_entity.addField(importRun_endDate_field);
			Field importRun_userName_field = new Field(importRun_entity, "userName", MolgenisFieldTypes.getType("string"));
			importRun_userName_field.setNillable(false);
			importRun_entity.addField(importRun_userName_field);
			Field importRun_status_field = new Field(importRun_entity, "status", MolgenisFieldTypes.getType("enum"));
			Vector<String> importRun_status_field_enumoptions = new Vector<String>();
			importRun_status_field_enumoptions.add("RUNNING");
			importRun_status_field_enumoptions.add("FINISHED");
			importRun_status_field_enumoptions.add("FAILED");
			importRun_status_field.setEnumOptions(importRun_status_field_enumoptions);
			importRun_status_field.setNillable(false);
			importRun_entity.addField(importRun_status_field);
			Field importRun_message_field = new Field(importRun_entity, "message", MolgenisFieldTypes.getType("text"));
			importRun_message_field.setNillable(true);
			importRun_entity.addField(importRun_message_field);
			Field importRun_progress_field = new Field(importRun_entity, "progress", MolgenisFieldTypes.getType("int"));
			importRun_progress_field.setNillable(false);
			importRun_entity.addField(importRun_progress_field);
			Field importRun_importedEntities_field = new Field(importRun_entity, "importedEntities", MolgenisFieldTypes.getType("text"));
			importRun_importedEntities_field.setNillable(true);
			importRun_entity.addField(importRun_importedEntities_field);
			importRun_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
		} catch (MolgenisModelException e)
		{
			throw new RuntimeException(e);
		}
	}
}