/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.validation;

import java.util.List;
import org.apache.log4j.Logger;
import org.biodas.jdas.dassources.utils.RegistrySourceAdapter;
import org.biodas.jdas.exceptions.ValidationException;
import org.biodas.jdas.schema.sources.SOURCE;
import org.biodas.jdas.schema.sources.VERSION;

public class RegistrySourceValidator {
    Logger logger = Logger.getLogger(RegistrySourceValidator.class);
    private String message = "";

    public boolean validate(SOURCE source) {
        return this.validUri(source) && this.hasVersion(source) && this.hasCapabilities(source) && this.hasCoordinates(source) && this.hasMaintainer(source);
    }

    public boolean hasVersion(SOURCE source) {
        if (source.getVERSION().size() == 0) {
            this.message = this.message + " no VERSION found";
            return false;
        }
        return true;
    }

    boolean hasCapabilities(SOURCE source) {
        if (this.hasVersion(source) && source.getVERSION().get(0).getCAPABILITY().size() > 0) {
            return true;
        }
        this.message = this.message + " no capabilities found, ";
        return false;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean validUri(SOURCE source) {
        if (source.getUri() == null) {
            this.message = this.message + " no uri detected";
            return false;
        }
        if (source.getUri().contains("/das/") || source.getUri().contains("/das/") || source.getUri().contains("DS_")) {
            return true;
        }
        this.logger.warn((Object)" uri does not contain /das/ or das1 or DS_ ");
        return true;
    }

    public boolean hasCoordinates(SOURCE source) {
        if (this.hasVersion(source)) {
            VERSION version = source.getVERSION().get(0);
            if (version.getCOORDINATES().size() == 0) {
                this.message = this.message + " No coordinates found ";
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasMaintainer(SOURCE source) {
        if (source.getMAINTAINER() == null) {
            this.message = this.message + " No Maintainer found ";
            return false;
        }
        if (source.getMAINTAINER().getEmail() == null) {
            this.message = this.message + " no email for maintainer found ";
            return false;
        }
        return true;
    }

    public String getRegistryId(SOURCE source, List<SOURCE> regSources) throws ValidationException {
        boolean regPrefix = false;
        RegistrySourceAdapter rA = new RegistrySourceAdapter(source);
        String versionUri = rA.getOriginalDataSourceUri();
        if (source.getUri().contains("DS_")) {
            regPrefix = true;
        }
        for (SOURCE regSource : regSources) {
            if (regPrefix) {
                if (!source.getVERSION().get(0).getUri().equals(regSource.getVERSION().get(0).getUri())) continue;
                return regSource.getUri();
            }
            RegistrySourceAdapter ra = new RegistrySourceAdapter(regSource);
            String regVersionUri = "";
            try {
                regVersionUri = ra.getOriginalDataSourceUri();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (!versionUri.equals(regVersionUri)) continue;
            return regSource.getUri();
        }
        return "";
    }
}

