/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.TypesClient;
import org.biodas.jdas.client.threads.ClientMultipleSources;
import org.biodas.jdas.exceptions.DASClientException;
import org.biodas.jdas.schema.types.DASTYPES;

public class TypesClientMulptipleSources
extends ClientMultipleSources {
    private static Logger logger = Logger.getLogger(TypesClientMulptipleSources.class);

    public void fetchData(List<String> sources, final List<String> segments, final List<String> types, final Map<String, Map<List<String>, DASTYPES>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TypesClient typesClient = new TypesClient();
                        DASTYPES adapter = typesClient.fetchData(source, segments, types);
                        if (results.get(source) == null) {
                            HashMap<List, DASTYPES> response = new HashMap<List, DASTYPES>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }

    public void fetchData(List<String> sources, final Map<String, DASTYPES> results, final Map<String, Exception> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        TypesClient typesClient = new TypesClient();
                        DASTYPES adapter = typesClient.fetchData(source);
                        results.put(source, adapter);
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        errors.put(source, e);
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }
}

