/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.biodas.jdas.client.FeaturesClient;
import org.biodas.jdas.client.adapters.features.DasGFFAdapter;
import org.biodas.jdas.client.threads.ClientMultipleSources;
import org.biodas.jdas.exceptions.DASClientException;

public class FeaturesClientMultipleSources
extends ClientMultipleSources {
    private static Logger logger = Logger.getLogger(FeaturesClientMultipleSources.class);

    public void fetchData(List<String> sources, final List<String> segments, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient();
                        DasGFFAdapter adapter = featuresClient.fetchData(source, segments);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }

    public void fetchDataWithTypes(List<String> sources, final List<String> segments, final List<String> types, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient();
                        DasGFFAdapter adapter = featuresClient.fetchDataWithTypes(source, segments, types);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }

    public void fetchDataWithFeatueIds(List<String> sources, final List<String> segments, final List<String> featureIds, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient();
                        DasGFFAdapter adapter = featuresClient.fetchDataWithFeatueIds(source, segments, featureIds);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }

    public void fetchData(List<String> sources, final List<String> segments, final List<String> types, final List<String> categories, final String categorize, final List<String> featureIds, final String maxbins, final Map<String, Map<List<String>, DasGFFAdapter>> results, final Map<String, Map<List<String>, Exception>> errors) {
        for (final String source : sources) {
            this.runTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        FeaturesClient featuresClient = new FeaturesClient();
                        DasGFFAdapter adapter = featuresClient.fetchData(source, segments, types, categories, categorize, featureIds, maxbins);
                        if (results.get(source) == null) {
                            HashMap<List, DasGFFAdapter> response = new HashMap<List, DasGFFAdapter>();
                            response.put(segments, adapter);
                            results.put(source, response);
                        } else {
                            ((Map)results.get(source)).put(segments, adapter);
                        }
                        logger.debug((Object)("Response from " + source + " has been already retrieved"));
                    }
                    catch (DASClientException e) {
                        if (errors.get(source) == null) {
                            HashMap<List, DASClientException> response = new HashMap<List, DASClientException>();
                            response.put(segments, e);
                            errors.put(source, response);
                        } else {
                            ((Map)errors.get(source)).put(segments, e);
                        }
                        logger.error((Object)("Fetching data from source " + source + " raised an exception: " + e.getMessage()));
                    }
                }
            });
        }
        while (!this.queue.isEmpty()) {
            logger.info((Object)("Waiting for " + this.queue.size() + " jobs"));
        }
    }
}

