/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.threads;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class ClientMultipleSources {
    private static Logger logger = Logger.getLogger(ClientMultipleSources.class);
    protected int poolSize;
    protected int maxPoolSize;
    protected long keepAliveTime;
    protected ThreadPoolExecutor threadPool = null;
    protected final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    protected ClientMultipleSources() {
        this(5, 10, 5L);
    }

    protected ClientMultipleSources(int poolSize, int maxPoolSize, long keepAliveTime) {
        this.poolSize = poolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.threadPool = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, this.queue);
    }

    protected void runTask(Runnable task) {
        this.threadPool.execute(task);
        logger.debug((Object)("Task count: " + this.queue.size()));
    }

    public void shutDown() {
        this.threadPool.shutdown();
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }
}

