/*
 * Decompiled with CFR 0.152.
 */
package org.biodas.jdas.client.adapters.types;

import java.util.ArrayList;
import java.util.List;
import org.biodas.jdas.schema.types.DASTYPES;
import org.biodas.jdas.schema.types.ERRORSEGMENT;
import org.biodas.jdas.schema.types.GFF;
import org.biodas.jdas.schema.types.SEGMENT;
import org.biodas.jdas.schema.types.UNKNOWNSEGMENT;
import org.codehaus.jackson.annotate.JsonProperty;

public class DasTypesAdapter
extends DASTYPES {
    @JsonProperty(value="GFF")
    GFFAdapter gff;
    private DASTYPES dasgff;

    public DasTypesAdapter() {
        this.gff.init();
    }

    public DasTypesAdapter(DASTYPES dasTypes) {
        this.dasgff = dasTypes;
        this.gff = new GFFAdapter(dasTypes.getGFF());
    }

    public void setGFF(GFFAdapter gff) {
        this.gff = gff;
    }

    public GFFAdapter getGff() {
        return this.gff;
    }

    public class GFFAdapter
    extends GFF {
        private List<SEGMENT> segments;
        private List<ERRORSEGMENT> errorSegments;
        private List<UNKNOWNSEGMENT> unknownSegments;

        public GFFAdapter() {
            this.init();
        }

        public GFFAdapter(GFF gff) {
            this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = gff.getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT();
            this.href = gff.getHref();
            this.version = gff.getVersion();
            this.total = gff.getTotal();
            this.init();
        }

        private void init() {
            this.segments = new ArrayList<SEGMENT>();
            this.errorSegments = new ArrayList<ERRORSEGMENT>();
            this.unknownSegments = new ArrayList<UNKNOWNSEGMENT>();
            for (Object segment : this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT) {
                if (segment instanceof SEGMENT) {
                    this.segments.add((SEGMENT)segment);
                    continue;
                }
                if (segment instanceof UNKNOWNSEGMENT) {
                    this.unknownSegments.add((UNKNOWNSEGMENT)segment);
                    continue;
                }
                if (!(segment instanceof ERRORSEGMENT)) continue;
                this.errorSegments.add((ERRORSEGMENT)segment);
            }
            this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = null;
        }

        public List<SEGMENT> getSegments() {
            return this.segments;
        }

        public List<ERRORSEGMENT> getErrorSegments() {
            return this.errorSegments;
        }

        public List<UNKNOWNSEGMENT> getUnknownSegments() {
            return this.unknownSegments;
        }

        @Override
        @Deprecated
        public List<Object> getSEGMENTOrERRORSEGMENTOrUNKNOWNSEGMENT() {
            if (this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT != null) {
                this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT = null;
            }
            return this.segmentOrERRORSEGMENTOrUNKNOWNSEGMENT;
        }
    }
}

