unit compute_risk;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit4: TEdit;
    Label3: TLabel;
    Button2: TButton;
    Edit5: TEdit;
    Label4: TLabel;
    Edit6: TEdit;
    Label6: TLabel;
    Label9: TLabel;
    Edit10: TEdit;
    Label12: TLabel;
    Label13: TLabel;
    CheckBox1: TCheckBox;
    SaveDialog1: TSaveDialog;
    Label5: TLabel;
    Label7: TLabel;
    Edit3: TEdit;
    Edit7: TEdit;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    OpenDialog1: TOpenDialog;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit11: TEdit;
    Label14: TLabel;
    CheckBox2: TCheckBox;
    Label15: TLabel;
    Edit12: TEdit;
    Edit13: TEdit;
    Label16: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
   
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation


{$R *.dfm}

var
  Threshold,gestation, mat_age : extended;
  glit: integer;
  invoer, uitvoer: text;
  file_open, field_error, outtofile: boolean;
  t21, t18, t13: array[1..26, 1..11] of integer;
  endline: boolean;

function lees_tab: string;
var
  kar: char;
  res: string;
begin
  res := '';
  repeat
    read(invoer, kar);
    endline := (kar = #10);
//    if (kar <> #9) and not eoln(invoer) and not eof(invoer) then
    if not (kar in [chr(9), chr(10), chr(13), chr(32), ',']) then
      res := res + kar;
  until (kar = #32) or (kar = #9) or (kar = ',') or endline or eof(invoer);
  lees_tab := res;
  if eof(invoer) then endline := true;
end;

function Cumnor(x: extended): extended;
// this is a variant for the probability that x > X is X  is normally distributed
// with variance 1 and mean 0. It is derived from an article by graeme west
// and should be correct in double precision. I checked its concordance with
// the approximation in Abramowitz and Stegun. The relative difference for large
// values of the argument is small, for small arguments it is larger
var
  Exponential, build, temp, xabs: extended;

begin
  if x > 0.0 then
    XAbs := x
  else
    Xabs := -x;
  if XAbs > 37 then
    temp := 0.0
  else
  begin
    Exponential := Exp(-0.5 * XAbs * Xabs);
    if XAbs < 7.07106781186547 then
    begin
      build := 3.52624965998911E-02 * XAbs + 0.700383064443688;
      build := build * XAbs + 6.37396220353165;
      build := build * XAbs + 33.912866078383;
      build := build * XAbs + 112.079291497871;
      build := build * XAbs + 221.213596169931;
      build := build * XAbs + 220.206867912376;
      temp := Exponential * build;
      build := 8.83883476483184E-02 * XAbs + 1.75566716318264;
      build := build * XAbs + 16.064177579207;
      build := build * XAbs + 86.7807322029461;
      build := build * XAbs + 296.564248779674;
      build := build * XAbs + 637.333633378831;
      build := build * XAbs + 793.826512519948;
      build := build * XAbs + 440.413735824752;
      temp := temp / build;
    end
    else
    begin
      build := XAbs + 0.65;
      build := XAbs + 4 / build;
      build := XAbs + 3 / build;
      build := XAbs + 2 / build;
      build := XAbs + 1 / build;
      temp := Exponential / build / 2.506628274631
    end;
  end;
  if x < 0 then
    Cumnor := 1.0 - temp
  else
    Cumnor := temp;
end;

function check_content(content: string): string;
var
  tmp: string;
  i, j: integer;
begin
  tmp := '';
  j := 0;
  for i := 1 to length(content) do
  begin
    if content[i] in ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.','-'] then
      tmp := tmp + content[i] else
    begin
      showmessage('format error in datafield');
      field_error := true;
      tmp := '0';
    end;
    if content[i] = '.' then inc(j);

  end;
  if j > 1 then
  begin
    showmessage('format error in datafield');
    field_error := true;
    check_content := '0';
  end;
  check_content := tmp;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  if file_open then closefile(uitvoer);
  application.Terminate;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  a_priori, a_posteriori, Z_expected, Z_observed, ptris3, ptris, lower, upper,
    interval, sensitivity, Varcof: extended;
begin
  if outtofile and not file_open then
  begin
    savedialog1.Title := 'Save results as file, enter filename';
    if savedialog1.execute then assignfile(uitvoer, savedialog1.FileName);
    rewrite(uitvoer);
    writeln(uitvoer, '(c) g.j. te Meerman, UMCG/RUG 2014 Post test risk of Trisomy in NIPT');
    writeln(uitvoer, 'lower_limit upper_limit variation_coefficient a_priori_risk_p Observed_Z_score Ptrisomy_p table$ gest_age mat_age');
    file_open := true;
  end;
  field_error := false;
  Varcof := strtofloat(check_content(edit10.Text));
  Z_observed := strtofloat(check_content(Edit4.Text));
  lower := 0.5 * strtofloat(check_content(Edit1.Text)) / Varcof;
  upper := 0.5 * strtofloat(check_content(Edit2.Text)) / Varcof;
  if not field_error then
  begin
    if upper - lower < 0.002 then
      // this is done to handle the case that the upper and lower limit are
      // identical
    begin
      lower := lower - 0.001;
      upper := upper + 0.001;
    end;
    interval := upper - lower;
    a_priori := 1/strtofloat(check_content(Edit6.Text));
    if checkbox2.checked then a_priori:=a_priori+
    strtofloat(check_content(Edit11.text))/100.0;
    edit12.text:=floattostrf(1/a_priori,ffFixed,6,0);
    ptris3 := (cumnor(Z_observed - upper) - cumnor(Z_observed - lower)) / interval;
      // this is the average likelihood of the Normal distribution
      // over an interval Z_observed - upper to Z_observed - lower
      // this result is not obtained by direct integration,
      // but by using an accurate function for the cumulative normal distribution
    ptris3 := ptris3 * a_priori / (ptris3 * a_priori +
      (1 - a_priori) * exp(-Z_observed * Z_observed / 2.0) / sqrt(2 * pi));
    edit5.Text := floattostrF(100*ptris3, ffFixed, 8, 4);
    edit13.text:= floattostrF(100*a_priori, ffFixed, 8, 4);
    if file_open then writeln(uitvoer, lower: 6: 2, chr(9), upper: 6: 2, chr(9),
        Varcof: 6: 3, chr(9), 100*a_priori: 6: 3, chr(9), Z_observed: 6: 3,
        chr(9), 100*ptris3: 6: 3,chr(9),label11.caption,chr(9),gestation:5:1,
        chr(9),mat_age:6:1);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i, j, start: integer;
begin
  form1.Caption := 'program to compute NIPT post test probability of trisomy';
  outtofile := false;
  file_open := false;
  assignfile(invoer, 'T21risk.txt');
  reset(invoer);
  readln(invoer);
  readln(invoer);
  lees_tab; //skip table entry description
  T21[1, 1] := 0;
  for i := 1 to 26 do
  begin
    if i = 1 then start := 2 else start := 1;
    for j := start to 9 do T21[i, j] := strtoint(lees_tab);
  end;
  closefile(invoer);
  assignfile(invoer, 'T18risk.txt');
  reset(invoer);
  readln(invoer);
  readln(invoer);
  lees_tab; //skip table entry description
  T18[1, 1] := 0;
  for i := 1 to 26 do
  begin
    if i = 1 then start := 2 else start := 1;
    for j := start to 11 do T18[i, j] := strtoint(lees_tab);
  end;
  closefile(invoer);
  assignfile(invoer, 'T13risk.txt');
  reset(invoer);
  readln(invoer);
  readln(invoer);
  lees_tab; //skip table entry description
  T13[1, 1] := 0;
  for i := 1 to 18 do
  begin
    if i = 1 then start := 2 else start := 1;
    for j := start to 7 do T13[i, j] := strtoint(lees_tab);
  end;
end;





procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if checkbox1.Checked then outtofile := true else
    if file_open then
    begin
      closefile(uitvoer);
      file_open := false;
      outtofile := false;
    end;
end;

procedure TForm1.Button3Click(Sender: TObject);
// purpose : interpolate table to find risk of trisomy 21 and put result
// in field for prior frequency

var i, j: integer;
  estimate, estimate1, estimate2, f1, f2: extended;
  found1, found2: boolean;
begin
  gestation := strtofloat(check_content(edit3.Text))+
  strtofloat(check_content(Edit8.text))/7.0;
  mat_age := strtofloat(check_content(edit7.Text))+
  strtofloat(check_content(Edit9.text))/12.0;
  ;
  // find entry for gestation
  i := 1;
  found1 := false;
  repeat
    inc(i);
    found1 := (t21[1, i] <= gestation) and (t21[1, i + 1] >= gestation);
  until (i = 8) or found1;
  // find entry for maternal age
  j := 1;
  found2 := false;
  repeat
    inc(j);
    found2 := (t21[j, 1] <= mat_age) and (t21[j + 1, 1] >= mat_age);
  until (j = 25) or found2;
  if found1 and found2 then
  begin
  // linear bivariate interpolation
  // the table has the shape of number when 1/number is the probability
  // the number is approximated by linear interpolation

    f1 := (gestation - T21[1, i]) / (T21[1, i + 1] - T21[1, i]);
    f2 := (mat_age - T21[j, 1]) / (T21[j + 1, 1] - T21[j, 1]);
    estimate1 := (1-f1) * T21[j, i] + f1 * t21[j, i + 1];
    estimate2 := (1-f1) * T21[j + 1, i] + f1 * t21[j + 1, i + 1];
    estimate := (1-f2) * estimate1 + f2 * estimate2;
    edit6.Text := floattostrf(estimate,fffixed, 6, 0);
    Label11.caption:='T21 table';
  end else
    showmessage('no extrapolation possible, data outside table');
end;

procedure TForm1.Button4Click(Sender: TObject);
// purpose : interpolate table to find risk of trisomy 21 and put result
// in field for prior frequency

var i, j: integer;
  estimate, estimate1, estimate2, f1, f2: extended;
  found1, found2: boolean;
begin
   gestation := strtofloat(check_content(edit3.Text))+
  strtofloat(check_content(Edit8.text))/7.0;
  mat_age := strtofloat(check_content(edit7.Text))+
  strtofloat(check_content(Edit9.text))/12.0;
  // find entry for maternal age
  i := 1;
  found1 := false;
  repeat
    inc(i);
    found1 := (t18[1, i] <= gestation) and (t18[1, i + 1] >= gestation);
  until (i = 10) or found1;
  // find entry for maternal age
  j := 1;
  found2 := false;
  repeat
    inc(j);
    found2 := (t18[j, 1] <= mat_age) and (t18[j + 1, 1] >= mat_age);
  until (j = 25) or found2;
  if found1 and found2 then
  begin
  // linear bivariate interpolation
  // the table has the shape of number when 1/number is the probability
  // the number is approximated by linear interpolation

    f1 := (gestation - T18[1, i]) / (T18[1, i + 1] - T18[1, i]);
    f2 := (mat_age - T18[j, 1]) / (T18[j + 1, 1] - T18[j, 1]);
    estimate1 := (1-f1) * T18[j, i] + f1 * t18[j, i + 1];
    estimate2 := (1-f1) * T18[j + 1, i] + f1 * t18[j + 1, i + 1];
    estimate := (1-f2) * estimate1 + f2 * estimate2;
    edit6.Text := floattostrf(estimate,fffixed, 6, 0);
    Label11.caption:='T18 table';

  end else
    showmessage('no extrapolation possible, data outside table');


end;

procedure TForm1.Button5Click(Sender: TObject);
// purpose : interpolate table to find risk of trisomy 21 and put result
// in field for prior frequency

var i, j: integer;
  estimate, estimate1, estimate2, f1, f2: extended;
  found1, found2: boolean;
begin
   gestation := strtofloat(check_content(edit3.Text))+
  strtofloat(check_content(Edit8.text))/7.0;
  mat_age := strtofloat(check_content(edit7.Text))+
  strtofloat(check_content(Edit9.text))/12.0;
  // find entry for maternal age
  i := 1;
  found1 := false;
  repeat
    inc(i);
    found1 := (T13[1, i] <= gestation) and (T13[1, i + 1] >= gestation);
  until (i = 6) or found1;
  // find entry for maternal age
  j := 1;
  found2 := false;
  repeat
    inc(j);
    found2 := (T13[j, 1] <= mat_age) and (T13[j + 1, 1] >= mat_age);
  until (j = 17) or found2;
  if found1 and found2 then
  begin
  // linear bivariate interpolation
  // the table has the shape of number when 1/number is the probability
  // the number is approximated by linear interpolation

  f1 := (gestation - T13[1, i]) / (T13[1, i + 1] - T13[1, i]);
    f2 := (mat_age - T13[j, 1]) / (T13[j + 1, 1] - T13[j, 1]);
    estimate1 := (1-f1) * T13[j, i] + f1 * T13[j, i + 1];
    estimate2 := (1-f1) * T13[j + 1, i] + f1 * T13[j + 1, i + 1];
    estimate := (1-f2) * estimate1 + f2 * estimate2;
    edit6.Text := floattostrf(estimate,fffixed, 6, 0);
    Label11.caption:='T13 table';
  end else
    showmessage('no extrapolation possible, data outside table');
  
end;

procedure TForm1.Edit6Change(Sender: TObject);
begin
label11.caption:='manual';
end;



end.

