/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.tuple;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.util.AbstractEntity;
import org.molgenis.util.ListEscapeUtils;
import org.molgenis.util.tuple.Tuple;

@SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="return true/false/null on purpose")
public abstract class AbstractTuple
implements Tuple {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AbstractTuple.class);

    @Override
    public boolean hasColNames() {
        Iterable<String> it = this.getColNames();
        return it != null ? it.iterator().hasNext() : false;
    }

    @Override
    public boolean isNull(String colName) {
        return this.get(colName) == null;
    }

    @Override
    public boolean isNull(int col) {
        return this.get(col) == null;
    }

    @Override
    public String getString(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    @Override
    public String getString(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    @Override
    public Integer getInt(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    @Override
    public Integer getInt(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    @Override
    public Long getLong(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return Long.parseLong(obj.toString());
    }

    @Override
    public Long getLong(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return Long.parseLong(obj.toString());
    }

    @Override
    public Boolean getBoolean(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String str = obj.toString();
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("1");
    }

    @Override
    public Boolean getBoolean(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String str = obj.toString();
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("1");
    }

    @Override
    public Double getDouble(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return Double.parseDouble(obj.toString());
    }

    @Override
    public Double getDouble(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return Double.parseDouble(obj.toString());
    }

    @Override
    public Date getDate(String colName) {
        Object obj = this.get(colName);
        return this.objToDate(obj);
    }

    @Override
    public Date getDate(int col) {
        Object obj = this.get(col);
        return this.objToDate(obj);
    }

    private Date objToDate(Object obj) {
        Date result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            try {
                result = Date.valueOf(obj.toString());
            }
            catch (IllegalArgumentException e) {
                result = AbstractEntity.string2date(obj.toString());
            }
        }
        catch (ParseException e) {
            logger.warn((Object)("unable to parse input tot SQL Date: " + obj.toString()));
        }
        return result;
    }

    @Override
    public Timestamp getTimestamp(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        return Timestamp.valueOf(obj.toString());
    }

    @Override
    public Timestamp getTimestamp(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        return Timestamp.valueOf(obj.toString());
    }

    @Override
    public List<String> getList(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof String) {
            return ListEscapeUtils.toList((String)obj);
        }
        return ListEscapeUtils.toList(obj.toString());
    }

    @Override
    public List<Integer> getIntList(String colName) {
        Object obj = this.get(colName);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (Object o : (List)obj) {
                if (o instanceof Integer) {
                    intList.add((Integer)o);
                    continue;
                }
                if (!(o instanceof String)) continue;
                intList.add(Integer.parseInt((String)o));
            }
            return intList;
        }
        if (obj instanceof Integer) {
            return new ArrayList<Integer>(Arrays.asList((Integer)obj));
        }
        return null;
    }

    @Override
    public List<String> getList(int col) {
        Object obj = this.get(col);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof String) {
            return ListEscapeUtils.toList((String)obj);
        }
        return ListEscapeUtils.toList(obj.toString());
    }

    @Override
    public boolean isEmpty() {
        for (String colName : this.getColNames()) {
            if (this.isNull(colName)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        for (String colName : this.getColNames()) {
            strBuilder.append(colName).append('=').append(this.get(colName)).append(',');
        }
        if (strBuilder.length() > 0) {
            strBuilder.deleteCharAt(strBuilder.length() - 1);
        }
        return "Tuple[" + strBuilder.toString() + ']';
    }
}

