/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.trityper.reader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class TextFile {
    public static final Pattern tab = Pattern.compile("\t");
    public static final Pattern space = Pattern.compile(" ");
    protected BufferedReader in;
    protected String loc;
    public static final boolean W = true;
    public static final boolean R = false;
    protected BufferedWriter out;
    protected boolean writeable;
    protected static final String ENCODING = "ISO-8859-1";

    public TextFile(String loc, boolean mode) throws IOException {
        this.writeable = mode;
        this.loc = loc;
        this.open();
    }

    public void open() throws IOException {
        File locHandle = new File(this.loc);
        if (!locHandle.exists() && !this.writeable) {
            System.out.println("Could not find file: " + this.loc);
            System.exit(0);
        } else if (this.writeable) {
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(locHandle), ENCODING));
        } else {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(locHandle), ENCODING), 8096);
        }
    }

    public String readLine() throws IOException {
        String ln = this.in.readLine();
        if (ln != null) {
            return ln;
        }
        return null;
    }

    public void write(String line) throws IOException {
        this.out.write(line);
    }

    public void close() throws IOException {
        if (this.writeable) {
            this.out.close();
        } else {
            this.in.close();
        }
    }

    public String[] readLineElems(Pattern p) throws IOException {
        if (this.in != null) {
            String ln = this.readLine();
            if (ln != null) {
                return p.split(ln);
            }
            return null;
        }
        return null;
    }

    public int countLines() throws IOException {
        String ln = this.readLine();
        int ct = 0;
        while (ln != null) {
            if (ln.trim().length() > 0) {
                ++ct;
            }
            ln = this.readLine();
        }
        this.close();
        this.open();
        return ct;
    }

    public int countCols(Pattern p) throws IOException {
        String ln = this.readLine();
        int ct = 0;
        if (ln != null) {
            String[] elems = p.split(ln);
            ct = elems.length;
        }
        this.close();
        this.open();
        return ct;
    }

    public String[] readAsArray() throws IOException {
        int numLines = this.countLines();
        String ln = this.readLine();
        String[] data = new String[numLines];
        int i = 0;
        while (ln != null) {
            if (ln.trim().length() > 0) {
                data[i] = ln;
                ++i;
            }
            ln = this.in.readLine();
        }
        return data;
    }

    public ArrayList<String> readAsArrayList() throws IOException {
        String ln = this.readLine();
        ArrayList<String> data = new ArrayList<String>();
        while (ln != null) {
            if (ln.trim().length() > 0) {
                data.add(ln);
            }
            ln = this.in.readLine();
        }
        return data;
    }
}

