/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.molgenis.util.Entity;
import org.molgenis.util.ValueLabel;
import org.molgenis.util.tuple.EntityTuple;
import org.molgenis.util.tuple.SingletonTuple;
import org.molgenis.util.tuple.Tuple;

@XmlRootElement(name="entity")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractEntity
implements Entity,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private boolean readonly;
    private String __Type;

    public static boolean isObjectRepresentation(String objStr) {
        int left = objStr.indexOf(40);
        int right = objStr.lastIndexOf(41);
        return left != -1 && right != -1;
    }

    public static <T extends Entity> T setValuesFromString(String objStr, Class<T> klass) throws Exception {
        String[] attrValues;
        Entity result = (Entity)klass.newInstance();
        int left = objStr.indexOf(40);
        int right = objStr.lastIndexOf(41);
        String content = objStr.substring(left + 1, right);
        for (String attrValue : attrValues = content.split(" ")) {
            String[] av = attrValue.split("=");
            String attr = av[0];
            String value = av[1];
            if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                value = value.substring(1, value.length() - 1);
            }
            result.set(attr, value);
        }
        return (T)result;
    }

    @Override
    public void set(String name, Object value) throws Exception {
        this.set(new SingletonTuple<Object>(name, value), false);
    }

    @Override
    public void set(Tuple values) throws Exception {
        this.set(values, true);
    }

    @Override
    public Tuple getValues() {
        return new EntityTuple(this);
    }

    @Override
    public String getValues(String sep) {
        StringWriter out = new StringWriter();
        for (String field : this.getFields()) {
            Object valueO = this.get(field);
            String valueS = valueO != null ? valueO.toString() : "";
            valueS = valueS.replaceAll("\r\n", " ").replaceAll("\n", " ").replaceAll("\r", " ");
            valueS = valueS.replaceAll("\t", " ").replaceAll(sep, " ");
            out.write(valueS);
        }
        return out.toString();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    public static Date string2date(String str) throws ParseException {
        String dateFormat = "MMMM d, yyyy";
        String dateFormat2 = "dd-MM-yyyy";
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, Locale.US);
            return new Date(formatter.parse(str).getTime());
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(dateFormat2, Locale.US);
                return new Date(formatter.parse(str).getTime());
            }
            catch (ParseException pe2) {
                throw new ParseException("parsing failed: expected date value formatted '" + dateFormat + " or " + dateFormat2, 0);
            }
        }
    }

    public String get__Type() {
        return this.__Type;
    }

    public String get__TypeLabel() {
        if (this.get("__Type_Label") != null) {
            return this.get("__Type_Label").toString();
        }
        return null;
    }

    public List<ValueLabel> get__TypeOptions() {
        if (this.get("__Type_options") != null) {
            return (List)this.get("__Type_options");
        }
        return null;
    }

    public void set__Type(String type) {
        this.__Type = type;
    }

    @Override
    public String getLabelValue() {
        StringBuilder resultBuilder = new StringBuilder();
        for (String label : this.getLabelFields()) {
            if (resultBuilder.length() > 0) {
                resultBuilder.append(':');
            }
            if (this.get(label) == null) continue;
            resultBuilder.append(this.get(label));
        }
        return resultBuilder.toString();
    }
}

