/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.io.excel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.molgenis.io.TupleReader;
import org.molgenis.io.processor.AbstractCellProcessor;
import org.molgenis.io.processor.CellProcessor;
import org.molgenis.util.tuple.AbstractTuple;
import org.molgenis.util.tuple.Tuple;

public class ExcelSheetReader
implements TupleReader {
    private final Sheet sheet;
    private final boolean hasHeader;
    private List<CellProcessor> cellProcessors;
    private Map<String, Integer> colNamesMap;

    ExcelSheetReader(Sheet sheet, boolean hasHeader, List<CellProcessor> cellProcessors) {
        if (sheet == null) {
            throw new IllegalArgumentException("sheet is null");
        }
        this.sheet = sheet;
        this.hasHeader = hasHeader;
        this.cellProcessors = cellProcessors;
    }

    public String getName() {
        return this.sheet.getSheetName();
    }

    public int getNrRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    @Override
    public boolean hasColNames() {
        return this.hasHeader;
    }

    @Override
    public Iterator<String> colNamesIterator() throws IOException {
        if (!this.hasHeader) {
            return null;
        }
        Iterator it = this.sheet.iterator();
        if (!it.hasNext()) {
            return null;
        }
        if (this.colNamesMap == null) {
            this.colNamesMap = this.toColNamesMap((Row)it.next());
        }
        return this.colNamesMap != null ? this.colNamesMap.keySet().iterator() : null;
    }

    @Override
    public Iterator<Tuple> iterator() {
        Map<String, Integer> colNamesMap;
        final Iterator it = this.sheet.iterator();
        if (!it.hasNext()) {
            return Collections.emptyList().iterator();
        }
        if (this.hasHeader) {
            Row headerRow = (Row)it.next();
            colNamesMap = this.colNamesMap == null ? this.toColNamesMap(headerRow) : this.colNamesMap;
        } else {
            colNamesMap = null;
        }
        return new Iterator<Tuple>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Tuple next() {
                if (colNamesMap == null) {
                    return new ExcelTuple((Row)it.next(), ExcelSheetReader.this.cellProcessors);
                }
                return new ExcelIndexTuple((Row)it.next(), colNamesMap, ExcelSheetReader.this.cellProcessors);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    @Override
    public void close() throws IOException {
    }

    private Map<String, Integer> toColNamesMap(Row headerRow) {
        if (headerRow == null) {
            return null;
        }
        LinkedHashMap<String, Integer> columnIdx = new LinkedHashMap<String, Integer>();
        int i = 0;
        Iterator it = headerRow.cellIterator();
        while (it.hasNext()) {
            String header = AbstractCellProcessor.processCell(((Cell)it.next()).getStringCellValue(), true, this.cellProcessors);
            columnIdx.put(header, i++);
        }
        return columnIdx;
    }

    private static String toValue(Cell cell, List<CellProcessor> cellProcessors) {
        String value;
        block0 : switch (cell.getCellType()) {
            case 3: {
                value = null;
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue().toString();
                    break;
                }
                double x = cell.getNumericCellValue();
                if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                    value = String.valueOf((int)x);
                    break;
                }
                value = String.valueOf(x);
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 4: {
                        value = String.valueOf(cellValue.getBooleanValue());
                        break block0;
                    }
                    case 0: {
                        double x = cellValue.getNumberValue();
                        if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                            value = String.valueOf((int)x);
                            break block0;
                        }
                        value = String.valueOf(x);
                        break block0;
                    }
                    case 1: {
                        value = cellValue.getStringValue();
                        break block0;
                    }
                    case 3: {
                        value = null;
                        break block0;
                    }
                }
                throw new RuntimeException("unsupported cell type: " + cellValue.getCellType());
            }
            default: {
                throw new RuntimeException("unsupported cell type: " + cell.getCellType());
            }
        }
        return AbstractCellProcessor.processCell(value, false, cellProcessors);
    }

    public static class ExcelIndexTuple
    extends AbstractTuple {
        private static final long serialVersionUID = 1L;
        private final transient Row row;
        private final Map<String, Integer> colNamesMap;
        private final List<CellProcessor> cellProcessors;

        public ExcelIndexTuple(Row row, Map<String, Integer> colNamesMap, List<CellProcessor> cellProcessors) {
            if (row == null) {
                throw new IllegalArgumentException("row is null");
            }
            if (colNamesMap == null) {
                throw new IllegalArgumentException("column names map is null");
            }
            this.row = row;
            this.colNamesMap = colNamesMap;
            this.cellProcessors = cellProcessors;
        }

        @Override
        public int getNrCols() {
            return this.colNamesMap.size();
        }

        @Override
        public boolean hasColNames() {
            return true;
        }

        @Override
        public Iterable<String> getColNames() {
            return Collections.unmodifiableSet(this.colNamesMap.keySet());
        }

        @Override
        public Object get(String colName) {
            Integer col = this.colNamesMap.get(colName);
            return col != null ? this.get(col) : null;
        }

        @Override
        public Object get(int col) {
            Cell cell = this.row.getCell(col);
            return cell != null ? ExcelSheetReader.toValue(cell, this.cellProcessors) : null;
        }

        public boolean isBold(int col) {
            Cell cell = this.row.getCell(col);
            return cell == null ? false : this.row.getSheet().getWorkbook().getFontAt(cell.getCellStyle().getFontIndex()).getBoldweight() == 700;
        }
    }

    public static class ExcelTuple
    extends AbstractTuple {
        private static final long serialVersionUID = 1L;
        private final Row row;
        private final List<CellProcessor> cellProcessors;

        public ExcelTuple(Row row, List<CellProcessor> cellProcessors) {
            if (row == null) {
                throw new IllegalArgumentException("row is null");
            }
            this.row = row;
            this.cellProcessors = cellProcessors;
        }

        @Override
        public int getNrCols() {
            return this.row.getLastCellNum();
        }

        @Override
        public boolean hasColNames() {
            return false;
        }

        @Override
        public Iterable<String> getColNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(String colName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(int col) {
            Cell cell = this.row.getCell(col);
            return cell != null ? ExcelSheetReader.toValue(cell, this.cellProcessors) : null;
        }

        public boolean isBold(int col) {
            Cell cell = this.row.getCell(col);
            return cell == null ? false : this.row.getSheet().getWorkbook().getFontAt(cell.getCellStyle().getFontIndex()).getBoldweight() == 700;
        }
    }
}

