/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.server;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class EntityServiceGen
extends Generator {
    private static final Logger logger = Logger.getLogger(EntityServiceGen.class);

    @Override
    public String getDescription() {
        return "Generates REST service interfaces for each entity.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            this.generateServices(model, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServices(Model model, MolgenisOptions options) throws Exception {
        Template template = this.createTemplate("/EntityServiceGen.java.ftl");
        Map<String, Object> templateArgs = this.createTemplateArguments(options);
        for (Entity entity : model.getEntities()) {
            if (entity.isAbstract() || entity.isSystem()) continue;
            templateArgs.put("entity", entity);
            File generatedFile = new File(this.getSourcePath(options) + "org/molgenis/service/" + entity.getName() + "Service.java");
            boolean created = generatedFile.getParentFile().mkdirs();
            if (!created && !generatedFile.getParentFile().exists()) {
                throw new IOException("could not create " + generatedFile.getParentFile());
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(generatedFile), Charset.forName("UTF-8"));
            try {
                template.process(templateArgs, (Writer)writer);
            }
            finally {
                writer.close();
            }
            logger.info((Object)("generated " + generatedFile));
        }
    }
}

