/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.doc;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;

public class DotDocMinimalGen
extends Generator {
    private static final Logger logger = Logger.getLogger(DotDocMinimalGen.class);
    public static final String GRAPHVIZ_COMMAND_WINDOWS = "dot";

    @Override
    public String getDescription() {
        return "Generates one documentation file describing all entities.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            File target = new File(this.getDocumentationPath(options) + "/objectmodel-uml-diagram-summary.dot");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            List<Entity> entityList = model.getEntities();
            templateArgs.put("model", model);
            templateArgs.put("module", model);
            templateArgs.put("entities", entityList);
            this.apply(templateArgs, template, target);
            logger.info((Object)("generated " + target));
            this.executeDot(target, "png");
            for (Module module : model.getModules()) {
                entityList = module.getEntities();
                templateArgs.put("model", model);
                templateArgs.put("module", module);
                templateArgs.put("entities", entityList);
                target = new File(this.getDocumentationPath(options) + "/objectmodel-uml-diagram-summary-" + module.getName() + ".dot");
                this.apply(templateArgs, template, target);
                this.executeDot(target, "png");
                logger.info((Object)("generated " + target));
            }
        }
    }

    private void apply(Map<String, Object> templateArgs, Template template, File target) throws IOException, TemplateException {
        FileOutputStream targetOut = new FileOutputStream(target);
        template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
        ((OutputStream)targetOut).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDot(File dotFile, String type) {
        String command = "";
        String result = "";
        try {
            command = command + "dot -T" + type + " -O \"" + dotFile.getAbsolutePath() + "\"";
            logger.debug((Object)("Executing: " + command));
            Runtime.getRuntime().exec(command);
            logger.debug((Object)("Data model image was generated succesfully.\nOutput:\n" + result));
        }
        catch (Exception e) {
            logger.error((Object)("Generation of graphical documentation failed: return code " + e.getMessage() + ". Install GraphViz and put dot.exe on your path."));
        }
    }
}

