/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.db;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;

public class MolgenisDatabasePopulatorGen
extends Generator {
    private static final Logger logger = Logger.getLogger(MolgenisDatabasePopulatorGen.class);

    @Override
    public String getDescription() {
        return "Generates one MolgenisDatabasePopulator class that will insert data into the database (for auth)";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            Vector<Entity> entityList = model.getEntities();
            File target = new File(this.getSourcePath(options) + "org/molgenis" + "/MolgenisDatabasePopulator.java");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            templateArgs.put("model", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("package", "org/molgenis".replace('/', '.'));
            templateArgs.put("auth_loginclass", options.auth_loginclass);
            templateArgs.put("decorator_overriders", options.decorator_overriders);
            templateArgs.put("metaData", !options.auth_loginclass.endsWith("SimpleLogin"));
            templateArgs.put("databaseImpl", (Object)options.mapper_implementation);
            FileOutputStream targetOut = new FileOutputStream(target);
            template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            ((OutputStream)targetOut).close();
            logger.info((Object)("generated " + target));
        }
    }
}

