/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.text.ParseException;
import org.molgenis.framework.ui.html.AbstractRefInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.Tuple;

@SuppressWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Always use \n for newlines")
public class XrefInput<E extends Entity>
extends AbstractRefInput<E> {
    protected XrefInput() {
    }

    public XrefInput(String name, Class<? extends Entity> xrefEntityClass, E value) {
        super(name, xrefEntityClass, value);
        this.setXrefEntity(xrefEntityClass);
    }

    public XrefInput(String name, Class<E> xrefEntityClass) {
        super(name, xrefEntityClass, null);
        this.setXrefEntity(this.xrefEntity);
    }

    public XrefInput(String name, String label, E value, Boolean nillable, Boolean readonly, String description, Class<? extends Entity> xrefEntityClass) {
        super(name, xrefEntityClass, label, value, nillable, readonly, description);
        this.setXrefEntity(xrefEntityClass);
    }

    public XrefInput(Tuple t) throws HtmlInputException {
        super(t);
    }

    @Override
    public String getValue() {
        if (this.getObject() != null) {
            return ((Entity)this.getObject()).getLabelValue();
        }
        return "";
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        return new XrefInput<E>(params).render();
    }

    @Override
    public void set(Tuple t) throws HtmlInputException {
        super.set(t);
        if (t.isNull("xrefEntity")) {
            throw new HtmlInputException("parameter xrefEntity cannot be null");
        }
        this.setXrefEntity(t.getString("xrefEntity"));
    }

    public XrefInput(String name, String entityClassname) throws HtmlInputException, ClassNotFoundException {
        this(name, Class.forName(entityClassname), null);
    }

    @Override
    protected String renderOptions() {
        StringBuilder options = new StringBuilder();
        if (this.getObject() != null) {
            options.append(String.format("\t<option selected value=\"%s\">%s</option>\n", ((Entity)this.getObject()).getIdValue(), this.getValue()));
        }
        return options.toString();
    }

    @Override
    protected String getHtmlRefType() {
        return "search";
    }

    @Override
    public String renderHidden() {
        String value = this.getObject() == null ? "" : ((Entity)this.getObject()).getIdValue();
        return "<input name=\"" + this.getName() + "\" type=\"hidden\" value=\"" + value + "\"/>";
    }
}

