/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.framework.ui.html.ActionInput;
import org.molgenis.framework.ui.html.BoolInput;
import org.molgenis.framework.ui.html.CheckboxInput;
import org.molgenis.framework.ui.html.DateInput;
import org.molgenis.framework.ui.html.DecimalInput;
import org.molgenis.framework.ui.html.EnumInput;
import org.molgenis.framework.ui.html.FileInput;
import org.molgenis.framework.ui.html.HiddenInput;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.IntInput;
import org.molgenis.framework.ui.html.MrefInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.framework.ui.html.TextInput;
import org.molgenis.framework.ui.html.XrefInput;
import org.molgenis.util.tuple.KeyValueTuple;

public class WidgetFactory {
    public static void configure(Configuration conf) {
        LinkedHashMap<String, HtmlInput> map = new LinkedHashMap<String, HtmlInput>();
        map.put("action", new ActionInput());
        map.put("bool", new BoolInput());
        map.put("string", new StringInput());
        map.put("checkbox", new CheckboxInput());
        map.put("date", new DateInput());
        map.put("datetime", new DateInput());
        map.put("decimal", new DecimalInput());
        map.put("enum", new EnumInput());
        map.put("file", new FileInput());
        map.put("int", new IntInput());
        map.put("xref", new XrefInput());
        map.put("mref", new MrefInput());
        map.put("text", new TextInput());
        map.put("hidden", new HiddenInput());
        for (Map.Entry entry : map.entrySet()) {
            conf.setSharedVariable((String)entry.getKey(), (TemplateModel)new HtmlInputAdapter((HtmlInput)entry.getValue()));
        }
    }

    public static class HtmlInputAdapter
    implements TemplateDirectiveModel {
        HtmlInput<?> input = null;

        private HtmlInputAdapter(HtmlInput<?> input) {
            this.input = input;
        }

        public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) {
            KeyValueTuple tuple = new KeyValueTuple();
            for (Object key : params.keySet()) {
                if (params.get(key) instanceof SimpleScalar) {
                    tuple.set(key.toString(), ((SimpleScalar)params.get(key)).toString());
                    continue;
                }
                tuple.set(key.toString(), params.get(key));
            }
            try {
                env.getOut().write(this.input.render(tuple));
            }
            catch (Exception e) {
                try {
                    env.getOut().write("macro failed: " + e.getMessage() + "<br/>");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }
}

