/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import org.molgenis.framework.ui.html.HtmlElement;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlSettings;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.util.tuple.Tuple;

public class ValidatingInput<E>
extends HtmlInput<E> {
    public int height;
    private int minHeight = 1;
    private int maxHeight = 1;
    public int width = 32;
    public int maxWidth = 255;
    private int fontsize = 16;
    protected String validationString = "";

    public ValidatingInput(Tuple properties) throws HtmlInputException {
        super(properties);
    }

    public ValidatingInput(String name) {
        this(name, null);
    }

    public ValidatingInput(String name, E value) {
        super(name, value);
    }

    public ValidatingInput(String name, String label, E value) {
        super(name, label, value);
    }

    public ValidatingInput(String name, String label, E value, boolean nillable, boolean readonly, String description) {
        this(name, value);
        this.setLabel(label);
        this.setNillable(nillable);
        this.setReadonly(readonly);
        this.setDescription(description);
    }

    protected ValidatingInput() {
    }

    @Override
    public String toHtml() {
        String descriptionJS;
        String readonly;
        String string = readonly = this.isReadonly() ? "readonly " : "";
        if (this.isHidden() && (this.uiToolkit == HtmlElement.UiToolkit.ORIGINAL || this.uiToolkit == HtmlElement.UiToolkit.JQUERY)) {
            return "<input name=\"" + this.getName() + "\"type=\"hidden\" value=\"" + this.getObjectString() + "\"/>";
        }
        String validate = " " + this.validationString;
        if (!this.isNillable() && !this.isReadonly()) {
            validate = validate + " required";
        }
        String cssClass = this.uiToolkit == HtmlElement.UiToolkit.JQUERY ? " class=\"text ui-widget-content ui-corner-all" + validate + " " + readonly + "\"" : "";
        String description = " title=\"" + this.getDescription() + "\"";
        String string2 = descriptionJS = HtmlSettings.showDescription ? ".bt()" : "";
        if (this.maxHeight > 1) {
            String result = "<textarea " + description + cssClass + " id=\"" + this.getId() + "\" name=\"" + this.getName() + "\"  " + (this.getSize() != null && this.getSize() > 0 ? "onfocus=\"startcounter(this, " + this.getSize() + ")\" onblur=\"endcounter()\"" : "") + " cols=\"" + this.getWidth() + "\" rows=\"" + this.getHeight() + "\" " + readonly + " >" + this.getObjectString() + "</textarea>";
            result = result + "<script>$('#" + this.getId() + "')" + descriptionJS + "; showTextInput(document.getElementById('" + this.getId() + "')," + this.getMinHeight() + "," + this.getMaxHeight() + ");</script>";
            return result;
        }
        String result = "<input " + description + cssClass + " id=\"" + this.getId() + "\" name=\"" + this.getName() + "\"  " + (this.getSize() != null && this.getSize() > 0 ? "onfocus=\"startcounter(this, " + this.getSize() + ")\" onblur=\"endcounter()\"" : "") + readonly + " value=\"" + this.getObjectString() + "\">";
        result = result + "<script>$('#" + this.getId() + "')" + descriptionJS + ".autoGrowInput({comfortZone: 16, minWidth:" + this.getWidth() * this.fontsize + ", maxWidth: " + this.getMaxWidth() * this.fontsize + "});</script>";
        return result;
    }

    @Override
    public String toHtml(Tuple params) throws HtmlInputException, ParseException {
        return new StringInput(params).render();
    }

    @Override
    public String getCustomHtmlHeaders() {
        return "";
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public ValidatingInput<E> setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getFontsize() {
        return this.fontsize;
    }

    public void setFontsize(int fontsize) {
        this.fontsize = fontsize;
    }
}

