/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.util.Pair;
import org.molgenis.util.tuple.Tuple;

public class Table
extends HtmlWidget {
    LinkedHashMap<Pair<Integer, Integer>, Object> cells = new LinkedHashMap();
    LinkedHashMap<Pair<Integer, Integer>, String> cellStyles = new LinkedHashMap();
    List<String> cols = new ArrayList<String>();
    List<String> rows = new ArrayList<String>();
    String style = null;
    protected String defaultCellStyle = "border: 1px solid black; padding:2px";
    protected String headerCellStyle = "border: 1px solid black; padding:2px; background-color: #5B82A4; color: white";
    boolean headerColumn = true;
    boolean headerRow = true;

    public Table(String name) {
        this(name, "");
    }

    public Table(String name, String label) {
        super(name, label);
        this.setLabel(label);
    }

    public Table(String name, String label, boolean headerColumn, boolean headerRow) {
        super(name, label);
        this.setLabel(label);
        this.headerColumn = headerColumn;
        this.headerRow = headerRow;
    }

    @Override
    public String toHtml() {
        String result = "<table";
        if (this.style != null) {
            result = result + " style=\"clear:both;" + this.style + "\"";
        }
        result = result + " width=\"400\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"display\" id=\"" + this.getId() + "\">";
        if (this.headerRow) {
            result = result + this.printHeaders();
        }
        result = result + this.printBody();
        result = result + "</table>";
        return result;
    }

    private String printHeaders() {
        StringBuilder strBuilder = new StringBuilder("<thead><tr>");
        if (this.headerColumn) {
            strBuilder.append("<th></th>");
        }
        for (String col : this.cols) {
            strBuilder.append("<th style=\"").append(this.getHeaderCellStyle()).append("\">").append(col).append("</th>");
        }
        strBuilder.append("</tr></thead>");
        return strBuilder.toString();
    }

    private String printBody() {
        StringBuilder strBuilder = new StringBuilder("<tbody>");
        int rowCount = 0;
        for (String row : this.rows) {
            strBuilder.append(this.printRow(row, rowCount));
            ++rowCount;
        }
        strBuilder.append("</tbody>");
        return strBuilder.toString();
    }

    String printRow(String row, int rowCount) {
        StringBuilder strBuilder = new StringBuilder("<tr>");
        if (this.headerColumn) {
            strBuilder.append("<th style=\"").append(this.getHeaderCellStyle()).append("\">").append(row).append("</th>");
        }
        for (int colCount = 0; colCount < this.cols.size(); ++colCount) {
            strBuilder.append("<td style=\"").append(this.getCellStyle(colCount, rowCount)).append("\">");
            strBuilder.append(this.getCellString(colCount, rowCount)).append("</td>");
        }
        strBuilder.append("</tr>");
        return strBuilder.toString();
    }

    @Override
    public HtmlInput<String> setStyle(String style) {
        this.style = style;
        return this;
    }

    public Integer addColumn(String colName) {
        this.cols.add(colName);
        return this.cols.size() - 1;
    }

    public String removeColumn(int colNr) {
        return this.cols.remove(colNr);
    }

    public Integer addRow(String rowName) {
        this.rows.add(rowName);
        return this.rows.size() - 1;
    }

    public String removeRow(int rowNr) {
        return this.rows.remove(rowNr);
    }

    public void setCell(int col, int row, Object contents) {
        this.cells.put(new Pair<Integer, Integer>(col, row), contents);
    }

    public Object getCell(int col, int row) {
        return this.cells.get(new Pair<Integer, Integer>(col, row));
    }

    public String getCellString(int col, int row) {
        Object o = this.cells.get(new Pair<Integer, Integer>(col, row));
        if (o == null) {
            return "";
        }
        if (o instanceof HtmlInput) {
            return ((HtmlInput)o).toHtml();
        }
        return o.toString();
    }

    public void setDefaultCellStyle(String defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
    }

    public void setCellStyle(int col, int row, String cellStyle) {
        this.cellStyles.put(new Pair<Integer, Integer>(col, row), cellStyle);
    }

    public String getCellStyle(int col, int row) {
        String style = this.cellStyles.get(new Pair<Integer, Integer>(col, row));
        if (style != null) {
            return style;
        }
        return this.defaultCellStyle;
    }

    public void setHeaderCellStyle(String headerCellStyle) {
        this.headerCellStyle = headerCellStyle;
    }

    public String getHeaderCellStyle() {
        return this.headerCellStyle;
    }

    @Override
    public String toHtml(Tuple params) throws ParseException, HtmlInputException {
        throw new UnsupportedOperationException();
    }
}

