/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;

public class EntityJqGrid
extends HtmlWidget {
    String klazzName;
    Entity entityModel;

    public EntityJqGrid(String name, Class<? extends org.molgenis.util.Entity> entityClass, Database db) throws DatabaseException {
        super(name);
        this.entityModel = db.getMetaData().getEntity(entityClass.getSimpleName());
        this.klazzName = entityClass.getName();
    }

    @Override
    public String toHtml() {
        String colNames = "";
        String colDefs = "";
        try {
            for (Field field : this.entityModel.getAllFields()) {
                if (field.getType() instanceof XrefField || field.getType() instanceof MrefField) {
                    for (String label : field.getXrefLabelNames()) {
                        colNames = colNames + "'" + field.getName() + "',";
                        colDefs = colDefs + String.format("{name: '%s', index: '%s', width: 55},", field.getName() + "_" + label, field.getName());
                    }
                    continue;
                }
                colNames = colNames + "'" + field.getLabel() + "',";
                colDefs = colDefs + String.format("{name: '%s', index: '%s', width: 55},", field.getName(), field.getName());
            }
            colDefs = colDefs.substring(0, colDefs.length() - 2);
            colNames = colNames.substring(0, colNames.length() - 2);
            String result = "";
            result = result + "<div id=\"" + this.getName() + "_pager\"></div>";
            result = result + "<table id=\"" + this.getName() + "\"><tr><td/></tr></table>";
            result = result + "<script>$('#" + this.getName() + "').jqGrid({";
            result = result + "\n\turl:'jqgrid',";
            result = result + "\n   datatype: 'json',";
            result = result + "\n   mtype: 'POST',";
            result = result + "\n\tcolNames:[" + colNames + "],";
            result = result + "\n\tcolModel :[" + colDefs + "],";
            result = result + "\n\tpager: '#" + this.getName() + "_pager',";
            result = result + "\n\trowNum:10,";
            result = result + "\n\tsortname: '" + this.entityModel.getPrimaryKey().getName() + "',";
            result = result + "\n\tsortorder: 'desc',";
            result = result + "\n\trowList:[10,20,30,50],";
            result = result + "\n\tviewrecords: true,";
            result = result + "\n\tgridview: true,";
            result = result + "\n\tjsonReader : {root: 'rows',  page: 'page', total: 'total', records: 'records',repeatitems: false, id: '0'},";
            result = result + "\n\tcaption: '" + this.getLabel() + "',";
            result = result + "\n\tautowidth: true,";
            result = result + "\n\tpostData: { entity : '" + this.klazzName + "'}";
            result = result + "\n});";
            result = result + "\n$('#" + this.getName() + "_pager_left').append('<label>Search: <input type=\"text\" onkeyup=\"$(\\'#" + this.getName() + "\\').setGridParam({postData : { filter : this.value} }).trigger(\\'reloadGrid\\');\"></label>');";
            result = result + "\n</script>";
            return result;
        }
        catch (Exception e) {
            return "EntityJqGrid configuration error: " + e.getMessage();
        }
    }
}

