/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.molgenis.framework.ui.html.HtmlForm;
import org.molgenis.framework.ui.html.HtmlInput;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.SingletonTuple;

public abstract class EntityForm<E extends Entity>
extends HtmlForm {
    private E entity = null;

    public EntityForm() {
        try {
            this.setEntity((Entity)this.getEntityClass().newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityForm(E entity) {
        this.setEntity(entity);
    }

    public E getEntity() {
        return this.entity;
    }

    public void setEntity(E entity) {
        this.entity = entity;
    }

    @Override
    public void setInputs(List<HtmlInput<?>> inputs) {
        throw new UnsupportedOperationException("In EntityForm the inputs cannot be changed");
    }

    public void set(String name, Object value) throws Exception {
        this.getEntity().set(new SingletonTuple<Object>(name, value), false);
    }

    public abstract Class<E> getEntityClass();

    public abstract Vector<String> getHeaders();

    public List<HtmlInput<?>> getInputs(String ... fieldNames) {
        E entity = this.getEntity();
        List<HtmlInput<?>> inputs = this.getInputs();
        ArrayList result = new ArrayList();
        for (String fieldName : fieldNames) {
            if (!entity.getFields().contains(fieldName)) {
                throw new RuntimeException(fieldName + " not known in " + this.getClass().getSimpleName());
            }
            for (HtmlInput<?> input : inputs) {
                if (!input.getName().equalsIgnoreCase(entity.getClass().getSimpleName() + "_" + fieldName)) continue;
                result.add(input);
            }
        }
        return result;
    }
}

