/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.ui.ApplicationController;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.html.HtmlInputException;
import org.molgenis.util.FileLink;
import org.molgenis.util.SimpleTree;

public abstract class SimpleScreenController<MODEL extends ScreenModel>
extends SimpleTree<ScreenController<?>>
implements ScreenController<MODEL>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = Logger.getLogger(this.getClass());
    private MODEL model;
    protected String selectedId;

    public SimpleScreenController(String name, MODEL model, ScreenController<?> parent) {
        super(name, parent);
        this.model = model;
    }

    @Override
    public abstract void reload(Database var1) throws Exception;

    public void doResetChildren() {
        for (ScreenController subform : this.getChildren()) {
            subform.getModel().reset();
        }
    }

    @Override
    public FileLink getTempFile() throws IOException {
        return this.getApplicationController().getTempFile();
    }

    public boolean isSelected(ScreenModel model) {
        ScreenModel selected = this.getModel().getSelected();
        if (selected != null && model != null) {
            return selected.getController().getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public ApplicationController getApplicationController() {
        return (ApplicationController)this.getRoot();
    }

    @Override
    public MODEL getModel() {
        return this.model;
    }

    public void setModel(MODEL model) {
        this.model = model;
    }

    @Override
    public String getViewTemplate() {
        return null;
    }

    @Override
    public String getCustomHtmlHeaders() {
        StringBuilder resultBuilder = new StringBuilder();
        for (ScreenController c : this.getChildren()) {
            resultBuilder.append("<!--custom html headers: ").append(c.getName()).append("-->");
            resultBuilder.append(c.getCustomHtmlHeaders());
        }
        return resultBuilder.toString();
    }

    @Override
    public String getLabel() {
        return this.getModel().getLabel();
    }

    @Override
    public String getCustomHtmlBodyOnLoad() {
        StringBuilder resultBuilder = new StringBuilder();
        for (ScreenController c : this.getChildren()) {
            resultBuilder.append(c.getCustomHtmlBodyOnLoad());
        }
        return resultBuilder.toString();
    }

    @Override
    public void setSelected(String viewid) {
        if (this.getParent() != null) {
            this.logger.debug((Object)"call setselected on parent");
            ((ScreenController)this.getParent()).setSelected(this.getName());
        }
        this.logger.debug((Object)("Screen " + this.getName() + " selected " + viewid));
        this.selectedId = viewid;
    }

    @Override
    public ScreenModel getSelected() {
        if (this.getChild(this.selectedId) != null) {
            return ((ScreenController)this.getChild(this.selectedId)).getModel();
        }
        return null;
    }

    @Override
    public String render() throws HtmlInputException {
        String result = this.getView().render();
        if (result == null || result.isEmpty()) {
            throw new HtmlInputException("render showed nothing for " + this);
        }
        return result;
    }

    @Override
    public Database getDatabase() {
        return this.getApplicationController().getDatabase();
    }
}

