/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.ScreenModel;
import org.molgenis.framework.ui.SimpleScreenModel;

public class MenuModel
extends SimpleScreenModel {
    List<String> hiddenScreenNames = new ArrayList<String>();
    private static final long serialVersionUID = -1211550529820121110L;
    private Position position = Position.DEFAULT;

    public MenuModel(ScreenController<MenuModel> controller) {
        super(controller);
    }

    public void hide(String name) {
        if (this.getController().get(name) != null) {
            this.hiddenScreenNames.add(name);
        }
    }

    public void show(String name) {
        this.hiddenScreenNames.remove(name);
    }

    public List<ScreenModel> getVisibleChildren() {
        Vector subscreens = this.getController().getChildren();
        ArrayList<ScreenModel> result = new ArrayList<ScreenModel>();
        for (ScreenController s : subscreens) {
            if (this.hiddenScreenNames.indexOf(s.getName()) >= 0 || !s.getModel().isVisible()) continue;
            result.add((ScreenModel)s.getModel());
        }
        return result;
    }

    @Override
    public ScreenModel getSelected() {
        List<ScreenModel> subscreens = this.getVisibleChildren();
        if (subscreens.contains(super.getSelected())) {
            return super.getSelected();
        }
        if (subscreens.size() > 0) {
            return subscreens.get(0);
        }
        logger.error((Object)("Menu " + this.getName() + " doesn't have any subforms attached!"));
        return null;
    }

    @Override
    public boolean isVisible() {
        return this.getVisibleChildren().size() > 0;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return "MenuModel(name=" + this.getName() + ")";
    }

    public static enum Position {
        TOP_RIGHT,
        TOP_LEFT,
        LEFT,
        DEFAULT;

    }
}

