/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view.renderers;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridResult;
import org.molgenis.framework.tupletable.view.JQGridView;
import org.molgenis.framework.tupletable.view.renderers.CsvExporter;
import org.molgenis.framework.tupletable.view.renderers.ExcelExporter;
import org.molgenis.framework.tupletable.view.renderers.SPSSExporter;
import org.molgenis.util.ZipUtils;

public class Renderers {

    public static class SPSSRenderer
    implements Renderer {
        @Override
        public void export(MolgenisRequest request, String fileName, TupleTable tupleTable, int totalPages, int currentPage) throws TableException, IOException {
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                File spssFile = File.createTempFile("spssExport", ".sps", tempDir);
                File spssCsvFile = File.createTempFile("csvSpssExport", ".csv", tempDir);
                File zipExport = File.createTempFile("spssExport", ".zip", tempDir);
                FileOutputStream spssFileStream = new FileOutputStream(spssFile);
                FileOutputStream spssCsvFileStream = new FileOutputStream(spssCsvFile);
                SPSSExporter spssExporter = new SPSSExporter(tupleTable);
                spssExporter.export(spssCsvFileStream, spssFileStream, spssCsvFile.getName());
                spssCsvFileStream.close();
                spssFileStream.close();
                ZipUtils.compress(Arrays.asList(spssFile, spssCsvFile), zipExport, ZipUtils.DirectoryStructure.EXCLUDE_DIR);
                HeaderHelper.setHeader(request.getResponse(), "application/octet-stream", fileName + ".zip");
                this.exportFile(zipExport, request.getResponse());
            }
            catch (Exception e) {
                throw new TableException(e);
            }
        }

        private void exportFile(File file, HttpServletResponse response) throws IOException {
            FileInputStream fileIn = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            byte[] outputByte = new byte[4096];
            while (fileIn.read(outputByte, 0, 4096) != -1) {
                out.write(outputByte, 0, 4096);
            }
            fileIn.close();
            out.flush();
            out.close();
        }
    }

    public static class CSVRenderer
    implements Renderer {
        @Override
        public void export(MolgenisRequest request, String fileName, TupleTable tupleTable, int totalPages, int currentPage) throws TableException, IOException {
            HeaderHelper.setHeader(request.getResponse(), "application/ms-excel", fileName + ".csv");
            CsvExporter csvExporter = new CsvExporter(tupleTable);
            csvExporter.export((OutputStream)request.getResponse().getOutputStream());
        }
    }

    public static class ExcelRenderer
    implements Renderer {
        @Override
        public void export(MolgenisRequest request, String fileName, TupleTable tupleTable, int totalPages, int currentPage) throws TableException, IOException {
            HeaderHelper.setHeader(request.getResponse(), "application/ms-excel", fileName + ".xlsx");
            ExcelExporter excelExport = new ExcelExporter(tupleTable);
            excelExport.export((OutputStream)request.getResponse().getOutputStream());
        }
    }

    public static class JQGridRenderer
    implements Renderer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void export(MolgenisRequest request, String fileName, TupleTable tupleTable, int totalPages, int currentPage) throws TableException, IOException {
            JQGridResult result = JQGridView.buildJQGridResults(tupleTable.getCount(), totalPages, currentPage, tupleTable);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)request.getResponse().getOutputStream(), Charset.forName("UTF-8"));
            try {
                new Gson().toJson((Object)result, (Appendable)writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
    }

    public static interface Renderer {
        public void export(MolgenisRequest var1, String var2, TupleTable var3, int var4, int var5) throws TableException, IOException;
    }

    public static class HeaderHelper {
        public static void setHeader(HttpServletResponse response, String contentType, String fileName) {
            response.setContentType(contentType);
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        }
    }
}

