/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.tupletable.DatabaseTupleTable;
import org.molgenis.framework.tupletable.EditableTupleTable;
import org.molgenis.framework.tupletable.FilterableTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridConfiguration;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridFilter;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridPostData;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridResult;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridRule;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridSearchOptions;
import org.molgenis.framework.tupletable.view.JQGridViewCallback;
import org.molgenis.framework.tupletable.view.ViewFactoryImpl;
import org.molgenis.framework.tupletable.view.renderers.Renderers;
import org.molgenis.framework.ui.FreemarkerView;
import org.molgenis.framework.ui.ScreenController;
import org.molgenis.framework.ui.html.HtmlWidget;
import org.molgenis.util.HandleRequestDelegationException;
import org.molgenis.util.tuple.Tuple;

public class JQGridView
extends HtmlWidget {
    public static final String OPERATION = "Operation";
    private static final int DEFAULT_MAX_VISIBLE_COLUMN_COUNT = 5;
    private JQGridSearchOptions searchOptions;
    private final int maxVisibleColumnCount = 5;
    private JQGridViewCallback callback;
    private final TupleTableBuilder tupleTableBuilder;

    private JQGridView(String name, TupleTableBuilder tupleTableBuilder) {
        super(name);
        this.tupleTableBuilder = tupleTableBuilder;
    }

    public JQGridView(String name, final ScreenController<?> hostController, final TupleTable table) {
        this(name, new TupleTableBuilder(){

            @Override
            public String getUrl() {
                return "molgenis.do?__target=" + hostController.getName() + "&__action=download_json_dataset";
            }

            @Override
            public TupleTable create(Tuple request) throws TableException {
                return table;
            }
        });
        if (hostController instanceof JQGridViewCallback) {
            this.callback = (JQGridViewCallback)((Object)hostController);
        }
    }

    public JQGridView(String name, ScreenController<?> hostController, TupleTable table, JQGridSearchOptions searchOptions) {
        this(name, hostController, table);
        this.searchOptions = searchOptions;
    }

    public void handleRequest(Database db, MolgenisRequest request, OutputStream out) throws HandleRequestDelegationException {
        try {
            TupleTable tupleTable = this.tupleTableBuilder.create(request);
            tupleTable.setColLimit(5);
            if (tupleTable instanceof DatabaseTupleTable) {
                ((DatabaseTupleTable)((Object)tupleTable)).setDb(db);
            }
            Operation operation = StringUtils.isNotEmpty((CharSequence)request.getString(OPERATION)) ? Operation.valueOf(request.getString(OPERATION)) : Operation.RENDER_DATA;
            switch (operation) {
                case LOAD_CONFIG: {
                    if (this.callback != null) {
                        this.callback.beforeLoadConfig(request, tupleTable);
                    }
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case HIDE_COLUMN: {
                    String columnToRemove = request.getString("column");
                    tupleTable.hideColumn(columnToRemove);
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case SHOW_COLUMN: {
                    String columnToShow = request.getString("column");
                    tupleTable.showColumn(columnToShow);
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case SET_COLUMN_PAGE: {
                    int colPage;
                    try {
                        colPage = request.getInt("colPage");
                    }
                    catch (Exception e) {
                        colPage = 1;
                    }
                    int maxColPage = (int)Math.floor((double)tupleTable.getColCount() / (double)tupleTable.getColLimit());
                    if (tupleTable.getColCount() % tupleTable.getColLimit() > 0) {
                        ++maxColPage;
                    }
                    colPage = Math.min(colPage, maxColPage);
                    int colOffset = (colPage - 1) * tupleTable.getColLimit();
                    colOffset = Math.max(colOffset, 0);
                    tupleTable.setColOffset(colOffset);
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case NEXT_COLUMNS: {
                    tupleTable.setColOffset(tupleTable.getColOffset() + 5);
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case PREVIOUS_COLUMNS: {
                    tupleTable.setColOffset(tupleTable.getColOffset() - 5);
                    this.loadTupleTableConfig(db, request, tupleTable);
                    break;
                }
                case RENDER_DATA: {
                    ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                    JQGridPostData postData = new JQGridPostData(request);
                    List<QueryRule> filterRules = JQGridView.createQueryRulesFromJQGridRequest(postData.getFilters());
                    if (!Iterables.isEmpty(filterRules)) {
                        rules.addAll(filterRules);
                    }
                    int residue = 0;
                    int rowCount = tupleTable.getCount();
                    if (rowCount % postData.getRows() != 0) {
                        residue = 1;
                    }
                    int totalPages = (int)Math.floor((double)rowCount / (double)postData.getRows()) + residue;
                    postData.setPage(Math.min(postData.getPage(), totalPages));
                    int offset = Math.max((postData.getPage() - 1) * postData.getRows(), 0);
                    String exportSelection = request.getString("exportSelection");
                    if (!StringUtils.equalsIgnoreCase((CharSequence)exportSelection, (CharSequence)"ALL")) {
                        tupleTable.setLimit(postData.getRows());
                        tupleTable.setOffset(offset);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)postData.getSidx())) {
                        QueryRule.Operator sortOperator = StringUtils.equals((CharSequence)postData.getSord(), (CharSequence)"asc") ? QueryRule.Operator.SORTASC : QueryRule.Operator.SORTDESC;
                        rules.add(new QueryRule(sortOperator, postData.getSidx()));
                    }
                    if (tupleTable instanceof FilterableTupleTable && !request.isNull("_search") && request.getBoolean("_search").booleanValue()) {
                        ((FilterableTupleTable)tupleTable).setFilters(rules);
                    }
                    this.renderData(request, postData, totalPages, tupleTable);
                    break;
                }
                case EDIT_RECORD: {
                    if (!(tupleTable instanceof EditableTupleTable)) {
                        throw new UnsupportedOperationException("TupleTable is not editable");
                    }
                    JsonObject result = new JsonObject();
                    try {
                        ((EditableTupleTable)tupleTable).update(request);
                        result.addProperty("message", "Record updated");
                        result.addProperty("success", Boolean.valueOf(true));
                    }
                    catch (TableException e) {
                        result.addProperty("message", e.getMessage());
                        result.addProperty("success", Boolean.valueOf(false));
                    }
                    request.getResponse().getOutputStream().println(result.toString());
                    break;
                }
                case ADD_RECORD: {
                    if (!(tupleTable instanceof EditableTupleTable)) {
                        throw new UnsupportedOperationException("TupleTable is not editable");
                    }
                    JsonObject result = new JsonObject();
                    try {
                        ((EditableTupleTable)tupleTable).add(request);
                        result.addProperty("message", "Record added");
                        result.addProperty("success", Boolean.valueOf(true));
                    }
                    catch (TableException e) {
                        result.addProperty("message", e.getMessage());
                        result.addProperty("success", Boolean.valueOf(false));
                    }
                    request.getResponse().getOutputStream().println(result.toString());
                    break;
                }
                case DELETE_RECORD: {
                    if (!(tupleTable instanceof EditableTupleTable)) {
                        throw new UnsupportedOperationException("TupleTable is not editable");
                    }
                    JsonObject result = new JsonObject();
                    try {
                        ((EditableTupleTable)tupleTable).remove(request);
                        result.addProperty("message", "Record deleted");
                        result.addProperty("success", Boolean.valueOf(true));
                    }
                    catch (TableException e) {
                        result.addProperty("message", e.getMessage());
                        result.addProperty("success", Boolean.valueOf(false));
                    }
                    request.getResponse().getOutputStream().println(result.toString());
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new HandleRequestDelegationException(e);
        }
        catch (TableException e) {
            throw new HandleRequestDelegationException(e);
        }
    }

    private void renderData(MolgenisRequest request, JQGridPostData postData, int totalPages, TupleTable tupleTable) throws TableException {
        String strViewType = request.getString("viewType");
        if (StringUtils.isEmpty((CharSequence)strViewType)) {
            strViewType = "JQ_GRID";
        }
        try {
            ViewFactoryImpl viewFactory = new ViewFactoryImpl();
            Renderers.Renderer view = viewFactory.createView(strViewType);
            view.export(request, request.getString("caption"), tupleTable, totalPages, postData.getPage());
        }
        catch (Exception e) {
            throw new TableException(e);
        }
    }

    private static List<QueryRule> createQueryRulesFromJQGridRequest(JQGridFilter filters) {
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        if (filters != null) {
            String groupOp = filters.getGroupOp();
            int ruleIdx = 0;
            for (JQGridRule rule : filters.getRules()) {
                boolean notLast;
                QueryRule queryRule = JQGridView.convertOperator(rule);
                rules.add(queryRule);
                boolean bl = notLast = filters.getRules().size() - 1 != ruleIdx++;
                if (!groupOp.equals("OR") || !notLast) continue;
                rules.add(new QueryRule(QueryRule.Operator.OR));
            }
        }
        return rules;
    }

    private static QueryRule convertOperator(JQGridRule jqGridRule) {
        QueryRule rule = new QueryRule(jqGridRule.getField(), QueryRule.Operator.EQUALS, jqGridRule.getData());
        switch (jqGridRule.getOp()) {
            case eq: {
                rule.setOperator(QueryRule.Operator.EQUALS);
                return rule;
            }
            case ne: {
                rule.setOperator(QueryRule.Operator.EQUALS);
                return JQGridView.toNotRule(rule);
            }
            case lt: {
                rule.setOperator(QueryRule.Operator.LESS);
                return rule;
            }
            case le: {
                rule.setOperator(QueryRule.Operator.LESS_EQUAL);
                return rule;
            }
            case gt: {
                rule.setOperator(QueryRule.Operator.GREATER);
                return rule;
            }
            case ge: {
                rule.setOperator(QueryRule.Operator.GREATER_EQUAL);
                return rule;
            }
            case bw: {
                rule.setValue(jqGridRule.getData() + "%");
                rule.setOperator(QueryRule.Operator.LIKE);
                return rule;
            }
            case bn: {
                rule.setValue(jqGridRule.getData() + "%");
                rule.setOperator(QueryRule.Operator.LIKE);
                rule = JQGridView.toNotRule(rule);
                return rule;
            }
            case in: {
                rule.setOperator(QueryRule.Operator.IN);
                return rule;
            }
            case ni: {
                rule.setOperator(QueryRule.Operator.IN);
                rule = JQGridView.toNotRule(rule);
                return rule;
            }
            case ew: {
                rule.setValue("%" + jqGridRule.getData());
                rule.setOperator(QueryRule.Operator.LIKE);
                return rule;
            }
            case en: {
                rule.setValue("%" + jqGridRule.getData());
                rule.setOperator(QueryRule.Operator.LIKE);
                return JQGridView.toNotRule(rule);
            }
            case cn: {
                rule.setValue("%" + jqGridRule.getData() + "%");
                rule.setOperator(QueryRule.Operator.LIKE);
                return rule;
            }
            case nc: {
                rule.setValue("%" + jqGridRule.getData() + "%");
                rule.setOperator(QueryRule.Operator.LIKE);
                return JQGridView.toNotRule(rule);
            }
        }
        throw new IllegalArgumentException(String.format("Unkown Operator: %s", new Object[]{jqGridRule.getOp()}));
    }

    private static QueryRule toNotRule(QueryRule rule) {
        return new QueryRule(QueryRule.Operator.NOT, rule);
    }

    @Override
    public String toHtml() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("tableId", super.getId());
        args.put("url", this.tupleTableBuilder.getUrl());
        return new FreemarkerView(JQGridView.class, args).render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTupleTableConfig(Database db, MolgenisRequest request, TupleTable tupleTable) throws TableException, IOException {
        JQGridConfiguration config = new JQGridConfiguration(db, this.getId(), "Name", this.tupleTableBuilder.getUrl(), this.getLabel(), tupleTable);
        if (this.searchOptions != null) {
            config.setSearchOptions(this.searchOptions);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)request.getResponse().getOutputStream(), Charset.forName("UTF-8"));
        try {
            new Gson().toJson((Object)config, (Appendable)writer);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static JQGridResult buildJQGridResults(int rowCount, int totalPages, int page, TupleTable table) throws TableException {
        JQGridResult result = new JQGridResult(page, totalPages, rowCount);
        for (Tuple row : table) {
            LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
            for (String fieldName : row.getColNames()) {
                String rowValue = !row.isNull(fieldName) ? row.getString(fieldName) : "null";
                rowMap.put(fieldName, rowValue);
            }
            result.addRow(rowMap);
        }
        return result;
    }

    public static interface TupleTableBuilder {
        public TupleTable create(Tuple var1) throws TableException;

        public String getUrl();
    }

    private static enum Operation {
        LOAD_CONFIG,
        RENDER_DATA,
        EDIT_RECORD,
        ADD_RECORD,
        DELETE_RECORD,
        NEXT_COLUMNS,
        PREVIOUS_COLUMNS,
        SET_COLUMN_PAGE,
        HIDE_COLUMN,
        SHOW_COLUMN;

    }
}

