/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.tupletable.view.JQGridJSObjects;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.tupletable.DatabaseTupleTable;
import org.molgenis.framework.tupletable.EditableTupleTable;
import org.molgenis.framework.tupletable.FilterableTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridColModel;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridPostData;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridSearchOptions;
import org.molgenis.framework.tupletable.view.JQGridJSObjects.JQGridSettings;
import org.molgenis.model.elements.Field;

@SuppressWarnings(value={"URF_UNREAD_FIELD", "SS_SHOULD_BE_STATIC"}, justification="Gson reads private fields")
public class JQGridConfiguration {
    private final String id;
    private final String url;
    private final String editurl;
    private final String datatype = "json";
    private final String pager;
    private final List<JQGridColModel> colModel = new ArrayList<JQGridColModel>();
    private final int rowNum = 20;
    private final Integer[] rowList = new Integer[]{20, 30, 40};
    private final boolean viewrecords = true;
    private String caption = "jqGrid View";
    private final boolean autowidth = true;
    private final String sortname = "";
    private final String sortorder = "desc";
    private final String height = "466px";
    private int totalColumnCount;
    private int colOffset;
    private int colLimit;
    private final List<JQGridColModel> hiddenColumns = new ArrayList<JQGridColModel>();
    private boolean firstColumnFixed;
    private final JQGridPostData postData = new JQGridPostData();
    private final HashMap<String, Object> jsonReader = new HashMap();
    private final JQGridSettings settings = new JQGridSettings();
    private JQGridSearchOptions searchOptions = new JQGridSearchOptions();
    private final Object[] toolbar = Arrays.asList(true, "top").toArray();

    public JQGridConfiguration(Database db, String id, String idField, String url, String caption, TupleTable tupleTable) throws TableException {
        if (tupleTable instanceof DatabaseTupleTable) {
            ((DatabaseTupleTable)((Object)tupleTable)).setDb(db);
        }
        this.id = id;
        this.pager = "#" + id + "_pager";
        this.url = url;
        this.editurl = url;
        this.caption = caption;
        this.totalColumnCount = tupleTable.getColCount();
        this.colOffset = tupleTable.getColOffset();
        this.colLimit = tupleTable.getColLimit();
        this.firstColumnFixed = tupleTable.isFirstColumnFixed();
        this.jsonReader.put("repeatitems", false);
        this.jsonReader.put("id", idField);
        if (tupleTable instanceof FilterableTupleTable) {
            this.settings.setSearch(true);
        }
        if (tupleTable instanceof EditableTupleTable) {
            this.settings.setAdd(true);
            this.settings.setEdit(true);
            this.settings.setDel(true);
        }
        for (Field f : tupleTable.getColumns()) {
            this.colModel.add(new JQGridColModel(f));
        }
        for (Field f : tupleTable.getHiddenColumns()) {
            this.hiddenColumns.add(new JQGridColModel(f));
        }
    }

    public JQGridConfiguration(String id, String url, String caption) {
        this.id = id;
        this.pager = "#" + id + "Pager";
        this.url = url;
        this.editurl = url;
        this.caption = caption;
    }

    public JQGridSearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public void setSearchOptions(JQGridSearchOptions searchOptions) {
        this.searchOptions = searchOptions;
    }
}

