/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;
import org.molgenis.util.Entity;

public class MolgenisJqGridService
implements MolgenisService {
    Logger logger = Logger.getLogger(MolgenisJqGridService.class);

    public MolgenisJqGridService(MolgenisContext mc) {
    }

    @Override
    public void handleRequest(MolgenisRequest req, MolgenisResponse res) throws ParseException, DatabaseException, IOException {
        HttpServletResponse response = res.getResponse();
        try {
            boolean sortAsc;
            Integer limit;
            Integer page = req.getInt("page");
            if (page == null || page < 1) {
                page = 1;
            }
            if ((limit = req.getInt("rows")) == null || limit < 0) {
                limit = 10;
            }
            String sortIndex = req.getString("sidx");
            boolean bl = sortAsc = "asc".equals(req.getString("sord"));
            if (req.isNull("entity")) {
                throw new Exception("required parameter 'entity' is missing");
            }
            Class<? extends Entity> entityClass = req.getDatabase().getClassForName(req.getString("entity"));
            Database db = req.getDatabase();
            Query<? extends Entity> q = db.query(entityClass);
            if (!req.isNull("filter") && !"".equals(req.getString("filter"))) {
                q.search(req.getString("filter").trim());
            }
            int recordCount = q.count();
            int total_pages = 1;
            if (recordCount > 0 && limit > 0) {
                total_pages = (int)((double)recordCount / (double)limit.intValue()) + 1;
            }
            if (page > total_pages) {
                page = total_pages;
            }
            q.limit(limit);
            q.offset(page * limit - limit);
            if (sortAsc) {
                q.sortASC(sortIndex);
            } else {
                q.sortDESC(sortIndex);
            }
            List<? extends Entity> result = q.find();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("page", (Number)page);
            jsonObject.addProperty("total", (Number)total_pages);
            jsonObject.addProperty("records", (Number)recordCount);
            JsonArray jsonRows = new JsonArray();
            for (Entity entity : result) {
                JsonObject jsonValues = new JsonObject();
                for (String field : entity.getFields()) {
                    if (entity.get(field) != null) {
                        jsonValues.addProperty(field, entity.get(field).toString());
                        continue;
                    }
                    jsonValues.addProperty(field, "");
                }
                jsonRows.add((JsonElement)jsonValues);
            }
            jsonObject.add("rows", (JsonElement)jsonRows);
            String json = jsonObject.toString();
            this.logger.debug((Object)json);
            response.setHeader("Cache-Control", "max-age=0");
            response.setContentType("application/json");
            PrintWriter printWriter = response.getWriter();
            System.out.println("json\n" + json);
            printWriter.print(json);
            printWriter.close();
        }
        catch (Exception e) {
            PrintWriter out = response.getWriter();
            response.getWriter().print("{exception: '" + e.getMessage() + "'}");
            out.close();
            e.printStackTrace();
            throw new DatabaseException(e);
        }
    }
}

