/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server.services;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletOutputStream;
import org.molgenis.framework.server.MolgenisContext;
import org.molgenis.framework.server.MolgenisRequest;
import org.molgenis.framework.server.MolgenisResponse;
import org.molgenis.framework.server.MolgenisService;

public class MolgenisBashService
implements MolgenisService {
    public MolgenisBashService(MolgenisContext mc) {
    }

    @Override
    public void handleRequest(MolgenisRequest request, MolgenisResponse response) throws IOException {
        ServletOutputStream outs = response.getResponse().getOutputStream();
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream((OutputStream)outs), false, "UTF8");
        String s = "";
        s = s + "server=" + (request.getAppLocation().endsWith("/") ? request.getAppLocation() : request.getAppLocation() + "/") + "\n";
        s = s + "\n";
        s = s + "messagebox=$( printf \"%90s\" );\n";
        s = s + "\n";
        s = s + "function printError {\n";
        s = s + "  echo ${messagebox// /#}\n";
        s = s + "  echo \"ERROR:\" $1\n";
        s = s + "  echo ${messagebox// /#}\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "function printWarning {\n";
        s = s + "  echo ${messagebox// /#}\n";
        s = s + "  echo \"WARNING:\" $1\n";
        s = s + "  echo ${messagebox// /#}\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "function MOLGENIS.login {\n";
        s = s + "  if [ -z \"$1\" ]\n";
        s = s + "    then\n";
        s = s + "    printError \"Missing parameter: username\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "  if [ -z \"$2\" ]\n";
        s = s + "    then\n";
        s = s + "    printError \"Missing parameter: password\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "  curl --cookie-jar cookies.txt --user-agent Mozilla/4.0 --data \"__target=UserLogin&__action=Login&username=$1&password=$2\" $server\"molgenis.do\" -v -k -D header\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "function MOLGENIS.logout {\n";
        s = s + "  curl --cookie-jar cookies.txt --user-agent Mozilla/4.0 --data \"__target=UserLogin&__action=Logout\" $server\"molgenis.do\" -v -k -D header\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "function getFile {\n";
        s = s + "  if [ -z \"$1\" ]\n";
        s = s + "    then\n";
        s = s + "    printError \"Missing parameter: database file name\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "  if [ -z \"$2\" ]\n";
        s = s + "    then\n";
        s = s + "    printError \"Missing parameter: local 'save as' file name\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "  curl -b cookies.txt --user-agent Mozilla/4.0 $server\"downloadfile?name=$1\" -v > $2\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "function putFile {\n";
        s = s + "  if [ -z \"$1\" ]\n";
        s = s + "    then\n";
        s = s + "    printError \"Missing parameter: local file name\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "  if [ -z \"$2\" ]\n";
        s = s + "    then\n";
        s = s + "   \tprintWarning \"Missing parameter: database 'save as' file name\"\n";
        s = s + "    return\n";
        s = s + "  fi\n";
        s = s + "   if [ -z \"$3\" ]\n";
        s = s + "    then\n";
        s = s + "    printWarning \"No third parameter: you may need to provide more information to store this file, such as investigation or a type. E.g. add \\\"-F \\\"investigation_id=1\\\"\\\".\"\n";
        s = s + "  fi\n";
        s = s + "  curl -v -b cookies.txt --user-agent Mozilla/4.0 -F \"file=@$1\" -F \"name=$2\" $3 $server\"uploadfile\"\n";
        s = s + "}\n";
        s = s + "\n";
        s = s + "\n";
        s = s + "## EXAMPLE SCRIPT ##\n";
        s = s + "\n";
        s = s + "## essential: connect to the Bash API\n";
        s = s + "#curl --user-agent Mozilla/4.0 http://localhost:8080/xqtl_lifelines/api/bash -v -k -D header > bashapi.txt\n";
        s = s + "#source bashapi.txt\n";
        s = s + "\n";
        s = s + "## login as 'admin', password 'admin'\n";
        s = s + "#MOLGENIS.login admin admin\n";
        s = s + "\n";
        s = s + "## select some phenotype to analyse\n";
        s = s + "#pheno=Health19\n";
        s = s + "\n";
        s = s + "## download some genotypes\n";
        s = s + "#getFile llrp_fake_geno llrp_geno.ped\n";
        s = s + "#getFile llrp_fake_snp llrp_geno.map\n";
        s = s + "\n";
        s = s + "## download some phenotypes (custom, but uses server location)\n";
        s = s + "#curl -b cookies.txt --user-agent Mozilla/4.0 -v -F 'name=$pheno' -F 'plinkformat=true' $server'downloadpheno' > llrp_pheno_$pheno.txt\n";
        s = s + "\n";
        s = s + "## run some analysis\n";
        s = s + "#../geno/plink-1.07-mac-intel/plink --noweb --file llrp_geno --pheno llrp_pheno_$pheno.txt --assoc --maf 0.05 --hwe -0.001 --1 --allow-no-sex --out results_for_$pheno\n";
        s = s + "\n";
        s = s + "## upload some results\n";
        s = s + "#putFile results_for_$pheno.assoc results_for_$pheno.assoc '-F 'investigation_name=LifeLines' -F 'investigation_id=1' -F 'type=InvestigationFile' -F 'description=Plink_assoc_results''\n";
        s = s + "\n";
        s = s + "## logout\n";
        s = s + "#MOLGENIS.logout\n";
        s = s + "\n";
        this.writeResponse(response, s, out);
    }

    private void writeResponse(MolgenisResponse response, String responseLine, PrintStream out) throws IOException {
        response.getResponse().setStatus(200);
        response.getResponse().setContentLength(responseLine.length());
        response.getResponse().setCharacterEncoding("UTF8");
        response.getResponse().setContentType("text/plain");
        out.print(responseLine);
        out.flush();
        out.close();
        response.getResponse().flushBuffer();
    }
}

