/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.server.QueryRuleUtil;
import org.molgenis.framework.ui.html.SelectInput;
import org.molgenis.framework.ui.html.StringInput;
import org.molgenis.io.TupleWriter;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.util.Entity;
import org.molgenis.util.tuple.HttpServletRequestTuple;

public class RestInterface {
    private static final Logger logger = Logger.getLogger(RestInterface.class);

    public static void handleRequest(HttpServletRequest request, HttpServletResponse response, Database db) {
        response.setBufferSize(10000);
        response.setContentType("text/html; charset=UTF-8");
        logger.info((Object)("starting REST request " + request.getPathInfo()));
        long start_time = System.currentTimeMillis();
        if (request.getPathInfo().startsWith("/find") || request.getPathInfo().startsWith("/count")) {
            RestInterface.handleRetrievalRequest(request, response, db);
        }
        logger.info((Object)("servlet took: " + (System.currentTimeMillis() - start_time)));
        logger.info((Object)"------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleRetrievalRequest(HttpServletRequest request, HttpServletResponse response, Database db) {
        try {
            PrintWriter out;
            block15: {
                out = response.getWriter();
                try {
                    if (request.getPathInfo().equals("/find") || request.getPathInfo().equals("/count")) {
                        RestInterface.showSelectEntityDialog(out, db);
                        return;
                    }
                    String entityName = request.getPathInfo().substring("/find/".length());
                    if (request.getPathInfo().startsWith("/count/")) {
                        entityName = request.getPathInfo().substring("/count/".length());
                    }
                    Entity entity = (Entity)Class.forName(entityName).newInstance();
                    if (request.getQueryString() != null && request.getQueryString().equals("__showQueryDialogue=true")) {
                        RestInterface.showSelectFilterDialogForEntity(entity, out, db);
                        return;
                    }
                    List<QueryRule> rulesList = RestInterface.createQueryRulesFromRequest(request);
                    if (request.getPathInfo().startsWith("/count/")) {
                        if (rulesList != null) {
                            db.count(RestInterface.getClassForName(entityName), rulesList.toArray(new QueryRule[rulesList.size()]));
                        } else {
                            out.println(db.count(RestInterface.getClassForName(entityName), new QueryRule[0]));
                        }
                        break block15;
                    }
                    CsvWriter csvWriter = new CsvWriter(out);
                    try {
                        if (rulesList != null) {
                            db.find(RestInterface.getClassForName(entityName), (TupleWriter)csvWriter, rulesList.toArray(new QueryRule[rulesList.size()]));
                        } else {
                            db.find(RestInterface.getClassForName(entityName), (TupleWriter)csvWriter, new QueryRule[0]);
                        }
                    }
                    finally {
                        csvWriter.close();
                    }
                }
                catch (Exception e) {
                    out.println(e + "<br>");
                    e.printStackTrace();
                    throw e;
                }
            }
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static Class<? extends Entity> getClassForName(String entityName) throws ClassNotFoundException {
        return Class.forName(entityName);
    }

    private static List<QueryRule> createQueryRulesFromRequest(HttpServletRequest request) throws Exception {
        List<QueryRule> rulesList;
        if (request.getQueryString() != null) {
            logger.debug((Object)("handle find query via http-get: " + request.getQueryString()));
            rulesList = QueryRuleUtil.fromRESTstring(URLDecoder.decode(request.getQueryString(), "UTF-8"));
        } else {
            HttpServletRequestTuple requestTuple = new HttpServletRequestTuple(request);
            StringBuilder queryStringBuilder = new StringBuilder();
            for (String name : requestTuple.getColNames()) {
                queryStringBuilder.append(URLDecoder.decode(name, "UTF-8")).append('=');
                queryStringBuilder.append(URLDecoder.decode(requestTuple.getString(name), "UTF-8"));
            }
            String queryString = queryStringBuilder.toString();
            logger.debug((Object)("handle find query via http-post with parameters: " + queryString));
            rulesList = QueryRuleUtil.fromRESTstring(queryString);
        }
        return rulesList;
    }

    private static void showSelectFilterDialogForEntity(Entity entity, PrintWriter out, Database db) {
        logger.debug((Object)"show 'set filters' dialogue");
        out.println("<html><body>");
        out.println("<head><script src=\"../../../res/scripts/rest.js\" language=\"javascript\"></script></head>");
        out.println("<h1>REST url wizard:</h1>");
        out.println("Step 2: choose filters<br>");
        out.println("<form>");
        out.println("You choose to use the REST interface for retrieval of '" + entity.getClass().getName() + "' data. (<a href=\"../find\">back</a>)<br><br> Here you can add filters:<br>");
        SelectInput fieldInput = new SelectInput("field", (Object)null);
        fieldInput.setOptions(entity.getFields().toArray(new String[entity.getFields().size()]));
        SelectInput operatorInput = new SelectInput("operator", (Object)null);
        ArrayList<String> operators = new ArrayList<String>();
        operators.add(QueryRule.Operator.EQUALS.toString());
        operators.add(QueryRule.Operator.GREATER_EQUAL.toString());
        operators.add(QueryRule.Operator.NOT.toString());
        operators.add(QueryRule.Operator.LESS.toString());
        operators.add(QueryRule.Operator.LESS_EQUAL.toString());
        operators.add(QueryRule.Operator.LIKE.toString());
        operatorInput.setOptions(operators.toArray(new String[operators.size()]));
        StringInput valueInput = new StringInput("value", null);
        out.println(fieldInput.getHtml() + operatorInput.getHtml() + valueInput.getHtml());
        out.println("<br>");
        out.println(fieldInput.getHtml() + operatorInput.getHtml() + valueInput.getHtml());
        out.println("<br>");
        out.println("<input type=\"submit\" value=\"generate url\" onclick=\"generateRestUrl(this.form.elements); return false\">");
        out.println("TIP: notice how the url is bookmarkeable for future downloads!");
        out.println("TIP: click 'save as...' and name it as '.txt' file.");
        out.println("</form></body></html>");
    }

    private static void showSelectEntityDialog(PrintWriter out, Database db) {
        logger.debug((Object)"show 'choose entity' dialogue");
        out.println("<html><body>");
        out.println("<h1>REST url wizard:</h1>");
        out.println("Step 1: choose entity<br>");
        for (String className : db.getEntityNames()) {
            out.println(className + ": <a href=\"find/" + className + "?__showQueryDialogue=true\">find</a> or <a href=\"count/" + className + "?__showQueryDialogue=true\">count</a><br>");
        }
        out.println("</body></html>");
        logger.debug((Object)"done");
    }
}

