/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.server;

import java.io.IOException;
import java.io.PrintWriter;
import org.molgenis.framework.server.AuthStatus;
import org.molgenis.framework.server.FrontControllerAuthenticator;
import org.molgenis.framework.server.MolgenisRequest;

public class MolgenisServiceAuthenticationHelper {
    public static final String LOGIN_USER_NAME = "usr";
    public static final String LOGIN_PASSWORD = "pwd";
    static String LOGOUT_REQUEST = "logout";

    public static AuthStatus handleAuthentication(MolgenisRequest req, PrintWriter out) throws IOException {
        if (req.getString(LOGIN_USER_NAME) != null && req.getString(LOGIN_PASSWORD) != null) {
            String password;
            String username = req.getString(LOGIN_USER_NAME);
            FrontControllerAuthenticator.LoginStatus login = FrontControllerAuthenticator.login(req, username, password = req.getString(LOGIN_PASSWORD));
            if (login == FrontControllerAuthenticator.LoginStatus.ALREADY_LOGGED_IN) {
                String printMe = "<table><tr><td colspan=\"2\">You are already logged in.</td></tr>";
                printMe = printMe + "<tr><td>" + MolgenisServiceAuthenticationHelper.displayLogoutForm() + "</td>";
                printMe = printMe + "<td><form><input type=\"submit\" value=\"Continue\"></form></td></tr></table>";
                return new AuthStatus(false, printMe);
            }
            if (login == FrontControllerAuthenticator.LoginStatus.SUCCESSFULLY_LOGGED_IN) {
                String printMe = "<table><tr><td>Welcome, " + username + "!</td></tr>";
                printMe = printMe + "<tr><td align=\"right\"><form><input type=\"submit\" value=\"Continue\"></form></td></tr></table>";
                return new AuthStatus(false, printMe);
            }
            if (login == FrontControllerAuthenticator.LoginStatus.AUTHENTICATION_FAILURE) {
                String printMe = "<table><tr><td>User or password unknown.</td></tr>";
                printMe = printMe + "<tr><td align=\"right\"><form><input type=\"submit\" value=\"Retry\"></form></td></tr></table>";
                return new AuthStatus(false, printMe);
            }
            if (login == FrontControllerAuthenticator.LoginStatus.EXCEPTION_THROWN) {
                String printMe = "An error occurred. Contact your administrator.";
                return new AuthStatus(false, printMe);
            }
            throw new IOException("Unknown login status: " + (Object)((Object)login));
        }
        if (req.getString(LOGOUT_REQUEST) != null && req.getString(LOGOUT_REQUEST).equals(LOGOUT_REQUEST)) {
            FrontControllerAuthenticator.LogoutStatus logout = FrontControllerAuthenticator.logout(req);
            if (logout == FrontControllerAuthenticator.LogoutStatus.ALREADY_LOGGED_OUT) {
                String printMe = "<table><tr><td>You already logged out.</td></tr>";
                printMe = printMe + "<tr><td align=\"right\"><form><input type=\"submit\" value=\"Continue\"></form></td></tr></table>";
                return new AuthStatus(false, printMe);
            }
            if (logout == FrontControllerAuthenticator.LogoutStatus.SUCCESSFULLY_LOGGED_OUT) {
                String printMe = "<table><tr><td>You are successfully logged out.</td></tr>";
                printMe = printMe + "<tr><td align=\"right\"><form><input type=\"submit\" value=\"Continue\"></form></td></tr></table>";
                return new AuthStatus(false, printMe);
            }
            if (logout == FrontControllerAuthenticator.LogoutStatus.EXCEPTION_THROWN) {
                String printMe = "An error occurred. Contact your administrator.";
                return new AuthStatus(false, printMe);
            }
            throw new IOException("Unknown logout status: " + (Object)((Object)logout));
        }
        if (!req.getDatabase().getLogin().isAuthenticated()) {
            String printMe = "<form name=\"input\" action=\"\" method=\"post\">";
            printMe = printMe + "<table><tr><td colspan=\"2\">Please log in:</td></tr>";
            printMe = printMe + "<tr><td>Username:</td><td><input type=\"text\" name=\"usr\"></td></tr>";
            printMe = printMe + "<tr><td>Password:</td><td><input type=\"password\" name=\"pwd\"></td></tr>";
            printMe = printMe + "<tr><td colspan=\"2\" align=\"right\"><input type=\"submit\" value=\"Login\"></td></tr></table>";
            printMe = printMe + "</form>";
            return new AuthStatus(true, printMe);
        }
        return new AuthStatus(true, "");
    }

    public static String displayLogoutForm() {
        String logoutForm = "<form name=\"input\" action=\"\" method=\"post\">";
        logoutForm = logoutForm + "<input type=\"hidden\" name=\"" + LOGOUT_REQUEST + "\" value=\"" + LOGOUT_REQUEST + "\">";
        logoutForm = logoutForm + "<input type=\"submit\" value=\"Logout\">";
        logoutForm = logoutForm + "</form>";
        return logoutForm;
    }
}

