/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.db;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import javax.persistence.EntityManager;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Mapper;
import org.molgenis.framework.db.Query;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.security.Login;
import org.molgenis.io.TupleReader;
import org.molgenis.io.TupleWriter;
import org.molgenis.model.elements.Model;
import org.molgenis.util.Entity;

public interface Database
extends Closeable {
    public Model getMetaData() throws DatabaseException;

    public void beginTx() throws DatabaseException;

    public boolean inTx();

    public void commitTx() throws DatabaseException;

    public void rollbackTx() throws DatabaseException;

    public <E extends Entity> int count(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    public <E extends Entity> List<E> find(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    public <E extends Entity> void find(Class<E> var1, TupleWriter var2, QueryRule ... var3) throws DatabaseException;

    public <E extends Entity> void find(Class<E> var1, TupleWriter var2, List<String> var3, QueryRule ... var4) throws DatabaseException;

    public <E extends Entity> E findById(Class<E> var1, Object var2) throws DatabaseException;

    public <E extends Entity> Query<E> query(Class<E> var1);

    public <E extends Entity> Query<E> queryByExample(E var1);

    public <E extends Entity> int add(E var1) throws DatabaseException;

    public <E extends Entity> int add(List<E> var1) throws DatabaseException;

    public <E extends Entity> int add(Class<E> var1, TupleReader var2, TupleWriter var3) throws DatabaseException;

    public <E extends Entity> int add(Class<E> var1, TupleReader var2) throws DatabaseException;

    public <E extends Entity> int update(E var1) throws DatabaseException;

    public <E extends Entity> int update(List<E> var1) throws DatabaseException;

    public <E extends Entity> int update(Class<E> var1, TupleReader var2) throws DatabaseException;

    public <E extends Entity> int remove(E var1) throws DatabaseException;

    public <E extends Entity> int remove(List<E> var1) throws DatabaseException;

    public <E extends Entity> int remove(Class<E> var1, TupleReader var2) throws DatabaseException;

    public <E extends Entity> int update(List<E> var1, DatabaseAction var2, String ... var3) throws DatabaseException;

    public File getFilesource() throws Exception;

    public List<Class<? extends Entity>> getEntityClasses();

    public List<String> getEntityNames();

    public <E extends Entity> List<E> toList(Class<E> var1, TupleReader var2, int var3) throws DatabaseException;

    public Login getLogin();

    public void setLogin(Login var1);

    public Class<? extends Entity> getClassForName(String var1);

    public EntityManager getEntityManager();

    public void flush();

    public <E extends Entity> String createFindSql(Class<E> var1, QueryRule ... var2) throws DatabaseException;

    public <E extends Entity> Mapper<E> getMapper(String var1) throws DatabaseException;

    public <E extends Entity> Mapper<E> getMapperFor(Class<E> var1) throws DatabaseException;

    public <E extends Entity> List<E> search(Class<E> var1, String var2) throws DatabaseException;

    public <E extends Entity> List<? extends Entity> load(Class<E> var1, List<E> var2) throws DatabaseException;

    public <E extends Entity> Class<E> getEntityClass(E var1);

    public <E extends Entity> Class<E> getEntityClass(List<E> var1);

    public static enum DatabaseAction {
        ADD,
        ADD_IGNORE_EXISTING,
        ADD_UPDATE_EXISTING,
        UPDATE,
        UPDATE_IGNORE_MISSING,
        REMOVE,
        REMOVE_IGNORE_MISSING;

    }
}

