/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.molgenis.framework.ui.html.render.LinkoutRenderDecorator;
import org.molgenis.util.cmdline.CmdLineException;
import org.molgenis.util.cmdline.CmdLineParser;
import org.molgenis.util.cmdline.Option;

public class MolgenisOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MolgenisOptions.class);
    public static final String CLASS_PER_TABLE = "class_per_table";
    public static final String SUBCLASS_PER_TABLE = "subclass_per_table";
    public static final String HIERARCHY_PER_TABLE = "hierarchy_per_table";
    private String molgenis_properties = "";
    private String molgenis_passwd = "";
    @Option(name="model_database", param=Option.Param.COLLECTION, type=Option.Type.REQUIRED_ARGUMENT, usage="File with data structure specification (in MOLGENIS DSL). Default: new ArrayList<String>()")
    public ArrayList<String> model_database = new ArrayList();
    @Option(name="import_model_database", param=Option.Param.COLLECTION, type=Option.Type.REQUIRED_ARGUMENT, usage="File with data structure specification (in MOLGENIS DSL). Default: new ArrayList<String>()")
    public ArrayList<String> import_model_database = new ArrayList();
    @Option(name="model_userinterface", param=Option.Param.FILEPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="File with user interface specification (in MOLGENIS DSL). Can be same file as model_database. Default: ''")
    public String model_userinterface = "";
    @Option(name="example_data_dir", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Directory where example data lives. Default: 'data'")
    public String example_data_dir = "data";
    @Option(name="output_dir", param=Option.Param.DIRPATH, type=Option.Type.OPTIONAL_ARGUMENT, usage="Directory where all generated code is stored")
    public String output_dir = "generated";
    @Option(name="output_python", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated Python classes. Default: 'generated/python'")
    public String output_python = this.output_dir + "/python";
    @Option(name="output_src", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated Java classes. Default: 'generated/java'")
    public String output_src = this.output_dir + "/java";
    @Option(name="output_hand", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Source directory for handwritten java. Default: 'handwritten/java'")
    public String output_hand = "handwritten/java";
    @Option(name="output_sql", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated sql files. Default: 'generated/sql'")
    public String output_sql = this.output_dir + "/sql";
    @Option(name="output_doc", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated documentation. Default: 'WebContent/generated-doc'")
    public String output_doc = "WebContent/generated-doc";
    @Option(name="output_web", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for any generated web resources. Default: 'WebContent'")
    public String output_web = "WebContent";
    @Option(name="db_driver", param=Option.Param.STRING, type=Option.Type.REQUIRED_ARGUMENT, usage="Driver of database. Any JDBC compatible driver should work. Default: 'com.mysql.jdbc.Driver'")
    public String db_driver = "com.mysql.jdbc.Driver";
    @Option(name="db_user", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Username for the database. Default: ''")
    public String db_user = "molgenis";
    @Option(name="decorator_overriders", param=Option.Param.CLASS, type=Option.Type.OPTIONAL_ARGUMENT, usage="Points to an application package with overriding classes for entity decorators, mapped by name. Default: ''")
    public String decorator_overriders = "";
    @Option(name="db_password", param=Option.Param.PASSWORD, type=Option.Type.OPTIONAL_ARGUMENT, usage="Password for database. Default: ''")
    public String db_password = "molgenis";
    @Option(name="db_uri", param=Option.Param.STRING, type=Option.Type.REQUIRED_ARGUMENT, usage="Uri of the database. Default: 'jdbc:mysql://localhost/molgenis?innodb_autoinc_lock_mode=2'")
    public String db_uri = "jdbc:mysql://localhost/molgenis?innodb_autoinc_lock_mode=2";
    @Option(name="db_filepath", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Path where the database should store file attachements. Default: 'data'")
    public String db_filepath = "data";
    @Option(name="db_test_user", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Username for the database. Default: ''")
    public String db_test_user = "molgenis";
    @Option(name="db_test_password", param=Option.Param.PASSWORD, type=Option.Type.OPTIONAL_ARGUMENT, usage="Password for database. Default: ''")
    public String db_test_password = "molgenis";
    @Option(name="db_test_uri", param=Option.Param.STRING, type=Option.Type.REQUIRED_ARGUMENT, usage="Uri of the database. Default: 'jdbc:mysql://localhost/molgenis?innodb_autoinc_lock_mode=2'")
    public String db_test_uri = "jdbc:mysql://localhost/molgenis_test?innodb_autoinc_lock_mode=2";
    @Option(name="db_jndiname", param=Option.Param.STRING, type=Option.Type.REQUIRED_ARGUMENT, usage="Used to create a JDBC database resource for the application. Default: 'molgenis_jndi'")
    public String db_jndiname = "molgenis_jndi";
    @Option(name="object_relational_mapping", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing OR strategy. Either 'class_per_table', 'subclass_per_table', 'hierarchy_per_table'. Default: SUBCLASS_PER_TABLE")
    public String object_relational_mapping = "subclass_per_table";
    @Option(name="mapper_implementation", param=Option.Param.ENUM, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing wether multiquery is used instead of prepared statements. Default: MULTIQUERY")
    public MapperImplementation mapper_implementation = MapperImplementation.JPA;
    @Option(name="generate_persistence", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing the JPA persistence unit name from the persistence.xml that is used by molgenis. Default: molgenis")
    public String jpa_persistenceUnitName = "molgenis";
    @Option(name="generate_persistence", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing whether persistence.xml is generated by molgenis (true) or supplied by user (false). Default: true")
    public boolean generate_persistence = true;
    @Option(name="hibernate_dialect", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing the JPA dialect for persistence.xml. Default: MySQL5Dialect")
    public String hibernate_dialect = "MySQL5InnoDBDialect";
    @Option(name="jpa_use_sequence", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Choosing whether sequence are used to generate primary key (true) or auto (false: default)")
    public boolean jpa_use_sequence = false;
    @Option(name="exclude_system", param=Option.Param.BOOLEAN, type=Option.Type.REQUIRED_ARGUMENT, usage="Expert option: Whether system tables should be excluded from generation. Default: true")
    public boolean exclude_system = true;
    @Option(name="auth_loginclass", param=Option.Param.CLASS, type=Option.Type.REQUIRED_ARGUMENT, usage="Expert option. Set the class used for login. Default: org.molgenis.framework.security.SimpleLogin")
    public String auth_loginclass = "org.molgenis.framework.security.SimpleLogin";
    @Option(name="auth_use_dialog", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Indicate the use of the bootstrap modal dialog for login. Default: false")
    public boolean auth_use_dialog = false;
    @Option(name="auth_redirect", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Get name of form/plugin to redirect to after login. Default: ''")
    public String auth_redirect = "";
    @Option(name="mail_smtp_from", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Sets the email adress used to send emails from. Default: ''")
    public String mail_smtp_from = "";
    @Option(name="mail_smtp_protocol", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Sets the email protocol, either smtp, smtps or null. Default: 'smtps'")
    public String mail_smtp_protocol = "smtps";
    @Option(name="mail_smtp_hostname", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="SMTP host server. Default: 'smtp.gmail.com'")
    public String mail_smtp_hostname = "smtp.gmail.com";
    @Option(name="mail_smtp_port", param=Option.Param.INTEGER, type=Option.Type.OPTIONAL_ARGUMENT, usage="SMTP host server port. Default: 465")
    public int mail_smtp_port = 465;
    @Option(name="mail_smtp_user", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="SMTP user for authenticated emailing. Default: ''")
    public String mail_smtp_user = "";
    @Option(name="mail_smtp_au", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="SMTP auth. Default: ''")
    public String mail_smtp_au = "";
    @Option(name="generate_R", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should R-interface be generated. Default: true.")
    public boolean generate_R = true;
    @Option(name="generate_BOT", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should BOT be generated. Default: false.")
    public boolean generate_BOT = false;
    @Option(name="render_decorator", param=Option.Param.CLASS, type=Option.Type.OPTIONAL_ARGUMENT, usage="Applies an custom decoration of the HTML. Default: LinkoutRenderDecorator with linkouts for popular identifier to online databases")
    public String render_decorator = LinkoutRenderDecorator.class.getName();
    @Option(name="generate_doc", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should documentation be generated. Default: true.")
    public boolean generate_doc = true;
    @Option(name="generate_entityio", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should entity importers and exporters be generated. Default: true.")
    public boolean generate_entityio = true;
    @Option(name="generate_Python", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should Python-interface be generated. Default: false.")
    public boolean generate_Python = false;
    @Option(name="generate_tests", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should test code for generated code be generated. Default: false.")
    public boolean generate_tests = false;
    @Option(name="generate_gui", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Should the GUI service be generated. Default: true.")
    public boolean generate_gui = true;
    @Option(name="db_mode", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Which mode should the molgenisServlet use when contacting the dabase. Default: 'servlet'")
    public String db_mode = "servlet";
    @Option(name="output_cpp", param=Option.Param.DIRPATH, type=Option.Type.REQUIRED_ARGUMENT, usage="Output-directory for the generated CPP classes. Default: 'generated/cpp'")
    public String output_cpp = this.output_dir + "/cpp";
    @Option(name="generate_cpp", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Generate CPP. Default: false")
    public boolean generate_cpp = false;
    @Option(name="generate_model", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Generate any SQL related classes. Default: true")
    public boolean generate_model = true;
    @Option(name="generate_sql", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Generate any SQL related classes. Default: true")
    public boolean generate_sql = true;
    @Option(name="generate_html", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate HTML. Default: true")
    public boolean generate_html = true;
    @Option(name="generate_rdf", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate the RDF API. Default: true")
    public boolean generate_rdf = true;
    @Option(name="generate_rest", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate the REST API. Default: true")
    public boolean generate_rest = true;
    @Option(name="generate_soap", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate the SOAP API. Default: true")
    public boolean generate_soap = true;
    @Option(name="generate_plugins", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate the Molgenis plugin API. Default: true")
    public boolean generate_plugins = true;
    @Option(name="generate_mobile", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate the Molgenis mobile GUI. Default: true")
    public boolean generate_mobile = false;
    @Option(name="generate_decorators", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate decorator templates. Default: true")
    public boolean generate_decorators = true;
    @Option(name="generate_frontcontroller", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate front controller. Default: true")
    public boolean generate_frontcontroller = true;
    @Option(name="generate_options", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate use molgenis options. Default: true")
    public boolean generate_options = true;
    @Option(name="generate_metadata", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate meta data. Default: true")
    public boolean generate_metadata = true;
    @Option(name="generate_db", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="generate database. Default: true")
    public boolean generate_db = true;
    @Option(name="delete_generated_folder", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="delete generated Folder before generators are executed. Default: true")
    public boolean delete_generated_folder = true;
    @Option(name="authorizable", param=Option.Param.COLLECTION, type=Option.Type.OPTIONAL_ARGUMENT, usage="For use in molgenis_apps! Tells the generator on which entities to append an implements='Authorizable'. Default: new ArrayList<String>()")
    public ArrayList<String> authorizable = new ArrayList();
    @Option(name="services", param=Option.Param.COLLECTION, type=Option.Type.OPTIONAL_ARGUMENT, usage="Register services to the FrontController. (replaces webserver mappings and MolgenisServlet) Default: new ArrayList<String>()")
    public ArrayList<String> services = new ArrayList();
    @Option(name="disable_decorators", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="disables all decorators for generated test")
    public boolean disable_decorators = false;
    @Option(name="log4j_properties_uri", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="specify the location of the log4j.properties file that Molgenis should use, if not specified than log_level and log_target properties are used instead")
    public String log4j_properties_uri = "";
    @Option(name="log_level", param=Option.Param.LOG4JLEVEL, type=Option.Type.OPTIONAL_ARGUMENT, usage="Use this log level to initialize log4j. Default: debug")
    public Level log_level = Level.INFO;
    @Option(name="log_target", param=Option.Param.ENUM, type=Option.Type.OPTIONAL_ARGUMENT, usage="Use this log target to initialize log4j. Default: console")
    public LogTarget log_target = LogTarget.CONSOLE;
    @Option(name="hibernate_search_index_base", param=Option.Param.STRING, type=Option.Type.OPTIONAL_ARGUMENT, usage="Directory where the full text index is created. Default: /tmp/lucene")
    public String hibernate_search_index_base = "/tmp/lucene";
    @Option(name="block_webspiders", param=Option.Param.BOOLEAN, type=Option.Type.OPTIONAL_ARGUMENT, usage="Expert option: Block webcrawler user agents in FrontController")
    public boolean block_webspiders = false;
    public String path = "";

    public MolgenisOptions() {
    }

    public Map<String, Object> getOptionsAsMap() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(Option.class)) continue;
            Option opt = fields[i].getAnnotation(Option.class);
            if (opt.param() == Option.Param.PASSWORD) {
                result.put(opt.name(), "xxxxxx");
                continue;
            }
            result.put(opt.name(), fields[i].get(this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MolgenisOptions(String propertiesFile) throws FileNotFoundException, IOException, CmdLineException {
        String passwordFile;
        this.molgenis_properties = propertiesFile;
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertiesFile.trim());
            props.load(is);
        }
        catch (FileNotFoundException e) {
            try {
                InputStream is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile.trim());
                try {
                    props.load(is2);
                }
                catch (Exception e2) {
                    throw new IOException("couldn't find file " + new File(propertiesFile).getAbsolutePath());
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        CmdLineParser parser = new CmdLineParser(this);
        parser.parse(props);
        this.molgenis_properties = propertiesFile;
        this.molgenis_passwd = passwordFile = propertiesFile.replace(".properties", ".passwd");
        props = new Properties();
        is = null;
        try {
            is = new FileInputStream(passwordFile.trim());
            props.load(is);
        }
        catch (FileNotFoundException e) {
            InputStream is2 = ClassLoader.getSystemResourceAsStream(passwordFile.trim());
            try {
                props.load(is2);
            }
            catch (Exception e2) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)is2);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        parser = new CmdLineParser(this);
        parser.parse(props);
        if ("".equals(this.db_password)) {
            System.err.println("WARNING: db_password was not provided in neither " + propertiesFile + " nor " + passwordFile);
        }
        logger.debug((Object)"parsed properties file.");
    }

    public MolgenisOptions(Properties properties) {
        try {
            CmdLineParser parser = new CmdLineParser(this);
            parser.parse(properties);
            logger.debug((Object)"parsed properties file.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot find property file: " + e.getMessage());
        }
    }

    public String toString() {
        try {
            return new CmdLineParser(this).toString(this);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (CmdLineException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getHibernateDialect() {
        return this.hibernate_dialect;
    }

    public String getHibernateSearchIndexBase() {
        return this.hibernate_search_index_base;
    }

    public ArrayList<String> getModelDatabase() {
        return this.model_database;
    }

    public void setModelDatabase(ArrayList<String> model_database) {
        this.model_database = model_database;
    }

    public void setModelDatabase(String model_database) {
        ArrayList<String> v = new ArrayList<String>();
        v.add(model_database);
        this.model_database = v;
    }

    public String getModelUserinterface() {
        return this.model_userinterface;
    }

    public void setModelUserinterface(String model_userinterface) {
        this.model_userinterface = model_userinterface;
    }

    public String getOutputSrc() {
        return this.output_src;
    }

    public void setOutputSrc(String output_src) {
        this.output_src = output_src;
    }

    public String getOutputHand() {
        return this.output_hand;
    }

    public void setOutputHand(String output_hand) {
        this.output_hand = output_hand;
    }

    public String getOutputSql() {
        return this.output_sql;
    }

    public void setOutputSql(String output_sql) {
        this.output_sql = output_sql;
    }

    public String getOutputDoc() {
        return this.output_doc;
    }

    public void setOutputDoc(String output_doc) {
        this.output_doc = output_doc;
    }

    public String getOutputWeb() {
        return this.output_web;
    }

    public void setOutputWeb(String output_web) {
        this.output_web = output_web;
    }

    public String getDbDriver() {
        return this.db_driver;
    }

    public void setDbDriver(String db_driver) {
        this.db_driver = db_driver;
    }

    public String getDbUser() {
        return this.db_user;
    }

    public void setDbUser(String db_user) {
        this.db_user = db_user;
    }

    public String getDbPassword() {
        return this.db_password;
    }

    public void setDbPassword(String db_password) {
        this.db_password = db_password;
    }

    public String getDbUri() {
        return this.db_uri;
    }

    public void setDbUri(String db_uri) {
        this.db_uri = db_uri;
    }

    public String getDbFilepath() {
        return this.db_filepath;
    }

    public void setDbFilepath(String db_filepath) {
        this.db_filepath = db_filepath;
    }

    public String getDbJndiname() {
        return this.db_jndiname;
    }

    public void setDbJndiname(String db_jndiname) {
        this.db_jndiname = db_jndiname;
    }

    public String getObjectRelationalMapping() {
        return this.object_relational_mapping;
    }

    public void setObjectRelationalMapping(String object_relational_mapping) {
        this.object_relational_mapping = object_relational_mapping;
    }

    public MapperImplementation getMapperImplementation() {
        return this.mapper_implementation;
    }

    public void setMapperImplementation(MapperImplementation mapper_implementation) {
        this.mapper_implementation = mapper_implementation;
    }

    public boolean isExcludeSystem() {
        return this.exclude_system;
    }

    public void setExcludeSystem(boolean exclude_system) {
        this.exclude_system = exclude_system;
    }

    public String getAuthLoginclass() {
        return this.auth_loginclass;
    }

    public boolean getAuthUseDialog() {
        return this.auth_use_dialog;
    }

    public void setAuthLoginclass(String auth_loginclass) {
        this.auth_loginclass = auth_loginclass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMolgenis_properties() {
        return this.molgenis_properties;
    }

    public void setMolgenis_properties(String molgenisProperties) {
        this.molgenis_properties = molgenisProperties;
    }

    public boolean isDisable_decorators() {
        return this.disable_decorators;
    }

    public void setDisable_decorators(boolean disable_decorators) {
        this.disable_decorators = disable_decorators;
    }

    public String getLog4j_properties_uri() {
        return this.log4j_properties_uri;
    }

    public void setLog4j_properties_uri(String log4j_properties_uri) {
        this.log4j_properties_uri = log4j_properties_uri;
    }

    public void setGenerateTests(boolean generate_tests) {
        this.generate_tests = generate_tests;
    }

    public static enum LogTarget {
        CONSOLE,
        FILE,
        OFF;

    }

    public static enum MapperImplementation {
        JPA,
        UNKNOWN;

    }
}

