/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.compute5.model.Step;
import org.molgenis.compute5.model.Workflow;
import org.molgenis.compute5.parsers.ProtocolParser;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.util.tuple.Tuple;

public class WorkflowCsvParser {
    public static Workflow parse(String workflowFile) throws IOException {
        try {
            CsvReader reader = new CsvReader((Reader)new BufferedReader(new FileReader(workflowFile)));
            Workflow wf = new Workflow();
            for (Tuple row : reader) {
                if (row.isNull("step")) {
                    throw new IOException("required column 'step' is missing in row " + row);
                }
                if (row.isNull("protocol")) {
                    throw new IOException("required column 'protocol' is missing in row " + row);
                }
                if (row.isNull("parameterMapping")) {
                    throw new IOException("required column 'parameterMapping' is missing in row " + row);
                }
                Step s = new Step(row.getString("step"));
                s.setProtocol(ProtocolParser.parse(new File(workflowFile).getParentFile(), row.getString("protocol")));
                s.setParameters(WorkflowCsvParser.parseParameters(row.getString("parameterMapping")));
                wf.getSteps().add(s);
            }
            return wf;
        }
        catch (IOException e) {
            throw new IOException("Parsing of workflow failed: " + e.getMessage() + ".\nThe workflow csv requires columns " + "step" + "," + "protocol" + "," + "parameterMapping" + ".");
        }
    }

    private static Map<String, String> parseParameters(String string) throws IOException {
        String[] pairs;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String pair : pairs = string.split(";")) {
            String[] expr = pair.split("=");
            if (expr.length != 2) {
                throw new IOException("parameters should be expressions of form 'input=prevstep.output;input2=prevstep.output ...', found:" + expr);
            }
            result.put(expr[0], expr[1]);
        }
        return result;
    }
}

