/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.compute5.model.Input;
import org.molgenis.compute5.model.Output;
import org.molgenis.compute5.model.Parameters;
import org.molgenis.compute5.model.Protocol;

public class ProtocolParser {
    public static Protocol parse(File workflowDir, String protocolFile) throws IOException {
        try {
            String line;
            File templateFile = new File(workflowDir.getAbsolutePath() + "/" + protocolFile);
            if (!templateFile.exists() && !(templateFile = new File(protocolFile)).exists()) {
                throw new IOException("protocol '" + protocolFile + "' cannot be found");
            }
            BufferedReader reader = new BufferedReader(new FileReader(templateFile));
            Protocol p = new Protocol(protocolFile);
            String description = "";
            String template = "";
            while ((line = reader.readLine()) != null) {
                int i;
                String inputDescription;
                template = template + line + "\n";
                if (!line.startsWith("#")) continue;
                line = line.substring(1).trim();
                ArrayList<String> els = new ArrayList<String>();
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(line);
                while (m.find()) {
                    els.add(m.group(1));
                }
                if (els.size() <= 0) continue;
                if (((String)els.get(0)).equals("MOLGENIS")) {
                    for (int i2 = 1; i2 < els.size(); ++i2) {
                        if (((String)els.get(i2)).startsWith("queue")) {
                            p.setQueue(((String)els.get(i2)).substring("queue".length() + 1));
                        }
                        if (((String)els.get(i2)).startsWith("walltime")) {
                            p.setWalltime(((String)els.get(i2)).substring("walltime".length() + 1));
                        }
                        if (((String)els.get(i2)).startsWith("nodes")) {
                            p.setNodes(((String)els.get(i2)).substring("nodes".length() + 1));
                        }
                        if (((String)els.get(i2)).startsWith("ppn")) {
                            p.setPpn(((String)els.get(i2)).substring("ppn".length() + 1));
                        }
                        if (!((String)els.get(i2)).startsWith("mem")) continue;
                        p.setMemory(((String)els.get(i2)).substring("mem".length() + 1));
                    }
                    continue;
                }
                if (((String)els.get(0)).equals("description") && els.size() > 1) {
                    for (int i3 = 1; i3 < els.size(); ++i3) {
                        description = description + (String)els.get(i3) + " ";
                    }
                    description = description + "\n";
                    continue;
                }
                if (((String)els.get(0)).equals(Parameters.INPUT) || ((String)els.get(0)).equals(Parameters.STRING) || ((String)els.get(0)).equals(Parameters.LIST_INPUT)) {
                    if (els.size() < 2) {
                        throw new IOException("param requires 'name', e.g. '#string input1'");
                    }
                    Input input = new Input((String)els.get(1));
                    input.setType((String)els.get(0));
                    inputDescription = "";
                    for (i = 2; i < els.size(); ++i) {
                        inputDescription = inputDescription + " " + (String)els.get(i);
                    }
                    if (inputDescription.length() > 0) {
                        input.setDescription(inputDescription.trim());
                    }
                    p.getInputs().add(input);
                    continue;
                }
                if (!((String)els.get(0)).equals("output")) continue;
                if (els.size() < 2) {
                    throw new IOException("output requires 'name', e.g. '#output myOutputVariable'");
                }
                if (3 < els.size()) {
                    throw new IOException("Output cannot have more than 3 arguments.\nSyntax is: #output outputVarName \"description\", where description is optional.");
                }
                Output o = new Output((String)els.get(1));
                o.setValue(Parameters.NOTAVAILABLE);
                inputDescription = "";
                for (i = 2; i < els.size(); ++i) {
                    inputDescription = inputDescription + " " + (String)els.get(i);
                }
                if (inputDescription.length() > 0) {
                    o.setDescription(inputDescription.trim());
                }
                p.getOutputs().add(o);
            }
            p.setDescription(description);
            p.setTemplate(template);
            return p;
        }
        catch (Exception e) {
            throw new IOException("Parsing of protocol " + protocolFile + " failed: " + e.getMessage());
        }
    }
}

