/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.compute5.generators.TupleUtils;
import org.molgenis.compute5.model.Parameters;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class ParametersCsvParser {
    public static Parameters parse(File ... filesArray) throws IOException {
        ArrayList<File> fileLst = new ArrayList<File>();
        for (File f : filesArray) {
            fileLst.add(f);
        }
        return ParametersCsvParser.parse(fileLst);
    }

    public static Parameters parse(List<File> filesArray) throws IOException {
        HashSet<String> fileSet = new HashSet<String>();
        for (File f : filesArray) {
            fileSet.add(f.getAbsolutePath().toString());
        }
        Parameters targets = ParametersCsvParser.parseParamFiles(null, fileSet);
        TupleUtils.solve(targets.getValues());
        int count = 0;
        ArrayList<WritableTuple> userTargets = new ArrayList<WritableTuple>();
        for (WritableTuple v : targets.getValues()) {
            KeyValueTuple t = new KeyValueTuple();
            for (String col : v.getColNames()) {
                t.set("user_" + col, v.get(col));
            }
            t.set(Parameters.ID_COLUMN, (Object)count++);
            userTargets.add((WritableTuple)t);
        }
        targets = new Parameters();
        targets.setValues(userTargets);
        return targets;
    }

    public static Parameters parseParamFiles(Parameters targets, Set<String> paramFileSet) throws IOException {
        System.out.println(">> Start of parseParamFiles " + paramFileSet.toString());
        if (targets == null) {
            targets = new Parameters();
        }
        if (paramFileSet.isEmpty()) {
            return targets;
        }
        String fString = paramFileSet.iterator().next();
        File f = new File(fString);
        paramFileSet.remove(fString);
        HashSet<String> paramFileSetDone = new HashSet<String>();
        if (0 < targets.getValues().size()) {
            paramFileSetDone = (Set)targets.getValues().get(0).get("parameters");
        }
        if (paramFileSetDone.contains(fString)) {
            return ParametersCsvParser.parseParamFiles(targets, paramFileSet);
        }
        paramFileSetDone.add(fString);
        List<Tuple> tupleLst = ParametersCsvParser.asTuples(f);
        tupleLst = ParametersCsvParser.updatePath(tupleLst, "workflow", f);
        HashSet<String> newParamFileSet = ParametersCsvParser.getParamFiles(tupleLst, f);
        newParamFileSet.removeAll(paramFileSetDone);
        paramFileSet.addAll(newParamFileSet);
        tupleLst = ParametersCsvParser.expand(tupleLst);
        targets = ParametersCsvParser.join(targets, tupleLst);
        targets = ParametersCsvParser.addParsedFile(targets, paramFileSetDone);
        return ParametersCsvParser.parseParamFiles(targets, paramFileSet);
    }

    private static List<Tuple> expand(List<Tuple> tupleLst) {
        ArrayList<Tuple> resultLst = new ArrayList<Tuple>();
        for (Tuple t : tupleLst) {
            ArrayList<Object> expandedTupleLst = new ArrayList<Object>();
            expandedTupleLst.add(new KeyValueTuple(t));
            for (String col : t.getColNames()) {
                if (col.equals("parameters")) continue;
                List<String> values = ParametersCsvParser.asList(t, col);
                ArrayList<KeyValueTuple> expandedTupleLstTmp = new ArrayList<KeyValueTuple>();
                for (WritableTuple writableTuple : expandedTupleLst) {
                    for (String v : values) {
                        KeyValueTuple ewt = new KeyValueTuple((Tuple)writableTuple);
                        ewt.set(col, (Object)v);
                        expandedTupleLstTmp.add(ewt);
                    }
                }
                expandedTupleLst.clear();
                expandedTupleLst.addAll(expandedTupleLstTmp);
            }
            resultLst.addAll(expandedTupleLst);
        }
        return resultLst;
    }

    private static List<String> asList(Tuple t, String col) {
        String s = t.getString(col);
        if (null == s) {
            return new ArrayList<String>(Arrays.asList(""));
        }
        Pattern pattern = Pattern.compile("([+-]?[0-9]+)\\.\\.([+-]?[0-9]+)");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            ArrayList<String> seq = new ArrayList<String>();
            int first = Integer.parseInt(matcher.group(1));
            int second = Integer.parseInt(matcher.group(2));
            int from = Math.min(first, second);
            int to = Math.max(first, second);
            Integer i = from;
            while (i <= to) {
                seq.add(i.toString());
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return seq;
        }
        return t.getList(col);
    }

    private static Parameters addParsedFile(Parameters targets, Set<String> paramFileSetDone) {
        for (WritableTuple t : targets.getValues()) {
            t.set("parameters", paramFileSetDone);
        }
        return targets;
    }

    private static Parameters join(Parameters targets, List<Tuple> right) {
        ArrayList<WritableTuple> joined = new ArrayList<WritableTuple>();
        List<WritableTuple> left = targets.getValues();
        if (0 == right.size()) {
            return targets;
        }
        if (0 == left.size()) {
            for (Tuple t : right) {
                KeyValueTuple newValue = new KeyValueTuple(t);
                joined.add((WritableTuple)newValue);
            }
        } else {
            HashSet<String> joinFields = new HashSet<String>();
            for (String s : left.get(0).getColNames()) {
                joinFields.add(s);
            }
            HashSet<String> rightFields = new HashSet<String>();
            for (String s : right.get(0).getColNames()) {
                rightFields.add(s);
            }
            joinFields.remove("parameters");
            joinFields.retainAll(rightFields);
            for (WritableTuple l : left) {
                for (Tuple r : right) {
                    boolean match = true;
                    for (String field : joinFields) {
                        if (l.getString(field).equals(r.getString(field))) continue;
                        match = false;
                    }
                    if (!match) continue;
                    KeyValueTuple t = new KeyValueTuple();
                    t.set(r);
                    t.set((Tuple)l);
                    joined.add((WritableTuple)t);
                }
            }
        }
        targets = new Parameters();
        targets.setValues(joined);
        return targets;
    }

    private static List<Tuple> asTuples(File f) throws IOException {
        ArrayList<Tuple> tLst = new ArrayList<Tuple>();
        if (f.toString().endsWith(".properties")) {
            Properties p = new Properties();
            p.load(new FileInputStream(f));
            KeyValueTuple t = new KeyValueTuple();
            for (String string : p.keySet()) {
                String value = p.getProperty(string);
                t.set(string, (Object)value);
            }
            tLst.add((Tuple)t);
        } else {
            if (!f.toString().endsWith(".csv")) {
                System.out.println(">> File '" + f.toString() + "' does not end with *.properties or *.csv.");
                if (f.exists() && f.isFile()) {
                    System.out.println("\tThe file exists. We'll assume it is in the CSV-format and start parsing it...");
                } else {
                    System.out.println("\tWe couldn't find the file. We'll append the extension '.csv' and try again with");
                    System.out.println("\t" + f.toString() + ".csv");
                    f = new File(f.toString() + ".csv");
                }
            }
            for (Tuple t : new CsvReader(f)) {
                tLst.add(t);
                for (String string : t.getColNames()) {
                    if (!string.contains("_")) continue;
                    throw new IOException("Parsing " + f.getName() + " failed: column names may not contain '" + "_" + "'");
                }
            }
        }
        return tLst;
    }

    private static HashSet<String> getParamFiles(List<Tuple> tupleLst, File f) throws IOException {
        boolean noParamColumnFoundYet = true;
        String paramFilesString = null;
        HashSet<String> fileSet = new HashSet<String>();
        for (Tuple t : tupleLst) {
            for (String colName : t.getColNames()) {
                if (!colName.equals("parameters")) continue;
                if (noParamColumnFoundYet) {
                    noParamColumnFoundYet = false;
                    paramFilesString = t.getString(colName);
                    for (String fString : t.getList(colName)) {
                        if (fString.charAt(0) == '/') {
                            fileSet.add(fString);
                            continue;
                        }
                        fileSet.add(f.getParent() + File.separator + fString);
                    }
                    continue;
                }
                if (t.getString(colName).equals(paramFilesString)) continue;
                throw new IOException("Values in 'parameters' column are not equal in file '" + f.toString() + "', please fix:\n'" + t.getString(colName) + "' is different from '" + paramFilesString + "'.\n" + "You could put all values 'comma-separated' in each cell and repeat that on each line in your file, e.g.:\n" + "\"" + t.getString(colName) + "," + paramFilesString + "\"");
            }
            if (!noParamColumnFoundYet) continue;
            return fileSet;
        }
        return fileSet;
    }

    private static List<Tuple> updatePath(List<Tuple> tupleLst, String column, File f) {
        ArrayList<Tuple> tupleLstUpdated = new ArrayList<Tuple>();
        for (Tuple t : tupleLst) {
            KeyValueTuple wt = new KeyValueTuple(t);
            for (String colName : t.getColNames()) {
                if (!colName.equals(column)) continue;
                ArrayList<String> wfLst = new ArrayList<String>();
                for (String fString : t.getList(colName)) {
                    if (fString.charAt(0) == '/') {
                        wfLst.add(fString);
                        continue;
                    }
                    wfLst.add(f.getParent() + File.separator + fString);
                }
                if (wfLst.size() == 1) {
                    wt.set(colName, wfLst.get(0));
                    continue;
                }
                wt.set(colName, wfLst);
            }
            tupleLstUpdated.add((Tuple)wt);
        }
        return tupleLstUpdated;
    }
}

