/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.model;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.molgenis.compute5.model.Protocol;

public class Step {
    String name;
    Map<String, String> parameters = new LinkedHashMap<String, String>();
    Set<String> previousSteps = new HashSet<String>();
    Map<Integer, String> idJobMap = new HashMap<Integer, String>();
    Protocol protocol;

    public String getJobName(Integer id) {
        return this.idJobMap.get(id);
    }

    public void setJobName(Integer id, String name) {
        this.idJobMap.put(id, name);
    }

    public Step(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Map<String, String> getLocalGlobalParameterMap() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        this.previousSteps.clear();
        for (String parameter : this.getParameters().values()) {
            if (parameter.startsWith("user_")) continue;
            int ps = parameter.indexOf("_");
            if (-1 == ps) {
                System.err.println(">> ERROR >> In your workflow in step '" + this.getName() + "', it is unclear from which step your parameter value '=" + parameter + "' originates. Please prepend user_ or step1_ or similar.");
                System.err.println(">> Exit with exit status 1.");
                System.exit(1);
            }
            this.previousSteps.add(parameter.substring(0, ps));
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Set<String> getPreviousSteps() {
        return this.previousSteps;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

