/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class TupleUtils {
    public static List<WritableTuple> collapse(List<? extends Tuple> parameters, List<String> targets) {
        LinkedHashMap<String, KeyValueTuple> result = new LinkedHashMap<String, KeyValueTuple>();
        for (Tuple tuple : parameters) {
            String key = "";
            for (String target : targets) {
                key = key + tuple.getString(target) + "_";
            }
            if (result.get(key) == null) {
                KeyValueTuple collapsedRow = new KeyValueTuple();
                for (String col : tuple.getColNames()) {
                    if (targets.contains(col)) {
                        collapsedRow.set(col, tuple.get(col));
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(tuple.get(col));
                    collapsedRow.set(col, list);
                }
                result.put(key, collapsedRow);
                continue;
            }
            for (String col : tuple.getColNames()) {
                if (targets.contains(col)) continue;
                List list = (List)((WritableTuple)result.get(key)).get(col);
                list.add(tuple.getString(col));
                ((WritableTuple)result.get(key)).set(col, (Object)list);
            }
        }
        return new ArrayList<WritableTuple>(result.values());
    }

    public static void solve(List<WritableTuple> values) throws IOException {
        Configuration conf = new Configuration();
        boolean done = false;
        while (!done) {
            boolean updated = false;
            String unsolved = "";
            for (WritableTuple t : values) {
                for (String col : t.getColNames()) {
                    String original = t.getString(col);
                    if (!original.contains("${")) continue;
                    if (original.contains("${" + col + "}")) {
                        throw new IOException("could not solve " + col + "='" + original + "' because template references to self");
                    }
                    Template template = new Template(col, (Reader)new StringReader(original), conf);
                    StringWriter out = new StringWriter();
                    try {
                        Map<String, Object> map = TupleUtils.toMap((Tuple)t);
                        template.process(map, (Writer)out);
                        String value = out.toString();
                        if (value.equals(original)) continue;
                        updated = true;
                        t.set(col, (Object)value);
                    }
                    catch (Exception e) {
                        unsolved = unsolved + "could not solve " + col + "='" + original + "': " + e.getMessage() + "\n";
                    }
                }
            }
            if (updated) continue;
            if (unsolved.length() > 0) {
                throw new IOException(unsolved);
            }
            done = true;
        }
    }

    public static Map<String, Object> toMap(Tuple t) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key : t.getColNames()) {
            if (key.contains("_")) {
                String[] els = key.split("\\_");
                Map<String, Object> map = result;
                for (String el : els) {
                    if (el.equals(els[els.length - 1])) {
                        map.put(el, t.get(key));
                        continue;
                    }
                    if (!map.containsKey(el)) {
                        map.put(el, new LinkedHashMap());
                    }
                    map = (Map)map.get(el);
                }
                continue;
            }
            result.put(key, t.get(key));
        }
        return result;
    }

    public static <E extends Tuple> List<E> uncollapse(List<E> values, String idColumn) {
        ArrayList<KeyValueTuple> result = new ArrayList<KeyValueTuple>();
        for (Tuple original : values) {
            if (!(original.get(idColumn) instanceof List)) {
                return values;
            }
            for (int i = 0; i < original.getList(idColumn).size(); ++i) {
                KeyValueTuple copy = new KeyValueTuple();
                for (String col : original.getColNames()) {
                    if (original.get(col) instanceof List) {
                        copy.set(col, original.getList(col).get(i));
                        continue;
                    }
                    copy.set(col, original.get(col));
                }
                result.add(copy);
            }
        }
        return result;
    }
}

