/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.compute5.ComputeProperties;
import org.molgenis.compute5.generators.TupleUtils;
import org.molgenis.compute5.model.Input;
import org.molgenis.compute5.model.Output;
import org.molgenis.compute5.model.Parameters;
import org.molgenis.compute5.model.Step;
import org.molgenis.compute5.model.Task;
import org.molgenis.compute5.model.Workflow;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class TaskGenerator {
    public static List<Task> generate(Workflow workflow, Parameters parameters, ComputeProperties computeProperties) throws IOException {
        ArrayList<Task> result = new ArrayList<Task>();
        List<WritableTuple> globalParameters = parameters.getValues();
        for (Step step : workflow.getSteps()) {
            List<WritableTuple> localParameters = TaskGenerator.mapGlobalToLocalParameters(globalParameters, step);
            localParameters = TaskGenerator.collapseOnTargets(localParameters, step);
            localParameters = TaskGenerator.addOutputValues(step, localParameters);
            localParameters = TaskGenerator.addStepIds(localParameters, step);
            result.addAll(TaskGenerator.generateTasks(step, localParameters, workflow, computeProperties));
            localParameters = TupleUtils.uncollapse(localParameters, Parameters.ID_COLUMN);
            TaskGenerator.addLocalToGlobalParameters(step, globalParameters, localParameters);
        }
        return result;
    }

    private static Collection<? extends Task> generateTasks(Step step, List<WritableTuple> localParameters, Workflow workflow, ComputeProperties computeProperties) throws IOException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (WritableTuple target : localParameters) {
            Task task = new Task(target.getString(Task.TASKID_COLUMN));
            try {
                Map<String, Object> map = TupleUtils.toMap((Tuple)target);
                task.setParameters(map);
                for (Integer id : target.getIntList(Parameters.ID_COLUMN)) {
                    step.setJobName(id, task.getName());
                }
                String parameterHeader = "\n#\n## Generated header\n#\n";
                parameterHeader = parameterHeader + "\n# Load parameters from previous steps\n" + Parameters.SOURCE_COMMAND + " " + Parameters.ENVIRONMENT_DIR_VARIABLE + File.separator + Parameters.ENVIRONMENT + "\n\n";
                for (String previousStepName : step.getPreviousSteps()) {
                    Step prevStep = workflow.getStep(previousStepName);
                    for (Integer id : target.getIntList(Parameters.ID_COLUMN)) {
                        String prevJobName = prevStep.getJobName(id);
                        if (task.getPreviousTasks().contains(prevJobName)) continue;
                        task.getPreviousTasks().add(prevJobName);
                        parameterHeader = parameterHeader + Parameters.SOURCE_COMMAND + " " + Parameters.ENVIRONMENT_DIR_VARIABLE + File.separator + prevJobName + Parameters.ENVIRONMENT_EXTENSION + "\n";
                    }
                }
                parameterHeader = parameterHeader + "\n# Assign values to the parameters in this script\n";
                parameterHeader = parameterHeader + "\n# Set taskId, which is the job name of this task";
                parameterHeader = parameterHeader + "\ntaskId=\"" + task.getName() + "\"\n";
                parameterHeader = parameterHeader + "\n# Make compute.properties available";
                parameterHeader = parameterHeader + "\nrundir=\"" + computeProperties.runDir + "\"";
                parameterHeader = parameterHeader + "\nrunid=\"" + computeProperties.runId + "\"";
                parameterHeader = parameterHeader + "\nworkflow=\"" + computeProperties.workFlow + "\"";
                parameterHeader = parameterHeader + "\nparameters=\"" + computeProperties.parametersString() + "\"";
                parameterHeader = parameterHeader + "\nuser=\"" + computeProperties.user + "\"";
                parameterHeader = parameterHeader + "\ndatabase=\"" + computeProperties.database + "\"";
                parameterHeader = parameterHeader + "\nbackend=\"" + computeProperties.backend + "\"";
                parameterHeader = parameterHeader + "\nport=\"" + computeProperties.port + "\"";
                parameterHeader = parameterHeader + "\ninterval=\"" + computeProperties.interval + "\"";
                parameterHeader = parameterHeader + "\npath=\"" + computeProperties.path + "\"";
                parameterHeader = parameterHeader + "\n\n# Connect parameters to environment\n";
                for (Input input : step.getProtocol().getInputs()) {
                    String p = input.getName();
                    List rowIndex = target.getList(Parameters.ID_COLUMN);
                    for (int i = 0; i < rowIndex.size(); ++i) {
                        Object rowIndexObject = rowIndex.get(i);
                        String rowIndexString = rowIndexObject.toString();
                        parameterHeader = parameterHeader + p + "[" + i + "]=${" + step.getParameters().get(p) + "[" + rowIndexString + "]}\n";
                    }
                }
                parameterHeader = parameterHeader + "\n# Validate that each 'value' parameter has only identical values in its list\n" + "# We do that to protect you against parameter values that might not be correctly set at runtime.\n";
                for (Input input : step.getProtocol().getInputs()) {
                    boolean isList = Parameters.LIST_INPUT.equals(input.getType());
                    if (isList) continue;
                    String p = input.getName();
                    parameterHeader = parameterHeader + "if [[ ! $(IFS=$'\\n' sort -u <<< \"${" + p + "[*]}\" | wc -l | sed -e 's/^[[:space:]]*//') = 1 ]]; then echo \"Error in Step '" + step.getName() + "': input parameter '" + p + "' is an array with different values. Maybe '" + p + "' is a runtime parameter with 'more variable' values than what was folded on generation-time?\" >&2; exit 1; fi\n";
                }
                parameterHeader = parameterHeader + "\n#\n## Start of your protocol template\n#\n\n";
                String script = step.getProtocol().getTemplate();
                script = parameterHeader + script;
                String myEnvironmentFile = Parameters.ENVIRONMENT_DIR_VARIABLE + File.separator + task.getName() + Parameters.ENVIRONMENT_EXTENSION;
                script = script + "\n#\n## End of your protocol template\n#\n";
                script = script + "\n# Save output in environment file: '" + myEnvironmentFile + "' with the output vars of this step\n";
                for (String p : map.keySet()) {
                    for (Output o : step.getProtocol().getOutputs()) {
                        if (!o.getName().equals(p)) continue;
                        String line = "if [[ -z \"$" + p + "\" ]]; then echo \"In step '" + step.getName() + "', parameter '" + p + "' has no value! Please assign a value to parameter '" + p + "'." + "\" >&2; exit 1; fi\n";
                        List rowIndex = target.getList(Parameters.ID_COLUMN);
                        for (int i = 0; i < rowIndex.size(); ++i) {
                            Object rowIndexObject = rowIndex.get(i);
                            String rowIndexString = rowIndexObject.toString();
                            line = line + "echo \"" + step.getName() + "_" + p + "[" + rowIndexString + "]=${" + p + "[" + i + "]}\" >> " + myEnvironmentFile + "\n";
                        }
                        script = script + line;
                    }
                }
                script = TaskGenerator.appendToEnv(script, "", myEnvironmentFile);
                script = script + "\n";
                task.setScript(script);
            }
            catch (Exception e) {
                throw new IOException("Generation of protocol '" + step.getProtocol().getName() + "' failed: " + e.getMessage() + ".\nParameters used: " + target);
            }
            tasks.add(task);
        }
        return tasks;
    }

    private static String appendToEnv(String script, String string, String thisFile) {
        String appendString = "echo \"" + string + "\" >> " + thisFile;
        return script + "\n" + appendString;
    }

    private static String guessParametersNeeded(String ftl) {
        HashSet<String> params = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(ftl);
        while (matcher.find()) {
            params.add(matcher.group(0).replace("{", "").replace("}", ""));
        }
        String result = "\nParameters ${x} refered include:";
        for (String p : params) {
            result = result + "\n" + p;
        }
        return result;
    }

    private static List<WritableTuple> addStepIds(List<WritableTuple> localParameters, Step step) {
        int stepId = 0;
        for (WritableTuple target : localParameters) {
            String name = step.getName() + "_" + stepId;
            target.set(Task.TASKID_COLUMN, (Object)name);
            target.set("taskIdIndex", (Object)stepId++);
        }
        return localParameters;
    }

    private static void addLocalToGlobalParameters(Step step, List<WritableTuple> globalParameters, List<WritableTuple> localParameters) {
        for (int i = 0; i < localParameters.size(); ++i) {
            WritableTuple local = localParameters.get(i);
            for (String localName : local.getColNames()) {
                if (localName.contains("_")) continue;
                globalParameters.get(i).set(step.getName() + "_" + localName, local.get(localName));
            }
        }
    }

    private static List<WritableTuple> addOutputValues(Step step, List<WritableTuple> localParameters) {
        for (WritableTuple target : localParameters) {
            target.set("queue", (Object)step.getProtocol().getQueue());
            target.set("nodes", (Object)step.getProtocol().getNodes());
            target.set("ppn", (Object)step.getProtocol().getPpn());
            target.set("walltime", (Object)step.getProtocol().getWalltime());
            target.set("mem", (Object)step.getProtocol().getMemory());
            for (Output o : step.getProtocol().getOutputs()) {
                target.set(o.getName(), (Object)o.getValue());
            }
        }
        return localParameters;
    }

    private static List<WritableTuple> collapseOnTargets(List<WritableTuple> localParameters, Step step) {
        ArrayList<String> targets = new ArrayList<String>();
        for (Input i : step.getProtocol().getInputs()) {
            String origin = step.getParameters().get(i.getName());
            boolean initialized = origin.startsWith("user_");
            boolean isList = Parameters.LIST_INPUT.equals(i.getType());
            if (isList || !initialized) continue;
            targets.add(i.getName());
        }
        if (0 == targets.size()) {
            return localParameters;
        }
        return TupleUtils.collapse(localParameters, targets);
    }

    private static List<WritableTuple> mapGlobalToLocalParameters(List<WritableTuple> globalParameters, Step step) throws IOException {
        ArrayList<WritableTuple> localParameters = new ArrayList<WritableTuple>();
        for (WritableTuple global : globalParameters) {
            KeyValueTuple local = new KeyValueTuple();
            local.set(Parameters.ID_COLUMN, global.get(Parameters.ID_COLUMN));
            for (Input i : step.getProtocol().getInputs()) {
                String localName = i.getName();
                String globalName = step.getLocalGlobalParameterMap().get(localName);
                if (globalName == null) {
                    throw new IOException("Generation of step '" + step.getName() + "' failed: mapping of input '" + localName + "' is missing from workflow file.\nProvided mappings: " + step.getLocalGlobalParameterMap());
                }
                boolean found = false;
                for (String col : global.getColNames()) {
                    if (!globalName.equals(col)) continue;
                    found = true;
                }
                if (!found) {
                    throw new IOException("Generation of step '" + step.getName() + "' failed: mapped input '" + globalName + "' is missing from parameter file(s).\nProvided parameters: " + globalParameters);
                }
                local.set(localName, global.get(globalName));
            }
            localParameters.add((WritableTuple)local);
        }
        return localParameters;
    }
}

