/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.molgenis.compute5.model.Compute;
import org.molgenis.compute5.model.Parameters;
import org.molgenis.compute5.model.Step;
import org.molgenis.compute5.model.Task;
import org.molgenis.util.tuple.WritableTuple;

public class EnvironmentGenerator {
    public String getEnvironment(Compute compute) {
        String output = "#\n## User parameters\n#\n";
        HashSet<String> userInputParamSet = new HashSet<String>();
        Iterator<Step> itStep = compute.getWorkflow().getSteps().iterator();
        while (itStep.hasNext()) {
            Map<String, String> pmap = itStep.next().getParameters();
            for (String value : pmap.values()) {
                Integer prefLength;
                if (!value.substring(0, prefLength = Integer.valueOf("user_".length())).equals("user_")) continue;
                userInputParamSet.add(value);
            }
        }
        for (String p : userInputParamSet) {
            for (WritableTuple wt : compute.getParameters().getValues()) {
                Integer index = null;
                String value = null;
                for (String col : wt.getColNames()) {
                    if (col.equals(p)) {
                        value = wt.getString(col);
                    }
                    if (!col.equals("user_" + Task.TASKID_COLUMN)) continue;
                    index = wt.getInt(col);
                }
                String assignment = p + "[" + index + "]=\"" + value + "\"\n";
                if (index == null || value == null) {
                    try {
                        throw new Exception("Cannot add the following assignment to " + Parameters.ENVIRONMENT_FULLPATH + ":\n" + assignment);
                    }
                    catch (Exception e) {
                        System.err.println("In your workflow.csv you maybe refer to a parameter '" + p + "' to which you did not assign a value in your parameters.csv. If so: please add that the parameter to your parameters.csv");
                        e.printStackTrace();
                        System.err.println("Exit with code 1.");
                        System.exit(1);
                    }
                }
                output = output + assignment;
            }
        }
        return output;
    }

    public void generate(Compute compute, String workDir) {
        Parameters.ENVIRONMENT_FULLPATH = workDir + File.separator + Parameters.ENVIRONMENT;
        File env = new File(Parameters.ENVIRONMENT_FULLPATH);
        env.delete();
        try {
            compute.setUserEnvironment(this.getEnvironment(compute));
            env.createNewFile();
            BufferedWriter output = new BufferedWriter(new FileWriter(env, true));
            output.write(this.getEnvironment(compute));
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

