/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.molgenis.compute5.model.Parameters;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.WritableTuple;

public class DocTotalParametersCsvGenerator {
    public void generate(File file, Parameters parameters) throws IOException {
        try {
            file.getParentFile().mkdirs();
            List<WritableTuple> values = parameters.getValues();
            CsvWriter w = new CsvWriter((Writer)new FileWriter(file));
            for (int i = 0; i < values.size(); ++i) {
                if (i == 0) {
                    w.writeColNames(values.get(0).getColNames());
                }
                w.write((Tuple)values.get(i));
            }
            w.close();
            System.out.println("Generated " + file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IOException("Failed to write all parameters to " + file + ": " + e.getMessage());
        }
    }
}

