/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CreateWorkflowGenerator {
    public CreateWorkflowGenerator(String createWorkflowDir) {
        File target = new File(createWorkflowDir);
        String sourcePath = "workflows/myworkflow";
        File source = new File(sourcePath);
        if (!source.exists()) {
            System.err.println(">> ERROR >> Directory '" + source.toString() + "' not found. Please run this command from the directory where molgenis-compute.sh is located, where " + " the relative path to this directory exists." + "\n\nTODO for development team:" + " please add this path to the classpath so that it's accessible from everywhere.");
            System.err.println("Exit with code 1.");
            System.exit(1);
        } else {
            try {
                CreateWorkflowGenerator.copyFolder(source, target.getAbsoluteFile());
                System.out.println("Created new workflow design in '" + target + "'.");
                System.out.println("You can generate the corresponding workflow by changing to that directory and executing 'molgenis_compute.sh -g'");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                CreateWorkflowGenerator.copyFolder(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

