/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.generators;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.molgenis.compute5.model.Task;

public class BackendGenerator {
    private String headerTemplate;
    private String footerTemplate;
    private String submitTemplate;

    public BackendGenerator(String headerTemplate, String footerTemplate, String submitTemplate) throws IOException {
        this.setHeaderTemplate(this.readFile(headerTemplate));
        this.setFooterTemplate(this.readFile(footerTemplate));
        this.setSubmitTemplate(this.readFile(submitTemplate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String file) throws IOException {
        URL header = this.getClass().getResource(file);
        if (header == null) {
            throw new IOException("file " + file + " is missing for backend " + this.getClass().getSimpleName());
        }
        BufferedReader stream = new BufferedReader(new InputStreamReader(header.openStream()));
        StringBuilder result = new StringBuilder();
        try {
            String inputLine;
            while ((inputLine = stream.readLine()) != null) {
                result.append(inputLine + "\n");
            }
        }
        finally {
            stream.close();
        }
        return result.toString();
    }

    public void generate(List<Task> tasks, File targetDir) throws IOException {
        Configuration conf = new Configuration();
        Template header = new Template("header", (Reader)new StringReader(this.getHeaderTemplate()), conf);
        Template footer = new Template("footer", (Reader)new StringReader(this.getFooterTemplate()), conf);
        Template submit = new Template("submit", (Reader)new StringReader(this.getSubmitTemplate()), conf);
        try {
            File outFile = new File(targetDir.getAbsolutePath() + "/submit.sh");
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            HashMap<String, List<Task>> taskMap = new HashMap<String, List<Task>>();
            taskMap.put("tasks", tasks);
            submit.process(taskMap, (Writer)out);
            ((Writer)out).close();
            System.out.println("Generated " + outFile);
        }
        catch (TemplateException e) {
            throw new IOException("Backend generation failed for " + this.getClass().getSimpleName() + "\n\nError is:\n" + e.toString());
        }
        for (Task task : tasks) {
            try {
                File outFile = new File(targetDir.getAbsolutePath() + "/" + task.getName() + ".sh");
                BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
                header.process(task.getParameters(), (Writer)out);
                out.write("\n" + task.getScript() + "\n");
                footer.process(task.getParameters(), (Writer)out);
                ((Writer)out).close();
                System.out.println("Generated " + outFile);
            }
            catch (TemplateException e) {
                throw new IOException("Backend generation of task '" + task.getName() + "' failed for " + this.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    public String getHeaderTemplate() {
        return this.headerTemplate;
    }

    public void setHeaderTemplate(String headerTemplate) {
        this.headerTemplate = headerTemplate;
    }

    public void appendCustomHeader(String customHeader) {
        this.headerTemplate = this.headerTemplate + "\n" + customHeader;
    }

    public String getFooterTemplate() {
        return this.footerTemplate;
    }

    public void setFooterTemplate(String footerTemplate) {
        this.footerTemplate = footerTemplate;
    }

    public void appendCustomFooter(String customFooter) {
        this.footerTemplate = this.footerTemplate + "\n" + customFooter;
    }

    public String getSubmitTemplate() {
        return this.submitTemplate;
    }

    public void setSubmitTemplate(String submitTemplate) {
        this.submitTemplate = submitTemplate;
    }
}

