/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.db.api;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.molgenis.compute5.db.api.ApiException;
import org.molgenis.compute5.db.api.ApiResponse;
import org.molgenis.compute5.db.api.ComputeDbApiConnection;

public class HttpClientComputeDbApiConnection
implements ComputeDbApiConnection {
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private final String apiBaseUri;
    private final DefaultHttpClient httpClient = new DefaultHttpClient();
    private final HttpHost targetHost;

    public HttpClientComputeDbApiConnection(String host, String strPort, String apiBaseUri, String username, String password) {
        this.apiBaseUri = apiBaseUri;
        int port = Integer.parseInt(strPort);
        this.targetHost = new HttpHost(host, port);
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.targetHost.getHostName(), this.targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends ApiResponse> T doRequest(Object request, String uri, Class<T> returnType) throws ApiException {
        ApiResponse apiResponse;
        HttpPost httpPost = new HttpPost(this.apiBaseUri + uri);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localcontext = new BasicHttpContext();
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        InputStreamReader reader = null;
        try {
            HttpResponse httpResponse;
            int statusCode;
            if (request != null) {
                String json = new Gson().toJson(request);
                httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            }
            if ((statusCode = (httpResponse = this.httpClient.execute(this.targetHost, (HttpRequest)httpPost, (HttpContext)localcontext)).getStatusLine().getStatusCode()) != 200) {
                throw new ApiException("Api service returned statuscode " + statusCode);
            }
            reader = new InputStreamReader(httpResponse.getEntity().getContent(), CHARSET_UTF_8);
            apiResponse = (ApiResponse)new Gson().fromJson((Reader)reader, returnType);
        }
        catch (ClientProtocolException e) {
            try {
                throw new ApiException("Exception calling api service", e);
                catch (IOException e2) {
                    throw new ApiException("Exception calling api service", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                httpPost.reset();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        httpPost.reset();
        return (T)apiResponse;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.getConnectionManager().shutdown();
    }
}

