/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5.db.api;

import java.io.IOException;
import org.molgenis.compute5.db.api.ApiException;
import org.molgenis.compute5.db.api.ApiResponse;
import org.molgenis.compute5.db.api.ComputeDbApiConnection;
import org.molgenis.compute5.db.api.CreateRunRequest;
import org.molgenis.compute5.db.api.GetBackendsResponse;
import org.molgenis.compute5.db.api.HttpClientComputeDbApiConnection;
import org.molgenis.compute5.db.api.ResubmitFailedTasksRequest;
import org.molgenis.compute5.db.api.ResubmitFailedTasksResponse;
import org.molgenis.compute5.db.api.RunStatusRequest;
import org.molgenis.compute5.db.api.RunStatusResponse;
import org.molgenis.compute5.db.api.StartRunRequest;
import org.molgenis.compute5.db.api.StopRunRequest;

public class ComputeDbApiClient {
    private final ComputeDbApiConnection computeDbApiConnection;

    public ComputeDbApiClient(ComputeDbApiConnection computeDbApiConnection) {
        this.computeDbApiConnection = computeDbApiConnection;
    }

    public ApiResponse start(StartRunRequest request) throws ApiException {
        return this.computeDbApiConnection.doRequest(request, "/start", ApiResponse.class);
    }

    public ApiResponse stop(StopRunRequest request) throws ApiException {
        return this.computeDbApiConnection.doRequest(request, "/stop", ApiResponse.class);
    }

    public RunStatusResponse getRunStatus(RunStatusRequest request) throws ApiException {
        return this.computeDbApiConnection.doRequest(request, "/get-run-status", RunStatusResponse.class);
    }

    public GetBackendsResponse getBackends() throws ApiException {
        return this.computeDbApiConnection.doRequest(null, "/get-backends", GetBackendsResponse.class);
    }

    public ApiResponse createRun(CreateRunRequest request) throws ApiException {
        return this.computeDbApiConnection.doRequest(request, "/create-run", ApiResponse.class);
    }

    public ResubmitFailedTasksResponse resubmitFailedTasks(ResubmitFailedTasksRequest request) throws ApiException {
        return this.computeDbApiConnection.doRequest(request, "/resubmit-failed-tasks", ResubmitFailedTasksResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ApiException, IOException {
        HttpClientComputeDbApiConnection con = new HttpClientComputeDbApiConnection("localhost", "8080", "/api/v1", "admin", "admin");
        try {
            ComputeDbApiClient client = new ComputeDbApiClient(con);
            ResubmitFailedTasksResponse response = client.resubmitFailedTasks(new ResubmitFailedTasksRequest("nbic25"));
            System.out.println(response);
        }
        finally {
            con.close();
        }
    }
}

