/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.RandomStringUtils;
import org.molgenis.compute5.model.Parameters;

public class ComputeProperties {
    public File propertiesFile;
    public String path = ".";
    public String workFlow = "workflow.csv";
    public String defaults = null;
    public String defaultsCommandLine = null;
    public String[] parameters = new String[]{"parameters.csv"};
    public String backend = "localhost";
    public String runDir = "rundir";
    public String runId = Parameters.RUNID_DEFAULT;
    public String database = "none";
    public String port = "8080";
    public String interval = "2000";
    public String user = "get user name from system";
    public String pass = "xxx";
    public boolean showHelp = false;
    public boolean databaseStart = false;
    public boolean databaseEnd = false;
    public boolean generate = false;
    public boolean list = false;
    public boolean create = false;
    public String createWorkflow = "myworkflow";
    public boolean execute = false;

    public ComputeProperties(String[] args) {
        Options options = this.createOptions();
        try {
            CommandLine cl = new PosixParser().parse(options, args);
            boolean bl = this.showHelp = cl.hasOption("help") || 0 == cl.getOptions().length;
            if (this.showHelp) {
                throw new ParseException("");
            }
            this.setPath(args);
            if (this.create) {
                return;
            }
            this.updateDefaultParameterValues(this.path);
            this.user = System.getProperty("user.name");
            this.createPropertiesFile();
            this.parseProperties();
            this.parseCommandLine(args);
            this.updateWorkflowParameterDefaultsCSV();
            this.saveProperties();
        }
        catch (ParseException e) {
            this.showHelp = true;
            System.err.println(e.getMessage() + "\n");
            new HelpFormatter().printHelp("sh molgenis-compute.sh -p parameters.csv", options);
        }
    }

    public ComputeProperties(String path) {
        this.path = path;
        this.updateDefaultParameterValues(path);
        this.createPropertiesFile();
        this.parseProperties();
        this.saveProperties();
    }

    private void updateWorkflowParameterDefaultsCSV() {
        if (null != this.defaultsCommandLine) {
            if (!new File(this.defaultsCommandLine).exists()) {
                System.err.println(">> ERROR >> '-defaults " + this.defaultsCommandLine + "' does not exist!");
                System.err.println("Exit with code 1");
                System.exit(1);
            } else {
                this.defaults = this.defaultsCommandLine;
            }
        } else {
            File workflowFile = new File(this.workFlow);
            String workflowFilePath = workflowFile.getParent();
            String workflowName = workflowFile.getName();
            workflowName = workflowName.substring(0, workflowName.indexOf(46));
            File defaultsFileTest = new File(workflowFilePath + File.separator + workflowName + "." + "defaults.csv");
            if (defaultsFileTest.exists()) {
                this.defaults = defaultsFileTest.toString();
            } else {
                defaultsFileTest = new File(workflowFilePath + File.separator + "defaults.csv");
                if (defaultsFileTest.exists()) {
                    this.defaults = defaultsFileTest.toString();
                }
            }
        }
    }

    private void updateDefaultParameterValues(String path) {
        this.workFlow = this.updatePath(path, this.workFlow);
        ArrayList<String> pathParameters = new ArrayList<String>();
        for (String p : this.parameters) {
            pathParameters.add(this.updatePath(path, p));
        }
        this.parameters = pathParameters.toArray(new String[pathParameters.size()]);
    }

    private String updatePath(String path, String fileName) {
        if (fileName.startsWith("/") || fileName.startsWith("~")) {
            return fileName;
        }
        return path + (path.endsWith("/") ? "" : "/") + fileName;
    }

    private void setPath(String[] args) {
        Options options = this.createOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            this.path = cmd.getOptionValue("path", this.path);
            this.path = this.path + (this.path.endsWith("/") ? "" : "/");
            this.create = cmd.hasOption("create");
            if (this.create) {
                this.createWorkflow = cmd.getOptionValue("create", this.createWorkflow);
                this.createWorkflow = this.updatePath(this.path, this.createWorkflow);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void createPropertiesFile() {
        String propFileString = "compute.properties";
        this.propertiesFile = new File(propFileString);
        if (!this.propertiesFile.exists()) {
            try {
                this.propertiesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void parseProperties() {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(this.propertiesFile));
            this.path = p.getProperty("path", this.path);
            this.workFlow = p.getProperty("workflow", this.workFlow);
            this.defaults = p.getProperty("defaults", this.defaults);
            this.backend = p.getProperty("backend", this.backend);
            this.runDir = p.getProperty("rundir", this.runDir);
            this.runId = p.getProperty("runid", this.runId);
            this.database = p.getProperty("database", this.database);
            this.port = p.getProperty("port", this.port);
            this.interval = p.getProperty("interval", this.interval);
            this.user = p.getProperty("user", this.user);
            String parametersCSVString = p.getProperty("parameters");
            if (null != parametersCSVString) {
                this.parameters = parametersCSVString.split("\\s*,\\s*");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseCommandLine(String[] args) {
        Options options = this.createOptions();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            this.showHelp = cmd.hasOption("help");
            if (this.showHelp) {
                throw new ParseException("");
            }
            this.path = cmd.getOptionValue("path", this.path);
            this.path = this.path + (this.path.endsWith("/") ? "" : "/");
            this.workFlow = this.getFullPath(cmd, "w", this.workFlow);
            this.defaultsCommandLine = this.getFullPath(cmd, "defaults", null);
            this.backend = cmd.getOptionValue("b", this.backend);
            this.runDir = cmd.getOptionValue("rundir", this.runDir);
            this.database = cmd.getOptionValue("d", this.database);
            this.port = cmd.getOptionValue("port", this.port);
            this.databaseStart = cmd.hasOption("dbs");
            this.databaseEnd = cmd.hasOption("dbe");
            this.interval = cmd.getOptionValue("interval", this.interval);
            this.user = cmd.getOptionValue("u", this.user);
            this.pass = cmd.getOptionValue("pass", this.pass);
            this.generate = cmd.hasOption("g") || cmd.hasOption("w") && cmd.hasOption("p");
            this.runId = cmd.getOptionValue("runid", this.runId);
            if (null == this.runId) {
                this.runId = RandomStringUtils.random((int)4, (boolean)true, (boolean)true);
            }
            this.execute = cmd.hasOption("r") || cmd.hasOption("w") && cmd.hasOption("p");
            this.list = cmd.hasOption("list");
            String[] cmdParameters = cmd.getOptionValues("p");
            if (null != (cmdParameters = this.getFullPath(cmdParameters))) {
                this.parameters = cmdParameters;
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage() + "\n");
            new HelpFormatter().printHelp("compute -p parameters.csv", options);
        }
    }

    private String[] getFullPath(String[] cmdParameters) {
        if (null == cmdParameters) {
            return null;
        }
        ArrayList<String> pathParameters = new ArrayList<String>();
        for (String p : cmdParameters) {
            pathParameters.add(this.updatePath(this.path, p));
        }
        return pathParameters.toArray(new String[pathParameters.size()]);
    }

    private String getFullPath(CommandLine cmd, String cmndlineOption, String defaultValue) {
        String option = cmd.getOptionValue(cmndlineOption);
        if (null == option) {
            return defaultValue;
        }
        return this.updatePath(this.path, option);
    }

    public void saveProperties() {
        Properties p = new Properties();
        try {
            p.setProperty("path", this.path);
            p.setProperty("parameters", this.parametersString());
            p.setProperty("workflow", this.workFlow);
            if (null != this.defaults) {
                p.setProperty("defaults", this.defaults);
            }
            p.setProperty("backend", this.backend);
            p.setProperty("rundir", this.runDir);
            p.setProperty("runid", this.runId);
            p.setProperty("database", this.database);
            p.setProperty("port", this.port);
            p.setProperty("interval", this.interval);
            p.setProperty("user", this.user);
            p.store(new FileOutputStream(this.propertiesFile), "This file contains your molgenis-compute properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parametersString() {
        return Joiner.on((String)",").join((Object[])this.parameters);
    }

    public Options createOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to directory this generates to. Default: <current dir>.");
        OptionBuilder.withLongOpt((String)"path");
        Option path = OptionBuilder.create((String)"path");
        OptionBuilder.withArgName((String)"parameters.csv");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"parameters");
        OptionBuilder.withDescription((String)"Path to parameter.csv file(s). Default: parameters.csv");
        Option p = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"workflow.csv");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to your workflow file. Default: workflow.csv");
        OptionBuilder.withLongOpt((String)"workflow");
        Option w = OptionBuilder.create((String)"w");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to your workflow-defaults file. Default: defaults.csv");
        OptionBuilder.withLongOpt((String)"defaults");
        Option d = OptionBuilder.create((String)"defaults");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Backend for which you generate. Default: localhost");
        OptionBuilder.withLongOpt((String)"backend");
        Option b = OptionBuilder.create((String)"b");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Directory where jobs are stored");
        Option runDir = OptionBuilder.create((String)"rundir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("Id of the task set which you generate. Default: " + Parameters.RUNID_DEFAULT));
        OptionBuilder.withLongOpt((String)"runid");
        Option runId = OptionBuilder.create((String)"runid");
        OptionBuilder.withDescription((String)"Shows this help.");
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create((String)"h"));
        options.addOption(path);
        options.addOption(p);
        options.addOption(w);
        options.addOption(d);
        options.addOption(b);
        options.addOption(runDir);
        options.addOption(runId);
        OptionBuilder.withDescription((String)"Host, location of database. Default: none");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"database");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withDescription((String)"Port used to connect to databasae. Default: 8080");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"port");
        options.addOption(OptionBuilder.create((String)"port"));
        OptionBuilder.withDescription((String)"Starts the database");
        OptionBuilder.withLongOpt((String)"database-start");
        options.addOption(OptionBuilder.create((String)"dbs"));
        OptionBuilder.withDescription((String)"End the database");
        OptionBuilder.withLongOpt((String)"database-end");
        options.addOption(OptionBuilder.create((String)"dbe"));
        OptionBuilder.withDescription((String)"Generate jobs");
        OptionBuilder.withLongOpt((String)"generate");
        options.addOption(OptionBuilder.create((String)"g"));
        OptionBuilder.withDescription((String)"List jobs, generated, queued, running, completed, failed");
        OptionBuilder.withLongOpt((String)"list");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withDescription((String)"Creates empty workflow. Default name: myworkflow");
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create((String)"create"));
        OptionBuilder.withDescription((String)"Run jobs from current directory on current backend. When using --database this will return a 'id' for --pilot.");
        OptionBuilder.withLongOpt((String)"run");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withDescription((String)"Supply user name to login to your backend. Default is your own user name.");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"user");
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withDescription((String)"Supply user pass to login to your backend. Default is not saved.");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"password");
        options.addOption(OptionBuilder.create((String)"pass"));
        return options;
    }
}

