/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.compute5;

import com.google.common.base.Joiner;
import freemarker.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.BasicConfigurator;
import org.molgenis.compute5.ComputeProperties;
import org.molgenis.compute5.db.api.ComputeDbApiClient;
import org.molgenis.compute5.db.api.CreateRunRequest;
import org.molgenis.compute5.db.api.HttpClientComputeDbApiConnection;
import org.molgenis.compute5.generators.CreateWorkflowGenerator;
import org.molgenis.compute5.generators.DocTasksDiagramGenerator;
import org.molgenis.compute5.generators.DocTotalParametersCsvGenerator;
import org.molgenis.compute5.generators.DocWorkflowDiagramGenerator;
import org.molgenis.compute5.generators.EnvironmentGenerator;
import org.molgenis.compute5.generators.TaskGenerator;
import org.molgenis.compute5.generators.local.LocalBackend;
import org.molgenis.compute5.generators.pbs.PbsBackend;
import org.molgenis.compute5.model.Compute;
import org.molgenis.compute5.model.Task;
import org.molgenis.compute5.parsers.ParametersCsvParser;
import org.molgenis.compute5.parsers.WorkflowCsvParser;
import org.molgenis.util.tuple.WritableTuple;

public class ComputeCommandLine {
    public static void main(String[] args) throws ParseException, ClassNotFoundException, IOException {
        BasicConfigurator.configure();
        System.out.println("### MOLGENIS COMPUTE ###");
        String version = ComputeCommandLine.class.getPackage().getImplementationVersion();
        if (null == version) {
            version = "development";
        }
        System.out.println("Version: " + version);
        Logger.selectLoggerLibrary((int)0);
        ComputeProperties computeProperties = new ComputeProperties(args);
        try {
            if (!computeProperties.showHelp) {
                ComputeCommandLine.create(computeProperties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Compute create(ComputeProperties computeProperties) throws IOException, Exception {
        Compute compute = new Compute(computeProperties);
        if (!computeProperties.create) {
            System.out.println("Using workflow:         " + new File(computeProperties.workFlow).getAbsolutePath());
            if (ComputeCommandLine.defaultsExists(computeProperties)) {
                System.out.println("Using defaults:         " + new File(computeProperties.defaults).getAbsolutePath());
            }
            System.out.println("Using parameters:       " + Joiner.on((String)",").join((Object[])computeProperties.parameters));
            System.out.println("Using run (output) dir: " + new File(computeProperties.runDir).getAbsolutePath());
            System.out.println("Using backend:          " + computeProperties.backend);
            System.out.println("Using runID:            " + computeProperties.runId);
        }
        System.out.println("");
        if (computeProperties.create) {
            new CreateWorkflowGenerator(computeProperties.createWorkflow);
        }
        if (computeProperties.generate) {
            ComputeCommandLine.generate(compute, computeProperties);
        }
        if ("none".equals(computeProperties.database)) {
            if (computeProperties.list) {
                File[] scripts = new File(computeProperties.runDir).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String filename) {
                        return filename.endsWith(".sh");
                    }
                });
                System.out.println("Generated jobs that are ready to run:");
                if (null == scripts) {
                    System.out.println("None. Remark: the run (output) directory '" + computeProperties.runDir + "' does not exist.");
                } else if (0 == scripts.length) {
                    System.out.println("None.");
                } else {
                    for (File script : scripts) {
                        System.out.println("- " + script.getName());
                    }
                }
            }
        } else {
            String userName = computeProperties.user;
            String pass = computeProperties.pass;
            HttpClientComputeDbApiConnection dbApiConnection = new HttpClientComputeDbApiConnection(computeProperties.database, computeProperties.port, "/api/v1", userName, pass);
            ComputeDbApiClient dbApiClient = new ComputeDbApiClient(dbApiConnection);
            String runName = computeProperties.runId;
            String backendName = computeProperties.backend;
            Long pollInterval = Long.parseLong(computeProperties.interval);
            List<Task> tasks = compute.getTasks();
            String environment = compute.getUserEnvironment();
            CreateRunRequest createRunRequest = new CreateRunRequest(runName, backendName, pollInterval, tasks, environment, userName);
            dbApiClient.createRun(createRunRequest);
            if (computeProperties.execute) {
                System.out.println("Running jobs via db '" + computeProperties.database + "' on backend '" + computeProperties.backend + "'");
            }
        }
        return compute;
    }

    private static boolean defaultsExists(ComputeProperties computeProperties) throws IOException {
        if (null == computeProperties.defaults) {
            return false;
        }
        return new File(computeProperties.defaults).exists();
    }

    private static void generate(Compute compute, ComputeProperties computeProperties) throws Exception {
        ArrayList<File> parameterFiles = new ArrayList<File>();
        for (String f : computeProperties.parameters) {
            parameterFiles.add(new File(f));
        }
        if (ComputeCommandLine.defaultsExists(computeProperties)) {
            parameterFiles.add(new File(computeProperties.defaults));
        }
        compute.setParameters(ParametersCsvParser.parse(parameterFiles));
        for (WritableTuple t : compute.getParameters().getValues()) {
            t.set("user_path", (Object)computeProperties.path);
            t.set("user_workflow", (Object)computeProperties.workFlow);
            t.set("user_defaults", (Object)computeProperties.defaults);
            t.set("parameters", (Object)Joiner.on((String)",").join((Object[])computeProperties.parameters));
            t.set("user_rundir", (Object)new File(computeProperties.runDir).getAbsolutePath());
            t.set("user_runid", (Object)computeProperties.runId);
            t.set("user_backend", (Object)computeProperties.backend);
            t.set("user_database", (Object)computeProperties.database);
        }
        System.out.println("Starting script generation...");
        File dir = new File(computeProperties.runDir);
        computeProperties.runDir = dir.getCanonicalPath();
        dir.mkdirs();
        new DocTotalParametersCsvGenerator().generate(new File(computeProperties.runDir + "/doc/inputs.csv"), compute.getParameters());
        compute.setWorkflow(WorkflowCsvParser.parse(computeProperties.workFlow));
        new EnvironmentGenerator().generate(compute, computeProperties.runDir);
        compute.setTasks(TaskGenerator.generate(compute.getWorkflow(), compute.getParameters(), compute.getComputeProperties()));
        if ("pbs".equals(computeProperties.backend)) {
            new PbsBackend(computeProperties).generate(compute.getTasks(), dir);
        } else {
            new LocalBackend(computeProperties).generate(compute.getTasks(), dir);
        }
        new DocTotalParametersCsvGenerator().generate(new File(computeProperties.runDir + "/doc/outputs.csv"), compute.getParameters());
        new DocWorkflowDiagramGenerator().generate(new File(computeProperties.runDir + "/doc"), compute.getWorkflow());
        new DocTasksDiagramGenerator().generate(new File(computeProperties.runDir + "/doc"), compute.getTasks());
        System.out.println("Generation complete.");
    }

    public static Compute create(String path) throws IOException, Exception {
        ComputeProperties computeProperties = new ComputeProperties(path);
        computeProperties.generate = true;
        return ComputeCommandLine.create(computeProperties);
    }
}

